/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.maxent;

import edu.stanford.nlp.io.PrintFile;
import edu.stanford.nlp.ling.TaggedWord;
import edu.stanford.nlp.tagger.io.TaggerFileRecord;
import edu.stanford.nlp.tagger.maxent.Dictionary;
import edu.stanford.nlp.tagger.maxent.MaxentTagger;
import edu.stanford.nlp.tagger.maxent.TaggerConfig;
import edu.stanford.nlp.tagger.maxent.TestSentence;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestClassifier {
    private final TaggerFileRecord fileRecord;
    private TestSentence ts;
    private int numRight;
    private int numWrong;
    private int unknownWords;
    private int numWrongUnknown;
    private int numCorrectSentences;
    private int numSentences;
    private boolean writeUnknDict;
    private boolean writeWords;
    private boolean writeTopWords;
    private Dictionary wrongWords = new Dictionary();

    public TestClassifier(TaggerConfig config, MaxentTagger maxentTagger) throws IOException {
        this.setDebug(config.getDebug());
        this.fileRecord = TaggerFileRecord.createRecord(config, config.getFile());
        this.ts = new TestSentence(maxentTagger);
        String dPrefix = config.getDebugPrefix();
        if (dPrefix == null || dPrefix.equals("")) {
            dPrefix = this.fileRecord.filename();
        }
        this.test(config, dPrefix, maxentTagger);
    }

    private static void appendSentenceEnd(List<String> words, List<String> tags) {
        words.add(".$.");
        tags.add(".$$.");
    }

    private void testOneSentence(List<String> sentence, List<String> tagsArr, PrintFile wordsFile, PrintFile unknDictFile, PrintFile topWordsFile, boolean verboseResults, MaxentTagger maxentTagger) {
        ++this.numSentences;
        int len = sentence.size();
        String[] testSent = new String[len];
        String[] correctTags = new String[len];
        for (int i = 0; i < len; ++i) {
            testSent[i] = sentence.get(i);
            correctTags[i] = tagsArr.get(i);
        }
        TestSentence testS = new TestSentence(maxentTagger, testSent, correctTags, wordsFile, this.wrongWords, verboseResults);
        if (this.writeUnknDict) {
            testS.printUnknown(this.numSentences, unknDictFile);
        }
        if (this.writeTopWords) {
            testS.printTop(topWordsFile);
        }
        this.numWrong += testS.numWrong;
        this.numRight += testS.numRight;
        this.unknownWords += testS.numUnknown;
        this.numWrongUnknown += testS.numWrongUnknown;
        if (testS.numWrong == 0) {
            ++this.numCorrectSentences;
        }
        if (verboseResults) {
            System.err.println("Sentence number: " + this.numSentences + "; length " + (len - 1) + "; correct: " + testS.numRight + "; wrong: " + testS.numWrong + "; unknown wrong: " + testS.numWrongUnknown);
            System.err.println("  Total tags correct: " + this.numRight + "; wrong: " + this.numWrong + "; unknown wrong: " + this.numWrongUnknown);
        }
    }

    private void test(TaggerConfig config, String saveRoot, MaxentTagger maxentTagger) throws IOException {
        this.numSentences = 0;
        PrintFile pf = null;
        PrintFile pf1 = null;
        PrintFile pf3 = null;
        if (this.writeWords) {
            pf = new PrintFile(saveRoot + ".words");
        }
        if (this.writeUnknDict) {
            pf1 = new PrintFile(saveRoot + ".un.dict");
        }
        if (this.writeTopWords) {
            pf3 = new PrintFile(saveRoot + ".words.top");
        }
        boolean verboseResults = config.getVerboseResults();
        for (List taggedSentence : this.fileRecord.reader()) {
            ArrayList<String> sentence = new ArrayList<String>();
            ArrayList<String> tagsArr = new ArrayList<String>();
            for (TaggedWord cur : taggedSentence) {
                tagsArr.add(cur.tag());
                sentence.add(cur.word());
            }
            TestClassifier.appendSentenceEnd(sentence, tagsArr);
            this.testOneSentence(sentence, tagsArr, pf, pf1, pf3, verboseResults, maxentTagger);
        }
        if (pf != null) {
            pf.close();
        }
        if (pf1 != null) {
            pf1.close();
        }
        if (pf3 != null) {
            pf3.close();
        }
    }

    String resultsString(TaggerConfig config, MaxentTagger maxentTagger) {
        StringBuilder output = new StringBuilder();
        output.append("Model " + config.getModel() + " has xSize=" + maxentTagger.xSize + ", ySize=" + maxentTagger.ySize + ", and numFeatures=" + maxentTagger.prob.lambda.length + ".\n");
        output.append("Results on " + this.numSentences + " sentences and " + (this.numRight + this.numWrong) + " words, of which " + this.unknownWords + " were unknown.\n");
        output.append(String.format("Total sentences right: %d (%f%%); wrong: %d (%f%%).\n", this.numCorrectSentences, (double)this.numCorrectSentences * 100.0 / (double)this.numSentences, this.numSentences - this.numCorrectSentences, (double)(this.numSentences - this.numCorrectSentences) * 100.0 / (double)this.numSentences));
        output.append(String.format("Total tags right: %d (%f%%); wrong: %d (%f%%).\n", this.numRight, (double)this.numRight * 100.0 / (double)(this.numRight + this.numWrong), this.numWrong, (double)this.numWrong * 100.0 / (double)(this.numRight + this.numWrong)));
        if (this.unknownWords > 0) {
            output.append(String.format("Unknown words right: %d (%f%%); wrong: %d (%f%%).\n", this.unknownWords - this.numWrongUnknown, 100.0 - (double)this.numWrongUnknown * 100.0 / (double)this.unknownWords, this.numWrongUnknown, (double)this.numWrongUnknown * 100.0 / (double)this.unknownWords));
        }
        return output.toString();
    }

    void printModelAndAccuracy(TaggerConfig config, MaxentTagger maxentTagger) {
        System.err.println(this.resultsString(config, maxentTagger));
    }

    int getNumWords() {
        return this.numRight + this.numWrong;
    }

    void setDebug(boolean status) {
        this.writeUnknDict = status;
        this.writeWords = status;
        this.writeTopWords = status;
    }
}

