/*
 * Decompiled with CFR 0.152.
 */
package LBJ2.classify;

import LBJ2.classify.Classifier;
import LBJ2.classify.DiscreteConjunctiveFeature;
import LBJ2.classify.Feature;
import LBJ2.learn.Lexicon;
import LBJ2.util.ByteString;
import LBJ2.util.ExceptionlessInputStream;
import LBJ2.util.ExceptionlessOutputStream;

public abstract class DiscreteFeature
extends Feature {
    public static final String[] BooleanValues = new String[]{"false", "true"};
    protected short valueIndex;
    protected short totalValues;

    DiscreteFeature() {
    }

    DiscreteFeature(String string, String string2, short s, short s2) {
        super(string, string2);
        this.valueIndex = s;
        this.totalValues = s2;
    }

    public boolean isDiscrete() {
        return true;
    }

    public short getValueIndex() {
        return this.valueIndex;
    }

    public short totalValues() {
        return this.totalValues;
    }

    public double getStrength() {
        return this.totalValues == 2 ? (double)this.valueIndex : 1.0;
    }

    public Feature conjunction(Feature feature, Classifier classifier) {
        return feature.conjunctWith(this, classifier);
    }

    protected Feature conjunctWith(DiscreteFeature discreteFeature, Classifier classifier) {
        return new DiscreteConjunctiveFeature(classifier, discreteFeature, this);
    }

    public void write(ExceptionlessOutputStream exceptionlessOutputStream) {
        super.write(exceptionlessOutputStream);
        exceptionlessOutputStream.writeShort(this.valueIndex);
        exceptionlessOutputStream.writeShort(this.totalValues);
    }

    public void read(ExceptionlessInputStream exceptionlessInputStream) {
        super.read(exceptionlessInputStream);
        this.valueIndex = exceptionlessInputStream.readShort();
        this.totalValues = exceptionlessInputStream.readShort();
    }

    public String lexWrite(ExceptionlessOutputStream exceptionlessOutputStream, Lexicon lexicon, String string, String string2, String string3, String string4, ByteString byteString) {
        String string5 = super.lexWrite(exceptionlessOutputStream, lexicon, string, string2, string3, string4, byteString);
        exceptionlessOutputStream.writeShort(this.valueIndex);
        exceptionlessOutputStream.writeShort(this.totalValues);
        return string5;
    }

    public void lexRead(ExceptionlessInputStream exceptionlessInputStream, Lexicon lexicon, String string, String string2, String string3, ByteString byteString) {
        super.lexRead(exceptionlessInputStream, lexicon, string, string2, string3, byteString);
        this.valueIndex = exceptionlessInputStream.readShort();
        this.totalValues = exceptionlessInputStream.readShort();
    }
}

