/*
 * Decompiled with CFR 0.152.
 */
package LBJ2.classify;

import LBJ2.classify.Feature;
import LBJ2.classify.RealArrayStringFeature;
import LBJ2.classify.RealFeature;
import LBJ2.classify.RealPrimitiveFeature;
import LBJ2.learn.Lexicon;
import LBJ2.util.ByteString;
import LBJ2.util.ExceptionlessInputStream;
import LBJ2.util.ExceptionlessOutputStream;

public class RealArrayFeature
extends RealPrimitiveFeature {
    protected int arrayIndex;
    protected int arrayLength;

    protected RealArrayFeature() {
    }

    public RealArrayFeature(String string, String string2, ByteString byteString, double d, int n, int n2) {
        super(string, string2, byteString, d);
        this.arrayIndex = n;
        this.arrayLength = n2;
    }

    public boolean fromArray() {
        return true;
    }

    public Feature getFeatureKey(Lexicon lexicon, boolean bl, int n) {
        return new RealArrayFeature(this.containingPackage, this.generatingClassifier, this.identifier, 0.0, this.arrayIndex, 0);
    }

    public void setArrayLength(int n) {
        this.arrayLength = n;
    }

    public int getArrayIndex() {
        return this.arrayIndex;
    }

    public int getArrayLength() {
        return this.arrayLength;
    }

    public RealFeature multiply(double d) {
        return new RealArrayFeature(this.containingPackage, this.generatingClassifier, this.identifier, this.value * d, this.arrayIndex, this.arrayLength);
    }

    public Feature withStrength(double d) {
        return new RealArrayFeature(this.containingPackage, this.generatingClassifier, this.identifier, d, this.arrayIndex, this.arrayLength);
    }

    public int hashCode() {
        return 17 * super.hashCode() + this.arrayIndex;
    }

    public boolean equals(Object object) {
        return super.equals(object) && (object instanceof RealArrayFeature ? this.arrayIndex == ((RealArrayFeature)object).arrayIndex : this.arrayIndex == ((RealArrayStringFeature)object).arrayIndex);
    }

    public boolean classEquivalent(Feature feature) {
        return feature instanceof RealArrayStringFeature;
    }

    public int compareTo(Object object) {
        int n = this.compareNameStrings(object);
        if (n != 0) {
            return n;
        }
        RealArrayFeature realArrayFeature = (RealArrayFeature)object;
        n = this.identifier.compareTo(realArrayFeature.identifier);
        if (n != 0) {
            return n;
        }
        n = this.arrayIndex - realArrayFeature.arrayIndex;
        if (n != 0) {
            return n;
        }
        double d = this.value - realArrayFeature.value;
        if (d < 0.0) {
            return -1;
        }
        if (d > 0.0) {
            return 1;
        }
        return 0;
    }

    public void write(StringBuffer stringBuffer) {
        this.writeNameString(stringBuffer);
        stringBuffer.append("[");
        stringBuffer.append(this.arrayIndex);
        stringBuffer.append("](");
        stringBuffer.append(this.value);
        stringBuffer.append(")");
    }

    public void write(ExceptionlessOutputStream exceptionlessOutputStream) {
        super.write(exceptionlessOutputStream);
        exceptionlessOutputStream.writeInt(this.arrayIndex);
        exceptionlessOutputStream.writeInt(this.arrayLength);
    }

    public void read(ExceptionlessInputStream exceptionlessInputStream) {
        super.read(exceptionlessInputStream);
        this.arrayIndex = exceptionlessInputStream.readInt();
        this.arrayLength = exceptionlessInputStream.readInt();
    }

    public String lexWrite(ExceptionlessOutputStream exceptionlessOutputStream, Lexicon lexicon, String string, String string2, String string3, String string4, ByteString byteString) {
        String string5 = super.lexWrite(exceptionlessOutputStream, lexicon, string, string2, string3, string4, byteString);
        exceptionlessOutputStream.writeInt(this.arrayIndex);
        return string5;
    }

    public void lexRead(ExceptionlessInputStream exceptionlessInputStream, Lexicon lexicon, String string, String string2, String string3, ByteString byteString) {
        super.lexRead(exceptionlessInputStream, lexicon, string, string2, string3, byteString);
        this.arrayIndex = exceptionlessInputStream.readInt();
        this.arrayLength = 0;
    }
}

