/*
 * Decompiled with CFR 0.152.
 */
package LBJ2.classify;

import LBJ2.classify.Feature;
import LBJ2.classify.RealFeature;
import LBJ2.classify.RealPrimitiveStringFeature;
import LBJ2.learn.Lexicon;
import LBJ2.util.ByteString;
import LBJ2.util.ExceptionlessInputStream;
import LBJ2.util.ExceptionlessOutputStream;

public class RealPrimitiveFeature
extends RealFeature {
    protected ByteString identifier;
    protected double value;

    protected RealPrimitiveFeature() {
    }

    public RealPrimitiveFeature(String string, String string2, ByteString byteString, double d) {
        super(string, string2);
        this.identifier = byteString;
        this.value = d;
    }

    public boolean hasByteStringIdentifier() {
        return true;
    }

    public boolean isPrimitive() {
        return true;
    }

    public String getStringIdentifier() {
        return this.identifier.toString();
    }

    public ByteString getByteStringIdentifier() {
        return (ByteString)this.identifier.clone();
    }

    public double getStrength() {
        return this.value;
    }

    public Feature getFeatureKey(Lexicon lexicon, boolean bl, int n) {
        return new RealPrimitiveFeature(this.containingPackage, this.generatingClassifier, this.identifier, 0.0);
    }

    public RealFeature multiply(double d) {
        return new RealPrimitiveFeature(this.containingPackage, this.generatingClassifier, this.identifier, this.value * d);
    }

    public Feature withStrength(double d) {
        return new RealPrimitiveFeature(this.containingPackage, this.generatingClassifier, this.identifier, d);
    }

    public Feature encode(String string) {
        return this;
    }

    public int hashCode() {
        return 31 * super.hashCode() + 17 * this.identifier.hashCode() + new Double(this.value).hashCode();
    }

    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        if (object instanceof RealPrimitiveFeature) {
            RealPrimitiveFeature realPrimitiveFeature = (RealPrimitiveFeature)object;
            return this.identifier.equals(realPrimitiveFeature.identifier) && this.value == realPrimitiveFeature.value;
        }
        RealPrimitiveStringFeature realPrimitiveStringFeature = (RealPrimitiveStringFeature)object;
        return this.identifier.equals(realPrimitiveStringFeature.identifier) && this.value == realPrimitiveStringFeature.value;
    }

    public boolean classEquivalent(Feature feature) {
        return feature instanceof RealPrimitiveStringFeature;
    }

    public int compareTo(Object object) {
        int n = this.compareNameStrings(object);
        if (n != 0) {
            return n;
        }
        RealPrimitiveFeature realPrimitiveFeature = (RealPrimitiveFeature)object;
        n = this.identifier.compareTo(realPrimitiveFeature.identifier);
        if (n != 0) {
            return n;
        }
        double d = this.value - realPrimitiveFeature.value;
        if (d < 0.0) {
            return -1;
        }
        if (d > 0.0) {
            return 1;
        }
        return 0;
    }

    public void write(StringBuffer stringBuffer) {
        this.writeNameString(stringBuffer);
        stringBuffer.append("(");
        stringBuffer.append(this.value);
        stringBuffer.append(")");
    }

    public void writeNameString(StringBuffer stringBuffer) {
        super.writeNameString(stringBuffer);
        stringBuffer.append(":");
        stringBuffer.append(this.identifier.toString());
    }

    public void write(ExceptionlessOutputStream exceptionlessOutputStream) {
        super.write(exceptionlessOutputStream);
        this.identifier.write(exceptionlessOutputStream);
        exceptionlessOutputStream.writeDouble(this.value);
    }

    public void read(ExceptionlessInputStream exceptionlessInputStream) {
        super.read(exceptionlessInputStream);
        this.identifier = ByteString.readByteString(exceptionlessInputStream);
        this.value = exceptionlessInputStream.readDouble();
    }

    public String lexWrite(ExceptionlessOutputStream exceptionlessOutputStream, Lexicon lexicon, String string, String string2, String string3, String string4, ByteString byteString) {
        String string5 = super.lexWrite(exceptionlessOutputStream, lexicon, string, string2, string3, string4, byteString);
        this.identifier.lexWrite(exceptionlessOutputStream, byteString);
        return string5;
    }

    public void lexRead(ExceptionlessInputStream exceptionlessInputStream, Lexicon lexicon, String string, String string2, String string3, ByteString byteString) {
        super.lexRead(exceptionlessInputStream, lexicon, string, string2, string3, byteString);
        this.identifier = ByteString.lexReadByteString(exceptionlessInputStream, byteString);
        this.value = 0.0;
    }
}

