/*
 * Decompiled with CFR 0.152.
 */
package LBJ2.classify;

import LBJ2.classify.Classifier;
import LBJ2.classify.Feature;
import LBJ2.classify.RealFeature;
import LBJ2.classify.RealReferrer;
import LBJ2.classify.RealReferringFeature;
import LBJ2.learn.Lexicon;
import LBJ2.util.ByteString;
import LBJ2.util.ExceptionlessInputStream;
import LBJ2.util.ExceptionlessOutputStream;

public class RealReferringStringFeature
extends RealReferrer {
    protected String identifier;

    protected RealReferringStringFeature() {
    }

    public RealReferringStringFeature(Classifier classifier, String string, RealFeature realFeature) {
        this(classifier.containingPackage, classifier.name, string, realFeature);
    }

    public RealReferringStringFeature(String string, String string2, String string3, RealFeature realFeature) {
        super(string, string2, realFeature);
        this.identifier = string3;
    }

    public boolean hasStringIdentifier() {
        return true;
    }

    public String getStringIdentifier() {
        return this.identifier;
    }

    public ByteString getByteStringIdentifier() {
        return new ByteString(this.identifier);
    }

    public double getStrength() {
        return this.referent.getStrength();
    }

    public Feature getFeatureKey(Lexicon lexicon, boolean bl, int n) {
        RealFeature realFeature = (RealFeature)this.referent.getFeatureKey(lexicon, bl, n);
        if (bl) {
            realFeature = (RealFeature)lexicon.getChildFeature(realFeature, n);
        }
        return new RealReferringStringFeature(this.containingPackage, this.generatingClassifier, this.identifier, realFeature);
    }

    public RealFeature multiply(double d) {
        return new RealReferringStringFeature(this.containingPackage, this.generatingClassifier, this.identifier, this.referent.multiply(d));
    }

    public Feature withStrength(double d) {
        return new RealReferringStringFeature(this.containingPackage, this.generatingClassifier, this.identifier, (RealFeature)this.referent.withStrength(d));
    }

    public Feature encode(String string) {
        RealFeature realFeature = (RealFeature)this.referent.encode(string);
        if (this.referent == realFeature && (string == null || string == "String")) {
            return this;
        }
        ByteString byteString = this.identifier.length() == 0 ? ByteString.emptyString : new ByteString(this.identifier, string);
        return new RealReferringFeature(this.containingPackage, this.generatingClassifier, byteString, realFeature);
    }

    public int hashCode() {
        return 17 * super.hashCode() + this.identifier.hashCode();
    }

    public boolean equals(Object object) {
        return super.equals(object) && (object instanceof RealReferringStringFeature ? this.identifier.equals(((RealReferringStringFeature)object).identifier) : this.identifier.equals(((RealReferringFeature)object).identifier)) && this.referent.equals(((RealReferrer)object).referent);
    }

    public boolean classEquivalent(Feature feature) {
        return feature instanceof RealReferringFeature;
    }

    public int compareNameStrings(Object object) {
        int n = super.compareNameStrings(object);
        if (n != 0) {
            return n;
        }
        return this.identifier.compareTo(((RealReferringStringFeature)object).identifier);
    }

    public void writeNameString(StringBuffer stringBuffer) {
        super.writeNameString(stringBuffer);
        stringBuffer.append(":");
        stringBuffer.append(this.identifier);
    }

    public void write(ExceptionlessOutputStream exceptionlessOutputStream) {
        super.write(exceptionlessOutputStream);
        exceptionlessOutputStream.writeString(this.identifier);
    }

    public void read(ExceptionlessInputStream exceptionlessInputStream) {
        super.read(exceptionlessInputStream);
        this.identifier = exceptionlessInputStream.readString();
    }

    public String lexWrite(ExceptionlessOutputStream exceptionlessOutputStream, Lexicon lexicon, String string, String string2, String string3, String string4, ByteString byteString) {
        String string5 = super.lexWrite(exceptionlessOutputStream, lexicon, string, string2, string3, string4, byteString);
        exceptionlessOutputStream.writeString(this.identifier.equals(string4) ? null : this.identifier);
        return string5;
    }

    public void lexRead(ExceptionlessInputStream exceptionlessInputStream, Lexicon lexicon, String string, String string2, String string3, ByteString byteString) {
        super.lexRead(exceptionlessInputStream, lexicon, string, string2, string3, byteString);
        this.identifier = exceptionlessInputStream.readString();
        if (this.identifier == null) {
            this.identifier = string3;
        }
    }
}

