/*
 * Decompiled with CFR 0.152.
 */
package LBJ2.classify;

import LBJ2.classify.Classifier;
import LBJ2.learn.Learner;
import LBJ2.learn.Lexicon;
import LBJ2.parse.Parser;
import LBJ2.util.ClassUtils;
import LBJ2.util.TableFormat;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class TestDiscrete {
    private static Classifier classifier;
    private static Classifier oracle;
    private static Parser parser;
    private static int outputGranularity;
    protected HashMap goldHistogram = new HashMap();
    protected HashMap predictionHistogram = new HashMap();
    protected HashMap correctHistogram = new HashMap();
    protected HashSet nullLabels = new HashSet();
    static final /* synthetic */ boolean $assertionsDisabled;

    public static void main(String[] stringArray) {
        long l = -System.currentTimeMillis();
        TestDiscrete testDiscrete = TestDiscrete.instantiate(stringArray);
        System.out.println("Classifier loaded in " + (double)(l += System.currentTimeMillis()) / 1000.0 + " seconds.");
        TestDiscrete.testDiscrete(testDiscrete, classifier, oracle, parser, true, outputGranularity);
    }

    public static TestDiscrete testDiscrete(Classifier classifier, Classifier classifier2, Parser parser) {
        return TestDiscrete.testDiscrete(new TestDiscrete(), classifier, classifier2, parser, false, 0);
    }

    public static TestDiscrete testDiscrete(TestDiscrete testDiscrete, Classifier classifier, Classifier classifier2, Parser parser, boolean bl, int n) {
        int n2 = 1;
        long l = 0L;
        Lexicon lexicon = null;
        Runtime runtime = null;
        boolean bl2 = false;
        if (bl && n > 0) {
            String string;
            runtime = Runtime.getRuntime();
            System.out.println("0 examples tested at " + new Date());
            System.out.println("Total memory before first example: " + runtime.totalMemory());
            Object object = parser.next();
            if (object == null) {
                return testDiscrete;
            }
            l -= System.currentTimeMillis();
            String string2 = classifier.discreteValue(object);
            System.out.println("First example processed in " + (double)(l += System.currentTimeMillis()) / 1000.0 + " seconds.");
            System.out.println("Total memory after first example: " + runtime.totalMemory());
            if (object instanceof Object[] && ((Object[])object)[0] instanceof int[]) {
                bl2 = true;
                lexicon = ((Learner)classifier).getLabelLexicon();
                string = lexicon.lookupKey(((int[])((Object[])object)[2])[0]).getStringValue();
            } else {
                string = classifier2.discreteValue(object);
            }
            testDiscrete.reportPrediction(string2, string);
            object = parser.next();
            while (object != null) {
                if (n2 % n == 0) {
                    System.out.println(n2 + " examples tested at " + new Date());
                }
                l -= System.currentTimeMillis();
                string2 = classifier.discreteValue(object);
                l += System.currentTimeMillis();
                if (!$assertionsDisabled && string2 == null) {
                    throw new AssertionError((Object)("Classifier returned null prediction for example " + object));
                }
                string = bl2 ? lexicon.lookupKey(((int[])((Object[])object)[2])[0]).getStringValue() : classifier2.discreteValue(object);
                testDiscrete.reportPrediction(string2, string);
                object = parser.next();
                ++n2;
            }
            System.out.println(n2 + " examples tested at " + new Date() + "\n");
        } else {
            String string;
            Object object;
            if (bl) {
                runtime = Runtime.getRuntime();
                System.out.println("Total memory before first example: " + runtime.totalMemory());
            }
            if ((object = parser.next()) == null) {
                return testDiscrete;
            }
            l -= System.currentTimeMillis();
            String string3 = classifier.discreteValue(object);
            l += System.currentTimeMillis();
            if (bl) {
                System.out.println("First example processed in " + (double)l / 1000.0 + " seconds.");
                System.out.println("Total memory after first example: " + runtime.totalMemory());
            }
            if (object instanceof Object[] && ((Object[])object)[0] instanceof int[]) {
                bl2 = true;
                lexicon = ((Learner)classifier).getLabelLexicon();
                string = lexicon.lookupKey(((int[])((Object[])object)[2])[0]).getStringValue();
            } else {
                string = classifier2.discreteValue(object);
            }
            testDiscrete.reportPrediction(string3, string);
            object = parser.next();
            while (object != null) {
                l -= System.currentTimeMillis();
                string3 = classifier.discreteValue(object);
                l += System.currentTimeMillis();
                if (!$assertionsDisabled && string3 == null) {
                    throw new AssertionError((Object)("Classifier returned null prediction for example " + object));
                }
                string = bl2 ? lexicon.lookupKey(((int[])((Object[])object)[2])[0]).getStringValue() : classifier2.discreteValue(object);
                testDiscrete.reportPrediction(string3, string);
                object = parser.next();
                ++n2;
            }
        }
        if (bl) {
            System.out.println("Average evaluation time: " + (double)l / (1000.0 * (double)n2) + " seconds\n");
            testDiscrete.printPerformance(System.out);
        }
        return testDiscrete;
    }

    private static TestDiscrete instantiate(String[] stringArray) {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        TestDiscrete testDiscrete = new TestDiscrete();
        try {
            int n = 0;
            if (stringArray[0].charAt(0) == '-') {
                if (!stringArray[0].equals("-t")) {
                    throw new Exception();
                }
                outputGranularity = Integer.parseInt(stringArray[1]);
                n = 2;
            }
            string = stringArray[n];
            string2 = stringArray[n + 1];
            string3 = stringArray[n + 2];
            string4 = stringArray[n + 3];
            for (int i = n + 4; i < stringArray.length; ++i) {
                testDiscrete.addNull(stringArray[i]);
            }
        }
        catch (Exception exception) {
            System.err.println("usage:\n  java LBJ2.classify.TestDiscrete [-t <n>] <classifier> <oracle> \\\n                                  <parser> <input file> \\\n                                  [<null label> [<null label> ...]]");
            System.exit(1);
        }
        classifier = ClassUtils.getClassifier(string);
        oracle = ClassUtils.getClassifier(string2);
        parser = ClassUtils.getParser(string3, new Class[]{String.class}, new String[]{string4});
        return testDiscrete;
    }

    public void reportPrediction(String string, String string2) {
        this.histogramAdd(this.goldHistogram, string2, 1);
        this.histogramAdd(this.predictionHistogram, string, 1);
        if (string.equals(string2)) {
            this.histogramAdd(this.correctHistogram, string, 1);
        }
    }

    public void reportAll(TestDiscrete testDiscrete) {
        this.histogramAddAll(this.goldHistogram, testDiscrete.goldHistogram);
        this.histogramAddAll(this.predictionHistogram, testDiscrete.predictionHistogram);
        this.histogramAddAll(this.correctHistogram, testDiscrete.correctHistogram);
    }

    public String[] getLabels() {
        return this.goldHistogram.keySet().toArray(new String[0]);
    }

    public String[] getPredictions() {
        return this.predictionHistogram.keySet().toArray(new String[0]);
    }

    public String[] getAllClasses() {
        HashSet hashSet = new HashSet(this.goldHistogram.keySet());
        hashSet.addAll(this.predictionHistogram.keySet());
        return hashSet.toArray(new String[0]);
    }

    public void addNull(String string) {
        this.nullLabels.add(string);
    }

    public void removeNull(String string) {
        this.nullLabels.remove(string);
    }

    public boolean isNull(String string) {
        return this.nullLabels.contains(string);
    }

    public boolean hasNulls() {
        return this.nullLabels.size() > 0;
    }

    protected void histogramAdd(HashMap hashMap, String string, int n) {
        Integer n2 = (Integer)hashMap.get(string);
        if (n2 == null) {
            n2 = new Integer(0);
        }
        hashMap.put(string, new Integer(n2 + n));
    }

    protected int histogramGet(HashMap hashMap, String string) {
        Integer n = (Integer)hashMap.get(string);
        if (n == null) {
            n = new Integer(0);
        }
        return n;
    }

    protected void histogramAddAll(HashMap hashMap, HashMap hashMap2) {
        Iterator iterator = hashMap2.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            this.histogramAdd(hashMap, (String)entry.getKey(), (Integer)entry.getValue());
        }
    }

    public int getLabeled(String string) {
        return this.histogramGet(this.goldHistogram, string);
    }

    public int getPredicted(String string) {
        return this.histogramGet(this.predictionHistogram, string);
    }

    public int getCorrect(String string) {
        return this.histogramGet(this.correctHistogram, string);
    }

    public double getPrecision(String string) {
        return (double)this.getCorrect(string) / (double)this.getPredicted(string);
    }

    public double getRecall(String string) {
        return (double)this.getCorrect(string) / (double)this.getLabeled(string);
    }

    public double getF1(String string) {
        return this.getF(1.0, string);
    }

    public double getF(double d, String string) {
        double d2 = this.getPrecision(string);
        double d3 = this.getRecall(string);
        return (d * d + 1.0) * d2 * d3 / (d * d * d2 + d3);
    }

    public double[] getOverallStats() {
        return this.getOverallStats(1.0);
    }

    public double[] getOverallStats(double d) {
        String[] stringArray = this.getAllClasses();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            int n6 = this.getCorrect(stringArray[i]);
            int n7 = this.getPredicted(stringArray[i]);
            int n8 = this.getLabeled(stringArray[i]);
            n += n6;
            n2 += n7;
            if (!this.hasNulls() || this.isNull(stringArray[i])) continue;
            n3 += n6;
            n4 += n7;
            n5 += n8;
        }
        double[] dArray = new double[4];
        dArray[3] = (double)n / (double)n2;
        if (this.hasNulls()) {
            dArray[0] = (double)n3 / (double)n4;
            dArray[1] = (double)n3 / (double)n5;
            dArray[2] = (d * d + 1.0) * dArray[0] * dArray[1] / (d * d * dArray[0] + dArray[1]);
        } else {
            dArray[1] = dArray[2] = dArray[3];
            dArray[0] = dArray[2];
        }
        return dArray;
    }

    public void printPerformance(PrintStream printStream) {
        int n;
        String[] stringArray = this.getAllClasses();
        final HashSet hashSet = this.nullLabels;
        Arrays.sort(stringArray, new Comparator(){

            public int compare(Object object, Object object2) {
                int n;
                String string = (String)object;
                String string2 = (String)object2;
                int n2 = hashSet.contains(string) ? 1 : 0;
                int n3 = n = hashSet.contains(string2) ? 1 : 0;
                if (n2 != n) {
                    return n2 - n;
                }
                return string.compareTo(string2);
            }
        });
        int n2 = stringArray.length + 1;
        if (this.hasNulls()) {
            ++n2;
        }
        String[] stringArray2 = new String[n2];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        stringArray2[n2 - 1] = "Accuracy";
        if (this.hasNulls()) {
            stringArray2[n2 - 2] = "Overall";
        }
        String[] stringArray3 = new String[]{"Label", "Precision", "Recall", "F1", "LCount", "PCount"};
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        Double[][] doubleArray = new Double[n2][];
        Double d = new Double(0.0);
        for (int i = 0; i < stringArray.length; ++i) {
            n = this.getCorrect(stringArray[i]);
            int n8 = this.getPredicted(stringArray[i]);
            int n9 = this.getLabeled(stringArray[i]);
            n3 += n;
            n4 += n8;
            if (this.hasNulls() && !this.isNull(stringArray[i])) {
                n5 += n;
                n6 += n8;
                n7 += n9;
            }
            doubleArray[i] = new Double[]{d, d, d, new Double(n9), new Double(n8)};
            if (n8 > 0) {
                doubleArray[i][0] = new Double((double)(100 * n) / (double)n8);
            }
            if (n9 > 0) {
                doubleArray[i][1] = new Double((double)(100 * n) / (double)n9);
            }
            if (n <= 0) continue;
            double d2 = doubleArray[i][0];
            double d3 = doubleArray[i][1];
            doubleArray[i][2] = new Double(2.0 * d2 * d3 / (d2 + d3));
        }
        int[] nArray = null;
        if (this.hasNulls()) {
            doubleArray[n2 - 2] = new Double[]{d, d, d, new Double(n7), new Double(n6)};
            if (n6 > 0) {
                doubleArray[n2 - 2][0] = new Double((double)(100 * n5) / (double)n6);
            }
            if (n7 > 0) {
                doubleArray[n2 - 2][1] = new Double((double)(100 * n5) / (double)n7);
            }
            if (n5 > 0) {
                double d4 = doubleArray[n2 - 2][0];
                double d5 = doubleArray[n2 - 2][1];
                doubleArray[n2 - 2][2] = new Double(2.0 * d4 * d5 / (d4 + d5));
            }
            n = stringArray.length - this.nullLabels.size();
            nArray = new int[]{0, n, stringArray.length};
        } else {
            nArray = new int[]{0, stringArray.length};
        }
        double d6 = n4 == 0 ? 0.0 : (double)(100 * n3) / (double)n4;
        doubleArray[n2 - 1] = new Double[]{new Double(d6), null, null, null, new Double(n4)};
        TableFormat.printTableFormat(printStream, stringArray3, stringArray2, doubleArray, new int[]{3, 3, 3, 0, 0}, nArray);
    }

    static {
        $assertionsDisabled = !TestDiscrete.class.desiredAssertionStatus();
    }
}

