/*
 * Decompiled with CFR 0.152.
 */
package LBJ2.infer;

import LBJ2.infer.FirstOrderConstraint;
import LBJ2.infer.Inference;
import LBJ2.infer.PropositionalAtLeast;
import LBJ2.infer.PropositionalConstant;
import LBJ2.infer.PropositionalConstraint;
import LBJ2.infer.Quantifier;
import LBJ2.infer.QuantifierArgumentReplacer;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

public class AtLeastQuantifier
extends Quantifier {
    protected int m;

    public AtLeastQuantifier(String string, Collection collection, FirstOrderConstraint firstOrderConstraint, int n) {
        this(string, collection, firstOrderConstraint, n, null);
    }

    public AtLeastQuantifier(String string, Collection collection, FirstOrderConstraint firstOrderConstraint, int n, QuantifierArgumentReplacer quantifierArgumentReplacer) {
        super(string, collection, firstOrderConstraint, quantifierArgumentReplacer);
        this.m = Math.max(n, 0);
    }

    public boolean evaluate() {
        int n = 0;
        int n2 = this.initialize();
        Iterator iterator = this.collection.iterator();
        while (iterator.hasNext() && n < this.m) {
            this.enclosingQuantificationSettings.set(n2, iterator.next());
            this.constraint.setQuantificationVariables(this.enclosingQuantificationSettings);
            if (!this.constraint.evaluate()) continue;
            ++n;
        }
        this.enclosingQuantificationSettings.removeElementAt(n2);
        return n == this.m;
    }

    public void setQuantificationVariables(Vector vector) {
        this.enclosingQuantificationSettings = vector;
        if (this.replacer != null) {
            this.replacer.setQuantificationVariables(vector);
            if (!this.replacer.collectionConstant) {
                this.collection = this.replacer.getCollection();
            }
            if (!this.replacer.boundConstant) {
                this.m = this.replacer.getBound();
            }
        }
    }

    public PropositionalConstraint propositionalize() {
        if (this.collection.size() < this.m) {
            return new PropositionalConstant(false);
        }
        if (this.m == 0) {
            return new PropositionalConstant(true);
        }
        PropositionalConstraint[] propositionalConstraintArray = new PropositionalConstraint[this.collection.size()];
        int n = this.initialize();
        int n2 = 0;
        Iterator iterator = this.collection.iterator();
        while (iterator.hasNext()) {
            this.enclosingQuantificationSettings.set(n, iterator.next());
            this.constraint.setQuantificationVariables(this.enclosingQuantificationSettings);
            propositionalConstraintArray[n2] = this.constraint.propositionalize();
            ++n2;
        }
        this.enclosingQuantificationSettings.removeElementAt(n);
        if (propositionalConstraintArray.length == 1) {
            return propositionalConstraintArray[0];
        }
        return new PropositionalAtLeast(propositionalConstraintArray, this.m);
    }

    public int hashCode() {
        return super.hashCode() + this.m + 1;
    }

    public boolean equals(Object object) {
        if (!(object instanceof AtLeastQuantifier)) {
            return false;
        }
        AtLeastQuantifier atLeastQuantifier = (AtLeastQuantifier)object;
        return super.equals(atLeastQuantifier) && this.m == atLeastQuantifier.m;
    }

    public void runVisit(Inference inference) {
        inference.visit(this);
    }
}

