/*
 * Decompiled with CFR 0.152.
 */
package LBJ2.infer;

import LBJ2.classify.Score;
import LBJ2.infer.EqualityArgumentReplacer;
import LBJ2.infer.FirstOrderEquality;
import LBJ2.infer.FirstOrderVariable;
import LBJ2.infer.Inference;
import LBJ2.infer.PropositionalConstant;
import LBJ2.infer.PropositionalConstraint;
import LBJ2.infer.PropositionalNegation;
import LBJ2.infer.PropositionalVariable;
import java.util.AbstractMap;
import java.util.Vector;

public class FirstOrderEqualityWithValue
extends FirstOrderEquality {
    protected FirstOrderVariable left;
    protected String right;

    public FirstOrderEqualityWithValue(boolean bl, FirstOrderVariable firstOrderVariable, String string) {
        this(bl, firstOrderVariable, string, null);
    }

    public FirstOrderEqualityWithValue(boolean bl, FirstOrderVariable firstOrderVariable, String string, EqualityArgumentReplacer equalityArgumentReplacer) {
        super(bl, equalityArgumentReplacer);
        this.left = firstOrderVariable;
        this.right = string;
    }

    public void consolidateVariables(AbstractMap abstractMap) {
        this.variableMap = abstractMap;
        if (abstractMap.containsKey(this.left)) {
            this.left = (FirstOrderVariable)abstractMap.get(this.left);
        } else {
            abstractMap.put(this.left, this.left);
        }
    }

    public void setQuantificationVariables(Vector vector) {
        if (this.replacer == null) {
            System.err.println("LBJ ERROR: Attempting to set quantification variable in FirstOrderEqualityWithValue with no variable setter implementation provided.");
            System.exit(1);
        }
        this.replacer.setQuantificationVariables(vector);
        if (!this.replacer.leftConstant) {
            this.left = new FirstOrderVariable(this.left.getClassifier(), this.replacer.getLeftObject());
            if (this.variableMap != null && this.variableMap.containsKey(this.left)) {
                this.left = (FirstOrderVariable)this.variableMap.get(this.left);
            }
        }
        if (!this.replacer.rightConstant) {
            this.right = this.replacer.getRightValue();
        }
    }

    public boolean evaluate() {
        return this.equality == this.left.getValue().equals(this.right);
    }

    public PropositionalConstraint propositionalize() {
        Score[] scoreArray = this.left.getScores().toArray();
        boolean bl = false;
        for (int i = 0; i < scoreArray.length && !bl; ++i) {
            bl = scoreArray[i].value.equals(this.right);
        }
        PropositionalConstraint propositionalConstraint = null;
        propositionalConstraint = !bl ? new PropositionalConstant(false) : new PropositionalVariable(this.left.getClassifier(), this.left.getExample(), this.right);
        if (!this.equality) {
            propositionalConstraint = new PropositionalNegation(propositionalConstraint);
        }
        return propositionalConstraint;
    }

    public int hashCode() {
        if (this.replacer != null) {
            return this.replacer.hashCode();
        }
        return this.left.hashCode() + this.right.hashCode() + 1;
    }

    public boolean equals(Object object) {
        if (!(object instanceof FirstOrderEqualityWithValue)) {
            return false;
        }
        FirstOrderEqualityWithValue firstOrderEqualityWithValue = (FirstOrderEqualityWithValue)object;
        return this.replacer == firstOrderEqualityWithValue.replacer && (this.replacer != null || this.replacer == null && this.left.equals(firstOrderEqualityWithValue.left) && this.right.equals(firstOrderEqualityWithValue.right));
    }

    public void runVisit(Inference inference) {
        inference.visit(this);
    }
}

