/*
 * Decompiled with CFR 0.152.
 */
package LBJ2.infer;

import LBJ2.classify.Score;
import LBJ2.infer.EqualityArgumentReplacer;
import LBJ2.infer.FirstOrderEquality;
import LBJ2.infer.FirstOrderVariable;
import LBJ2.infer.Inference;
import LBJ2.infer.PropositionalConjunction;
import LBJ2.infer.PropositionalConstant;
import LBJ2.infer.PropositionalConstraint;
import LBJ2.infer.PropositionalDisjunction;
import LBJ2.infer.PropositionalNAryConstraint;
import LBJ2.infer.PropositionalNegation;
import LBJ2.infer.PropositionalVariable;
import java.util.AbstractMap;
import java.util.Vector;

public class FirstOrderEqualityWithVariable
extends FirstOrderEquality {
    protected FirstOrderVariable left;
    protected FirstOrderVariable right;

    public FirstOrderEqualityWithVariable(boolean bl, FirstOrderVariable firstOrderVariable, FirstOrderVariable firstOrderVariable2) {
        this(bl, firstOrderVariable, firstOrderVariable2, null);
    }

    public FirstOrderEqualityWithVariable(boolean bl, FirstOrderVariable firstOrderVariable, FirstOrderVariable firstOrderVariable2, EqualityArgumentReplacer equalityArgumentReplacer) {
        super(bl, equalityArgumentReplacer);
        this.left = firstOrderVariable;
        this.right = firstOrderVariable2;
    }

    public void consolidateVariables(AbstractMap abstractMap) {
        this.variableMap = abstractMap;
        if (abstractMap.containsKey(this.left)) {
            this.left = (FirstOrderVariable)abstractMap.get(this.left);
        } else {
            abstractMap.put(this.left, this.left);
        }
        if (abstractMap.containsKey(this.right)) {
            this.right = (FirstOrderVariable)abstractMap.get(this.right);
        } else {
            abstractMap.put(this.right, this.right);
        }
    }

    public void setQuantificationVariables(Vector vector) {
        if (this.replacer == null) {
            System.err.println("LBJ ERROR: Attempting to set quantification variable in FirstOrderEqualityWithVariable with no variable setter implementation provided.");
            System.exit(1);
        }
        this.replacer.setQuantificationVariables(vector);
        if (!this.replacer.leftConstant) {
            this.left = new FirstOrderVariable(this.left.getClassifier(), this.replacer.getLeftObject());
            if (this.variableMap != null && this.variableMap.containsKey(this.left)) {
                this.left = (FirstOrderVariable)this.variableMap.get(this.left);
            }
        }
        if (!this.replacer.rightConstant) {
            this.right = new FirstOrderVariable(this.right.getClassifier(), this.replacer.getRightObject());
            if (this.variableMap != null && this.variableMap.containsKey(this.right)) {
                this.right = (FirstOrderVariable)this.variableMap.get(this.right);
            }
        }
    }

    public boolean evaluate() {
        return this.equality == this.left.getValue().equals(this.right.getValue());
    }

    public PropositionalConstraint propositionalize() {
        int n;
        Score[] scoreArray = this.left.getScores().toArray();
        Score[] scoreArray2 = this.right.getScores().toArray();
        if (scoreArray.length == 0 || scoreArray2.length == 0) {
            return new PropositionalConstant(false);
        }
        if (scoreArray.length == 1 && scoreArray2.length == 1) {
            return new PropositionalConstant(scoreArray[0].value.equals(scoreArray2[0].value));
        }
        PropositionalVariable[] propositionalVariableArray = new PropositionalVariable[scoreArray.length];
        PropositionalVariable[] propositionalVariableArray2 = new PropositionalVariable[scoreArray2.length];
        int n2 = 0;
        for (int i = 0; i < scoreArray.length; ++i) {
            boolean bl = false;
            for (n = 0; n < scoreArray2.length && !bl; ++n) {
                if (!scoreArray[i].value.equals(scoreArray2[n].value)) continue;
                bl = true;
                propositionalVariableArray[n2] = new PropositionalVariable(this.left.getClassifier(), this.left.getExample(), scoreArray[i].value);
                propositionalVariableArray2[n2] = new PropositionalVariable(this.right.getClassifier(), this.right.getExample(), scoreArray2[n].value);
                ++n2;
            }
        }
        if (n2 == 0) {
            return new PropositionalConstant(false);
        }
        if (this.equality && n2 == scoreArray.length && n2 == scoreArray2.length) {
            --n2;
        }
        PropositionalConstraint propositionalConstraint = propositionalVariableArray2[0];
        if (!this.equality) {
            propositionalConstraint = new PropositionalNegation(propositionalConstraint);
        }
        PropositionalNAryConstraint propositionalNAryConstraint = new PropositionalDisjunction(new PropositionalNegation(propositionalVariableArray[0]), propositionalConstraint);
        if (this.equality) {
            propositionalNAryConstraint = new PropositionalConjunction(propositionalNAryConstraint, new PropositionalDisjunction(new PropositionalNegation(propositionalConstraint), propositionalVariableArray[0]));
        }
        for (n = 1; n < n2; ++n) {
            propositionalConstraint = propositionalVariableArray2[n];
            if (!this.equality) {
                propositionalConstraint = new PropositionalNegation(propositionalConstraint);
            }
            propositionalNAryConstraint = new PropositionalConjunction(propositionalNAryConstraint, new PropositionalDisjunction(new PropositionalNegation(propositionalVariableArray[n]), propositionalConstraint));
            if (!this.equality) continue;
            propositionalNAryConstraint = new PropositionalConjunction(propositionalNAryConstraint, new PropositionalDisjunction(new PropositionalNegation(propositionalConstraint), propositionalVariableArray[n]));
        }
        return propositionalNAryConstraint;
    }

    public int hashCode() {
        if (this.replacer != null) {
            return this.replacer.hashCode();
        }
        return this.left.hashCode() + this.right.hashCode() + 2;
    }

    public boolean equals(Object object) {
        if (!(object instanceof FirstOrderEqualityWithVariable)) {
            return false;
        }
        FirstOrderEqualityWithVariable firstOrderEqualityWithVariable = (FirstOrderEqualityWithVariable)object;
        return this.replacer == firstOrderEqualityWithVariable.replacer && (this.replacer != null || this.replacer == null && (this.left.equals(firstOrderEqualityWithVariable.left) && this.right.equals(firstOrderEqualityWithVariable.right) || this.left.equals(firstOrderEqualityWithVariable.right) && this.right.equals(firstOrderEqualityWithVariable.left)));
    }

    public void runVisit(Inference inference) {
        inference.visit(this);
    }
}

