/*
 * Decompiled with CFR 0.152.
 */
package LBJ2.infer;

import LBJ2.infer.Constraint;
import LBJ2.infer.Inference;
import LBJ2.infer.PropositionalConjunction;
import LBJ2.infer.PropositionalConstant;
import LBJ2.infer.PropositionalConstraint;
import LBJ2.infer.PropositionalDisjunction;
import LBJ2.infer.PropositionalDoubleImplication;
import LBJ2.infer.PropositionalImplication;
import LBJ2.infer.PropositionalNAryConstraint;
import LBJ2.infer.PropositionalNegation;
import LBJ2.infer.PropositionalVariable;

public class PropositionalAtLeast
extends PropositionalNAryConstraint {
    protected PropositionalConstraint[] children;
    protected int m;

    private PropositionalAtLeast() {
    }

    public PropositionalAtLeast(PropositionalConstraint[] propositionalConstraintArray, int n) {
        this.m = n;
        this.children = propositionalConstraintArray;
        ((PropositionalNAryConstraint)this).children = null;
    }

    public Constraint[] getChildren() {
        return (PropositionalConstraint[])this.children.clone();
    }

    public int getM() {
        return this.m;
    }

    public boolean contains(PropositionalConstraint propositionalConstraint) {
        for (int i = 0; i < this.children.length; ++i) {
            if (!propositionalConstraint.equals(this.children[i])) continue;
            return true;
        }
        return false;
    }

    public int size() {
        return this.children.length;
    }

    public boolean evaluate() {
        int n = 0;
        for (int i = 0; i < this.children.length && n < this.m; ++i) {
            if (!this.children[i].evaluate()) continue;
            ++n;
        }
        return n == this.m;
    }

    public void remove(int n) {
        PropositionalConstraint[] propositionalConstraintArray = new PropositionalConstraint[this.children.length - 1];
        int n2 = 0;
        for (int i = 0; i < this.children.length; ++i) {
            if (i == n) continue;
            propositionalConstraintArray[n2++] = this.children[i];
        }
        this.children = propositionalConstraintArray;
    }

    public PropositionalConstraint simplify() {
        int n;
        if (this.m <= 0) {
            return PropositionalConstant.True;
        }
        if (this.m > this.children.length) {
            return PropositionalConstant.False;
        }
        PropositionalAtLeast propositionalAtLeast = new PropositionalAtLeast();
        propositionalAtLeast.m = this.m;
        propositionalAtLeast.children = new PropositionalConstraint[this.children.length];
        for (n = 0; n < this.children.length; ++n) {
            propositionalAtLeast.children[n] = this.children[n].simplify();
        }
        for (n = propositionalAtLeast.children.length - 1; n >= 0; --n) {
            if (propositionalAtLeast.children[n] == PropositionalConstant.True) {
                propositionalAtLeast.remove(n);
                --propositionalAtLeast.m;
                continue;
            }
            if (propositionalAtLeast.children[n] != PropositionalConstant.False) continue;
            propositionalAtLeast.remove(n);
        }
        if (propositionalAtLeast.m <= 0) {
            return PropositionalConstant.True;
        }
        if (propositionalAtLeast.m > propositionalAtLeast.children.length) {
            return PropositionalConstant.False;
        }
        if (propositionalAtLeast.children.length == 1) {
            return propositionalAtLeast.children[0];
        }
        if (propositionalAtLeast.m == 1) {
            PropositionalDisjunction propositionalDisjunction = new PropositionalDisjunction(propositionalAtLeast.children[0], propositionalAtLeast.children[1]);
            for (int i = 2; i < propositionalAtLeast.children.length; ++i) {
                propositionalDisjunction = new PropositionalDisjunction(propositionalDisjunction, propositionalAtLeast.children[i]);
            }
            return propositionalDisjunction.simplify();
        }
        return propositionalAtLeast;
    }

    public PropositionalConstraint negate() {
        PropositionalAtLeast propositionalAtLeast = new PropositionalAtLeast();
        propositionalAtLeast.children = new PropositionalConstraint[this.children.length];
        for (int i = 0; i < this.children.length; ++i) {
            propositionalAtLeast.children[i] = this.children[i].negate();
        }
        propositionalAtLeast.m = this.children.length - this.m + 1;
        return propositionalAtLeast;
    }

    public PropositionalConstraint CNF() {
        return this.DNF().CNF();
    }

    public PropositionalConstraint DNF() {
        PropositionalNAryConstraint propositionalNAryConstraint = null;
        if (this.m == 1) {
            propositionalNAryConstraint = new PropositionalDisjunction(this.children[0], this.children[1]);
            for (int i = 2; i < this.m; ++i) {
                propositionalNAryConstraint = new PropositionalDisjunction(propositionalNAryConstraint, this.children[i]);
            }
        } else {
            propositionalNAryConstraint = new PropositionalConjunction(this.children[0], this.children[1]);
            for (int i = 2; i < this.m; ++i) {
                propositionalNAryConstraint = new PropositionalConjunction(propositionalNAryConstraint, this.children[i]);
            }
            int[] nArray = new int[this.m];
            for (int i = 0; i < this.m; ++i) {
                nArray[i] = i;
            }
            while (PropositionalAtLeast.nextChoice(nArray, this.children.length - 1)) {
                PropositionalConjunction propositionalConjunction = new PropositionalConjunction(this.children[nArray[0]], this.children[nArray[1]]);
                for (int i = 2; i < this.m; ++i) {
                    propositionalConjunction = new PropositionalConjunction(propositionalConjunction, this.children[nArray[i]]);
                }
                propositionalNAryConstraint = new PropositionalDisjunction(propositionalNAryConstraint, propositionalConjunction);
            }
        }
        return propositionalNAryConstraint;
    }

    protected static boolean nextChoice(int[] nArray, int n) {
        int n2;
        for (n2 = 1; n2 < nArray.length && nArray[n2] - nArray[n2 - 1] == 1; ++n2) {
        }
        if (n2 == nArray.length && nArray[n2 - 1] == n) {
            return false;
        }
        int n3 = n2 - 1;
        nArray[n3] = nArray[n3] + 1;
        for (int i = 0; i < n2 - 1; ++i) {
            nArray[i] = i;
        }
        return true;
    }

    public boolean moreGeneralThan(PropositionalConstraint propositionalConstraint) {
        return propositionalConstraint.moreSpecificThan(this);
    }

    public boolean moreSpecificThan(PropositionalImplication propositionalImplication) {
        return false;
    }

    public boolean moreSpecificThan(PropositionalDoubleImplication propositionalDoubleImplication) {
        return false;
    }

    public boolean moreSpecificThan(PropositionalConjunction propositionalConjunction) {
        return false;
    }

    public boolean moreSpecificThan(PropositionalDisjunction propositionalDisjunction) {
        return false;
    }

    public boolean moreSpecificThan(PropositionalAtLeast propositionalAtLeast) {
        if (propositionalAtLeast.children.length != this.children.length) {
            return false;
        }
        for (int i = 0; i < this.children.length; ++i) {
            if (this.children[i].equals(propositionalAtLeast.children[i])) continue;
            return false;
        }
        return this.m >= propositionalAtLeast.m;
    }

    public boolean moreSpecificThan(PropositionalNegation propositionalNegation) {
        return false;
    }

    public boolean moreSpecificThan(PropositionalVariable propositionalVariable) {
        return false;
    }

    public boolean moreSpecificThan(PropositionalConstant propositionalConstant) {
        return propositionalConstant.evaluate();
    }

    public int hashCode() {
        int n = 2;
        for (int i = 0; i < this.children.length; ++i) {
            n += this.children[i].hashCode();
        }
        return n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof PropositionalAtLeast)) {
            return false;
        }
        PropositionalAtLeast propositionalAtLeast = (PropositionalAtLeast)object;
        if (this.children.length != propositionalAtLeast.children.length) {
            return false;
        }
        for (int i = 0; i < this.children.length; ++i) {
            if (this.children[i].equals(propositionalAtLeast.children[i])) continue;
            return false;
        }
        return true;
    }

    public void runVisit(Inference inference) {
        inference.visit(this);
    }

    public void write(StringBuffer stringBuffer) {
        stringBuffer.append("(atleast " + this.m + " of ");
        this.children[0].write(stringBuffer);
        for (int i = 1; i < this.children.length; ++i) {
            stringBuffer.append(", ");
            this.children[i].write(stringBuffer);
        }
        stringBuffer.append(")");
    }

    public Object clone() {
        PropositionalAtLeast propositionalAtLeast = null;
        try {
            propositionalAtLeast = (PropositionalAtLeast)super.clone();
        }
        catch (Exception exception) {
            System.err.println("Error cloning PropositionalAtLeast:");
            exception.printStackTrace();
            System.exit(1);
        }
        propositionalAtLeast.children = (PropositionalConstraint[])propositionalAtLeast.children.clone();
        return propositionalAtLeast;
    }
}

