/*
 * Decompiled with CFR 0.152.
 */
package LBJ2.infer;

import LBJ2.infer.Inference;
import LBJ2.infer.PropositionalAtLeast;
import LBJ2.infer.PropositionalBinaryConstraint;
import LBJ2.infer.PropositionalConjunction;
import LBJ2.infer.PropositionalConstant;
import LBJ2.infer.PropositionalConstraint;
import LBJ2.infer.PropositionalDisjunction;
import LBJ2.infer.PropositionalDoubleImplication;
import LBJ2.infer.PropositionalNegation;
import LBJ2.infer.PropositionalVariable;

public class PropositionalImplication
extends PropositionalBinaryConstraint {
    public PropositionalImplication(PropositionalConstraint propositionalConstraint, PropositionalConstraint propositionalConstraint2) {
        super(propositionalConstraint, propositionalConstraint2);
    }

    public boolean evaluate() {
        return !this.left.evaluate() || this.right.evaluate();
    }

    public PropositionalConstraint simplify() {
        return new PropositionalDisjunction(this.left.negate(), this.right).simplify();
    }

    public PropositionalConstraint negate() {
        return new PropositionalConjunction(this.left, this.right.negate());
    }

    public PropositionalConstraint CNF() {
        return new PropositionalDisjunction(new PropositionalNegation(this.left), this.right).CNF();
    }

    public PropositionalConstraint DNF() {
        return new PropositionalDisjunction(new PropositionalNegation(this.left), this.right).DNF();
    }

    public boolean moreGeneralThan(PropositionalConstraint propositionalConstraint) {
        return propositionalConstraint.moreSpecificThan(this);
    }

    public boolean moreSpecificThan(PropositionalImplication propositionalImplication) {
        return false;
    }

    public boolean moreSpecificThan(PropositionalDoubleImplication propositionalDoubleImplication) {
        return false;
    }

    public boolean moreSpecificThan(PropositionalConjunction propositionalConjunction) {
        return false;
    }

    public boolean moreSpecificThan(PropositionalDisjunction propositionalDisjunction) {
        return propositionalDisjunction.contains(new PropositionalNegation(this.left)) && propositionalDisjunction.contains(this.right) || propositionalDisjunction.contains(this);
    }

    public boolean moreSpecificThan(PropositionalAtLeast propositionalAtLeast) {
        return false;
    }

    public boolean moreSpecificThan(PropositionalNegation propositionalNegation) {
        return false;
    }

    public boolean moreSpecificThan(PropositionalVariable propositionalVariable) {
        return false;
    }

    public boolean moreSpecificThan(PropositionalConstant propositionalConstant) {
        return propositionalConstant.evaluate();
    }

    public int hashCode() {
        return this.left.hashCode() + this.right.hashCode() + 2;
    }

    public boolean equals(Object object) {
        if (!(object instanceof PropositionalImplication)) {
            return false;
        }
        PropositionalImplication propositionalImplication = (PropositionalImplication)object;
        return this.left.equals(propositionalImplication.left) && this.right.equals(propositionalImplication.right);
    }

    public void runVisit(Inference inference) {
        inference.visit(this);
    }

    public void write(StringBuffer stringBuffer) {
        stringBuffer.append("(");
        this.left.write(stringBuffer);
        stringBuffer.append(" => ");
        this.right.write(stringBuffer);
        stringBuffer.append(")");
    }
}

