/*
 * Decompiled with CFR 0.152.
 */
package LBJ2.learn;

import LBJ2.classify.Classifier;
import LBJ2.classify.DiscretePrimitiveStringFeature;
import LBJ2.classify.Feature;
import LBJ2.classify.FeatureVector;
import LBJ2.classify.ScoreSet;
import LBJ2.learn.Learner;
import LBJ2.learn.SparseWeightVector;
import LBJ2.util.ExceptionlessInputStream;
import LBJ2.util.ExceptionlessOutputStream;
import LBJ2.util.FVector;
import java.util.Arrays;

public abstract class LinearThresholdUnit
extends Learner {
    public static final double defaultInitialWeight = 0.0;
    public static final double defaultThreshold = 0.0;
    public static final double defaultThickness = 0.0;
    public static final double defaultLearningRate = 0.1;
    public static final SparseWeightVector defaultWeightVector;
    protected double learningRate;
    protected SparseWeightVector weightVector;
    protected double initialWeight;
    protected double threshold;
    protected double bias;
    protected double positiveThickness;
    protected double negativeThickness;
    protected String[] allowableValues;
    static final /* synthetic */ boolean $assertionsDisabled;

    public LinearThresholdUnit() {
        this("");
    }

    public LinearThresholdUnit(double d) {
        this("", d);
    }

    public LinearThresholdUnit(double d, double d2) {
        this("", d, d2);
    }

    public LinearThresholdUnit(double d, double d2, double d3) {
        this("", d, d2, d3);
    }

    public LinearThresholdUnit(double d, double d2, double d3, double d4) {
        this("", d, d2, d3, d4);
    }

    protected LinearThresholdUnit(String string) {
        this(string, 0.1);
    }

    protected LinearThresholdUnit(String string, double d) {
        this(string, d, 0.0);
    }

    protected LinearThresholdUnit(String string, double d, double d2) {
        this(string, d, d2, 0.0);
    }

    protected LinearThresholdUnit(String string, double d, double d2, double d3) {
        this(string, d, d2, d3, d3);
    }

    protected LinearThresholdUnit(String string, double d, double d2, double d3, double d4) {
        this(string, d, d2, d3, d4, (SparseWeightVector)defaultWeightVector.clone());
    }

    protected LinearThresholdUnit(String string, double d, double d2, double d3, double d4, SparseWeightVector sparseWeightVector) {
        super(string);
        Parameters parameters = new Parameters();
        parameters.weightVector = sparseWeightVector;
        parameters.threshold = d2;
        parameters.learningRate = d;
        parameters.positiveThickness = d3;
        parameters.negativeThickness = d4;
        this.setParameters(parameters);
    }

    protected LinearThresholdUnit(Parameters parameters) {
        this("", parameters);
    }

    protected LinearThresholdUnit(String string, Parameters parameters) {
        super(string);
        this.setParameters(parameters);
    }

    public void setParameters(Parameters parameters) {
        this.learningRate = parameters.learningRate;
        this.weightVector = parameters.weightVector;
        this.initialWeight = parameters.initialWeight;
        this.threshold = parameters.threshold;
        this.bias = parameters.initialWeight;
        this.positiveThickness = parameters.thickness + parameters.positiveThickness;
        this.negativeThickness = parameters.thickness + parameters.negativeThickness;
    }

    public Learner.Parameters getParameters() {
        Parameters parameters = new Parameters(super.getParameters());
        parameters.learningRate = this.learningRate;
        parameters.weightVector = this.weightVector.emptyClone();
        parameters.initialWeight = this.initialWeight;
        parameters.threshold = this.threshold;
        parameters.positiveThickness = this.positiveThickness;
        parameters.negativeThickness = this.negativeThickness;
        return parameters;
    }

    public void setLabeler(Classifier classifier) {
        if (classifier != null && classifier.allowableValues().length != 2) {
            System.err.println("Error: " + this.name + ": An LTU must be given a single binary label classifier.");
            new Exception().printStackTrace();
            System.exit(1);
        }
        super.setLabeler(classifier);
        this.allowableValues = classifier == null ? null : classifier.allowableValues();
        this.labelLexicon.clear();
        this.labelLexicon.lookup(new DiscretePrimitiveStringFeature(classifier.containingPackage, classifier.name, "", this.allowableValues[0], 0, 2), true);
        this.labelLexicon.lookup(new DiscretePrimitiveStringFeature(classifier.containingPackage, classifier.name, "", this.allowableValues[1], 1, 2), true);
        this.predictions = new FVector(2);
        this.createPrediction(0);
        this.createPrediction(1);
    }

    public double getInitialWeight() {
        return this.initialWeight;
    }

    public void setInitialWeight(double d) {
        this.initialWeight = d;
    }

    public double getThreshold() {
        return this.threshold;
    }

    public void setThreshold(double d) {
        this.threshold = d;
    }

    public double getPositiveThickness() {
        return this.positiveThickness;
    }

    public void setPositiveThickness(double d) {
        this.positiveThickness = d;
    }

    public double getNegativeThickness() {
        return this.negativeThickness;
    }

    public void setNegativeThickness(double d) {
        this.negativeThickness = d;
    }

    public void setThickness(double d) {
        this.positiveThickness = this.negativeThickness = d;
    }

    public String[] allowableValues() {
        if (this.allowableValues == null) {
            this.allowableValues = new String[]{"*", "*"};
        }
        return this.allowableValues;
    }

    public void learn(int[] nArray, double[] dArray, int[] nArray2, double[] dArray2) {
        double d;
        if (!$assertionsDisabled && nArray2.length != 1) {
            throw new AssertionError((Object)"Example must have a single label.");
        }
        if (!$assertionsDisabled && nArray2[0] != 0 && nArray2[0] != 1) {
            throw new AssertionError((Object)"Example has unallowed label value.");
        }
        boolean bl = nArray2[0] == 1;
        if (this.shouldPromote(bl, d = this.score(nArray, dArray), this.threshold, this.positiveThickness)) {
            this.promote(nArray, dArray, this.computeLearningRate(nArray, dArray, d, bl));
        }
        if (this.shouldDemote(bl, d, this.threshold, this.negativeThickness)) {
            this.demote(nArray, dArray, this.computeLearningRate(nArray, dArray, d, bl));
        }
    }

    public double computeLearningRate(int[] nArray, double[] dArray, double d, boolean bl) {
        return this.learningRate;
    }

    public boolean shouldPromote(boolean bl, double d, double d2, double d3) {
        return bl && d < d2 + d3;
    }

    public boolean shouldDemote(boolean bl, double d, double d2, double d3) {
        return !bl && d >= d2 - d3;
    }

    public void initialize(int n, int n2) {
        double[] dArray = new double[n2];
        Arrays.fill(dArray, this.initialWeight);
        this.weightVector = new SparseWeightVector(dArray);
    }

    public ScoreSet scores(int[] nArray, double[] dArray) {
        double d = this.score(nArray, dArray) - this.threshold;
        ScoreSet scoreSet = new ScoreSet();
        scoreSet.put(this.allowableValues[0], -d);
        scoreSet.put(this.allowableValues[1], d);
        return scoreSet;
    }

    public Feature featureValue(int[] nArray, double[] dArray) {
        int n = this.score(nArray, dArray) >= this.threshold ? 1 : 0;
        return this.predictions.get(n);
    }

    public String discreteValue(int[] nArray, double[] dArray) {
        int n = this.score(nArray, dArray) >= this.threshold ? 1 : 0;
        return this.allowableValues[n];
    }

    public FeatureVector classify(int[] nArray, double[] dArray) {
        return new FeatureVector(this.featureValue(nArray, dArray));
    }

    public double score(Object object) {
        Object[] objectArray = this.getExampleArray(object, false);
        return this.score((int[])objectArray[0], (double[])objectArray[1]);
    }

    public double score(int[] nArray, double[] dArray) {
        return this.weightVector.dot(nArray, dArray, this.initialWeight) + this.bias;
    }

    public void forget() {
        super.forget();
        this.weightVector = this.weightVector.emptyClone();
        this.bias = this.initialWeight;
        this.setLabeler(this.labeler);
    }

    public abstract void promote(int[] var1, double[] var2, double var3);

    public abstract void demote(int[] var1, double[] var2, double var3);

    public void write(ExceptionlessOutputStream exceptionlessOutputStream) {
        super.write(exceptionlessOutputStream);
        if (this.allowableValues == null) {
            exceptionlessOutputStream.writeInt(0);
        } else {
            exceptionlessOutputStream.writeInt(this.allowableValues.length);
            for (int i = 0; i < this.allowableValues.length; ++i) {
                exceptionlessOutputStream.writeString(this.allowableValues[i]);
            }
        }
        exceptionlessOutputStream.writeDouble(this.initialWeight);
        exceptionlessOutputStream.writeDouble(this.threshold);
        exceptionlessOutputStream.writeDouble(this.learningRate);
        exceptionlessOutputStream.writeDouble(this.positiveThickness);
        exceptionlessOutputStream.writeDouble(this.negativeThickness);
        exceptionlessOutputStream.writeDouble(this.bias);
        this.weightVector.write(exceptionlessOutputStream);
    }

    public void read(ExceptionlessInputStream exceptionlessInputStream) {
        super.read(exceptionlessInputStream);
        int n = exceptionlessInputStream.readInt();
        if (n == 0) {
            this.allowableValues = null;
        } else {
            this.allowableValues = new String[n];
            for (int i = 0; i < n; ++i) {
                this.allowableValues[i] = exceptionlessInputStream.readString();
            }
        }
        this.initialWeight = exceptionlessInputStream.readDouble();
        this.threshold = exceptionlessInputStream.readDouble();
        this.learningRate = exceptionlessInputStream.readDouble();
        this.positiveThickness = exceptionlessInputStream.readDouble();
        this.negativeThickness = exceptionlessInputStream.readDouble();
        this.bias = exceptionlessInputStream.readDouble();
        this.weightVector = SparseWeightVector.readWeightVector(exceptionlessInputStream);
    }

    public Object clone() {
        LinearThresholdUnit linearThresholdUnit = (LinearThresholdUnit)super.clone();
        if (this.weightVector != null) {
            linearThresholdUnit.weightVector = (SparseWeightVector)this.weightVector.clone();
        }
        return linearThresholdUnit;
    }

    static {
        $assertionsDisabled = !LinearThresholdUnit.class.desiredAssertionStatus();
        defaultWeightVector = new SparseWeightVector();
    }

    public static class Parameters
    extends Learner.Parameters {
        public double learningRate;
        public SparseWeightVector weightVector;
        public double initialWeight;
        public double threshold;
        public double thickness;
        public double positiveThickness;
        public double negativeThickness;

        public Parameters() {
            this.learningRate = 0.1;
            this.weightVector = (SparseWeightVector)defaultWeightVector.clone();
            this.initialWeight = 0.0;
            this.threshold = 0.0;
            this.thickness = 0.0;
        }

        public Parameters(Learner.Parameters parameters) {
            this();
        }

        public Parameters(Parameters parameters) {
            this.learningRate = parameters.learningRate;
            this.weightVector = parameters.weightVector;
            this.initialWeight = parameters.initialWeight;
            this.threshold = parameters.threshold;
            this.thickness = parameters.thickness;
            this.positiveThickness = parameters.positiveThickness;
            this.negativeThickness = parameters.negativeThickness;
        }

        public void setParameters(Learner learner) {
            ((LinearThresholdUnit)learner).setParameters(this);
        }

        public String nonDefaultString() {
            String string = super.nonDefaultString();
            if (this.learningRate != 0.1) {
                string = string + ", learningRate = " + this.learningRate;
            }
            if (this.initialWeight != 0.0) {
                string = string + ", initialWeight = " + this.initialWeight;
            }
            if (this.threshold != 0.0) {
                string = string + ", threshold = " + this.threshold;
            }
            if (this.thickness != 0.0) {
                string = string + ", thickness = " + this.thickness;
            }
            if (this.positiveThickness != 0.0) {
                string = string + ", positiveThickness = " + this.positiveThickness;
            }
            if (this.negativeThickness != 0.0) {
                string = string + ", negativeThickness = " + this.negativeThickness;
            }
            if (string.startsWith(", ")) {
                string = string.substring(2);
            }
            return string;
        }
    }
}

