/*
 * Decompiled with CFR 0.152.
 */
package LBJ2.learn;

import LBJ2.classify.Classifier;
import LBJ2.classify.Feature;
import LBJ2.classify.FeatureVector;
import LBJ2.classify.Score;
import LBJ2.classify.ScoreSet;
import LBJ2.learn.Learner;
import LBJ2.learn.Lexicon;
import LBJ2.learn.SparseWeightVector;
import LBJ2.util.ExceptionlessInputStream;
import LBJ2.util.ExceptionlessOutputStream;
import LBJ2.util.OVector;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;

public class NaiveBayes
extends Learner {
    public static final int defaultSmoothing = -15;
    protected double smoothing;
    protected OVector network = new OVector();

    public NaiveBayes() {
        this("");
    }

    public NaiveBayes(double d) {
        this("", d);
    }

    public NaiveBayes(Parameters parameters) {
        this("", parameters);
    }

    public NaiveBayes(String string) {
        this(string, -15.0);
    }

    public NaiveBayes(String string, double d) {
        super(string);
        this.smoothing = d;
    }

    public NaiveBayes(String string, Parameters parameters) {
        super(string);
        this.setParameters(parameters);
    }

    public void setParameters(Parameters parameters) {
        this.smoothing = parameters.smoothing;
    }

    public Learner.Parameters getParameters() {
        Parameters parameters = new Parameters(super.getParameters());
        parameters.smoothing = this.smoothing;
        return parameters;
    }

    public void setSmoothing(double d) {
        this.smoothing = d;
    }

    public void setLabeler(Classifier classifier) {
        if (!classifier.getOutputType().equals("discrete")) {
            System.err.println("LBJ WARNING: NaiveBayes will only work with a label classifier that returns discrete.");
            System.err.println("             The given label classifier, " + classifier.getClass().getName() + ", returns " + classifier.getOutputType() + ".");
        }
        super.setLabeler(classifier);
    }

    public void learn(int[] nArray, double[] dArray, int[] nArray2, double[] dArray2) {
        int n = nArray2[0];
        int n2 = this.network.size();
        NaiveBayesVector naiveBayesVector = null;
        if (n >= n2) {
            while (n2++ < n) {
                this.network.add(new NaiveBayesVector());
            }
            naiveBayesVector = new NaiveBayesVector();
            this.network.add(naiveBayesVector);
        } else {
            naiveBayesVector = (NaiveBayesVector)this.network.get(n);
        }
        naiveBayesVector.scaledAdd(nArray, dArray, 1.0);
    }

    public void forget() {
        super.forget();
        this.network = new OVector();
    }

    public ScoreSet scores(int[] nArray, double[] dArray) {
        Cloneable cloneable;
        ScoreSet scoreSet = new ScoreSet();
        for (int i = 0; i < this.network.size(); ++i) {
            cloneable = (NaiveBayesVector)this.network.get(i);
            double d = ((NaiveBayesVector)cloneable).dot(nArray, dArray);
            scoreSet.put(this.labelLexicon.lookupKey(i).getStringValue(), d);
        }
        Score[] scoreArray = scoreSet.toArray();
        cloneable = new ScoreSet();
        for (int i = 0; i < scoreArray.length; ++i) {
            double d = 1.0;
            for (int j = 0; j < scoreArray.length; ++j) {
                if (i == j) continue;
                d += Math.exp(scoreArray[j].score - scoreArray[i].score);
            }
            ((ScoreSet)cloneable).put(scoreArray[i].value, 1.0 / d);
        }
        return cloneable;
    }

    public Feature featureValue(int[] nArray, double[] dArray) {
        double d = -1.7976931348623157E308;
        int n = -1;
        for (int i = 0; i < this.network.size(); ++i) {
            NaiveBayesVector naiveBayesVector = (NaiveBayesVector)this.network.get(i);
            double d2 = naiveBayesVector.dot(nArray, dArray);
            if (!(d2 > d)) continue;
            n = i;
            d = d2;
        }
        if (n == -1) {
            return null;
        }
        return this.predictions.get(n);
    }

    public String discreteValue(int[] nArray, double[] dArray) {
        return this.featureValue(nArray, dArray).getStringValue();
    }

    public FeatureVector classify(int[] nArray, double[] dArray) {
        return new FeatureVector(this.featureValue(nArray, dArray));
    }

    public void write(PrintStream printStream) {
        int n = this.network.size();
        for (int i = 0; i < n; ++i) {
            printStream.println("label: " + this.labelLexicon.lookupKey(i).getStringValue());
            ((NaiveBayesVector)this.network.get(i)).write(printStream);
        }
        printStream.println("End of NaiveBayes");
    }

    public void write(ExceptionlessOutputStream exceptionlessOutputStream) {
        super.write(exceptionlessOutputStream);
        exceptionlessOutputStream.writeDouble(this.smoothing);
        int n = this.network.size();
        exceptionlessOutputStream.writeInt(n);
        for (int i = 0; i < n; ++i) {
            ((NaiveBayesVector)this.network.get(i)).write(exceptionlessOutputStream);
        }
    }

    public void read(ExceptionlessInputStream exceptionlessInputStream) {
        super.read(exceptionlessInputStream);
        this.smoothing = exceptionlessInputStream.readDouble();
        int n = exceptionlessInputStream.readInt();
        this.network = new OVector(n);
        for (int i = 0; i < n; ++i) {
            NaiveBayesVector naiveBayesVector = new NaiveBayesVector();
            naiveBayesVector.read(exceptionlessInputStream);
            this.network.add(naiveBayesVector);
        }
    }

    public Object clone() {
        NaiveBayes naiveBayes = (NaiveBayes)super.clone();
        int n = this.network.size();
        naiveBayes.network = new OVector(n);
        for (int i = 0; i < n; ++i) {
            naiveBayes.network.add(((NaiveBayesVector)this.network.get(i)).clone());
        }
        return naiveBayes;
    }

    protected class NaiveBayesVector
    extends SparseWeightVector {
        protected OVector counts;
        protected Count priorCount;

        public NaiveBayesVector() {
            this(new OVector(1024));
        }

        public NaiveBayesVector(Count[] countArray) {
            this(new OVector(countArray));
        }

        public NaiveBayesVector(OVector oVector) {
            this.counts = oVector;
            this.priorCount = new Count();
        }

        public Count getPrior() {
            return this.priorCount;
        }

        public double dot(int[] nArray, double[] dArray) {
            return this.dot(nArray, dArray, this.priorCount.getLog() + NaiveBayes.this.smoothing);
        }

        public double dot(int[] nArray, double[] dArray, double d) {
            double d2 = (double)(1 - nArray.length) * this.priorCount.getLog();
            for (int i = 0; i < nArray.length; ++i) {
                d2 += this.getWeight(nArray[i], d);
            }
            return d2;
        }

        public double getCount(int n) {
            while (this.counts.size() <= n) {
                this.counts.add(new Count());
            }
            return ((Count)this.counts.get(n)).getCount();
        }

        public double getWeight(int n, double d) {
            while (this.counts.size() <= n) {
                this.counts.add(new Count());
            }
            Count count = (Count)this.counts.get(n);
            if (count.getCount() == 0.0) {
                return d;
            }
            return count.getLog();
        }

        public void setWeight(int n, double d) {
        }

        public void incrementCount(int n, double d) {
            if (n < this.counts.size()) {
                ((Count)this.counts.get(n)).increment(d);
            } else {
                while (this.counts.size() < n) {
                    this.counts.add(new Count());
                }
                Count count = new Count();
                count.increment(d);
                this.counts.add(count);
            }
        }

        public void scaledAdd(int[] nArray, double[] dArray, double d) {
            this.priorCount.increment(d);
            for (int i = 0; i < nArray.length; ++i) {
                this.incrementCount(nArray[i], d);
            }
        }

        public void scaledAdd(int[] nArray, double[] dArray, double d, double d2) {
            this.scaledAdd(nArray, dArray, d);
        }

        public void write(PrintStream printStream) {
            this.write(printStream, NaiveBayes.this.lexicon);
        }

        public void write(PrintStream printStream, Lexicon lexicon) {
            String string;
            int n;
            printStream.println("Begin NaiveBayesVector (" + this.priorCount + ")");
            Map map = lexicon.getMap();
            Map.Entry[] entryArray = map.entrySet().toArray(new Map.Entry[map.size()]);
            Arrays.sort(entryArray, new Comparator(){

                public int compare(Object object, Object object2) {
                    Map.Entry entry = (Map.Entry)object;
                    Map.Entry entry2 = (Map.Entry)object2;
                    return ((Feature)entry.getKey()).compareTo(entry2.getKey());
                }
            });
            int n2 = 0;
            for (n = 0; n < entryArray.length; ++n) {
                string = entryArray[n].getKey().toString();
                n2 = Math.max(n2, string.length());
            }
            n2 = n2 % 2 == 0 ? (n2 += 2) : ++n2;
            for (n = 0; n < entryArray.length; ++n) {
                string = entryArray[n].getKey().toString();
                int n3 = (Integer)entryArray[n].getValue();
                printStream.print(string);
                int n4 = 0;
                while (string.length() + n4 < n2) {
                    printStream.print(" ");
                    ++n4;
                }
                printStream.println(this.getCount(n3));
            }
            printStream.println("End NaiveBayesVector");
        }

        public void write(ExceptionlessOutputStream exceptionlessOutputStream) {
            this.priorCount.write(exceptionlessOutputStream);
            exceptionlessOutputStream.writeInt(this.counts.size());
            for (int i = 0; i < this.counts.size(); ++i) {
                ((Count)this.counts.get(i)).write(exceptionlessOutputStream);
            }
        }

        public void read(ExceptionlessInputStream exceptionlessInputStream) {
            this.priorCount = new Count();
            this.priorCount.read(exceptionlessInputStream);
            int n = exceptionlessInputStream.readInt();
            this.counts = new OVector(n);
            for (int i = 0; i < n; ++i) {
                Count count = new Count();
                count.read(exceptionlessInputStream);
                this.counts.add(count);
            }
        }

        public Object clone() {
            NaiveBayesVector naiveBayesVector = (NaiveBayesVector)super.clone();
            Object[] objectArray = new Count[this.counts.size()];
            for (int i = 0; i < this.counts.size(); ++i) {
                objectArray[i] = (Count)((Count)this.counts.get(i)).clone();
            }
            naiveBayesVector.counts = new OVector(objectArray);
            return naiveBayesVector;
        }

        public SparseWeightVector emptyClone() {
            return new NaiveBayesVector();
        }
    }

    protected static class Count
    implements Cloneable,
    Serializable {
        protected double count = 0.0;
        protected transient double logCount = 0.0;
        protected transient boolean updateLog = true;

        public double getCount() {
            return this.count;
        }

        public void increment(double d) {
            this.count += d;
            this.updateLog = true;
        }

        public double getLog() {
            if (this.updateLog) {
                this.logCount = Math.log(this.count);
                this.updateLog = false;
            }
            return this.logCount;
        }

        public String toString() {
            return "" + this.count;
        }

        public void write(ExceptionlessOutputStream exceptionlessOutputStream) {
            exceptionlessOutputStream.writeDouble(this.count);
        }

        public void read(ExceptionlessInputStream exceptionlessInputStream) {
            this.count = exceptionlessInputStream.readDouble();
            this.updateLog = true;
        }

        public Object clone() {
            Object object = null;
            try {
                object = super.clone();
            }
            catch (Exception exception) {
                System.err.println("Error cloning " + this.getClass().getName() + ":");
                exception.printStackTrace();
                System.exit(1);
            }
            return object;
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            this.updateLog = true;
        }
    }

    public static class Parameters
    extends Learner.Parameters {
        public double smoothing;

        public Parameters() {
            this.smoothing = -15.0;
        }

        public Parameters(Learner.Parameters parameters) {
            super(parameters);
            this.smoothing = -15.0;
        }

        public Parameters(Parameters parameters) {
            super(parameters);
            this.smoothing = parameters.smoothing;
        }

        public void setParameters(Learner learner) {
            ((NaiveBayes)learner).setParameters(this);
        }

        public String nonDefaultString() {
            String string = super.nonDefaultString();
            if (this.smoothing != -15.0) {
                string = string + ", smoothing = " + this.smoothing;
            }
            if (string.startsWith(", ")) {
                string = string.substring(2);
            }
            return string;
        }
    }
}

