/*
 * Decompiled with CFR 0.152.
 */
package LBJ2.learn;

import LBJ2.classify.FeatureVector;
import LBJ2.learn.Learner;
import LBJ2.learn.LinearThresholdUnit;
import LBJ2.learn.SparseWeightVector;
import java.io.PrintStream;

public class PassiveAggressive
extends LinearThresholdUnit {
    public PassiveAggressive() {
        this("");
    }

    public PassiveAggressive(double d) {
        this("", d);
    }

    public PassiveAggressive(double d, double d2) {
        this("", d, d2);
    }

    public PassiveAggressive(double d, double d2, double d3) {
        this("", d, d2, d3);
    }

    public PassiveAggressive(double d, double d2, double d3, SparseWeightVector sparseWeightVector) {
        this("", d, d2, d3, sparseWeightVector);
    }

    public PassiveAggressive(Parameters parameters) {
        this("", parameters);
    }

    public PassiveAggressive(String string) {
        this(string, 0.0);
    }

    public PassiveAggressive(String string, double d) {
        this(string, d, 0.0);
    }

    public PassiveAggressive(String string, double d, double d2) {
        this(string, d, d2, d2);
    }

    public PassiveAggressive(String string, double d, double d2, double d3) {
        this(string, d, d2, d3, (SparseWeightVector)LinearThresholdUnit.defaultWeightVector.clone());
    }

    public PassiveAggressive(String string, double d, double d2, double d3, SparseWeightVector sparseWeightVector) {
        super(string, 0.1, d, d2, d3, sparseWeightVector);
    }

    public PassiveAggressive(String string, Parameters parameters) {
        super(string, parameters);
    }

    public Learner.Parameters getParameters() {
        return new Parameters((LinearThresholdUnit.Parameters)super.getParameters());
    }

    public void promote(int[] nArray, double[] dArray, double d) {
        this.weightVector.scaledAdd(nArray, dArray, d, this.initialWeight);
        this.bias += d;
    }

    public void demote(int[] nArray, double[] dArray, double d) {
        this.weightVector.scaledAdd(nArray, dArray, -d, this.initialWeight);
        this.bias -= d;
    }

    public double computeLearningRate(int[] nArray, double[] dArray, double d, boolean bl) {
        double d2 = bl ? 1.0 : -1.0;
        double d3 = (1.0 - d2 * d) / (FeatureVector.L2NormSquared(dArray) + 1.0);
        if (d3 < 0.0) {
            d3 = 0.0;
        }
        return d3;
    }

    public void write(PrintStream printStream) {
        printStream.println(this.name + ": " + this.learningRate + ", " + this.initialWeight + ", " + this.threshold + ", " + this.positiveThickness + ", " + this.negativeThickness + ", " + this.bias);
        if (this.lexicon.size() == 0) {
            this.weightVector.write(printStream);
        } else {
            this.weightVector.write(printStream, this.lexicon);
        }
    }

    public static class Parameters
    extends LinearThresholdUnit.Parameters {
        public Parameters() {
        }

        public Parameters(LinearThresholdUnit.Parameters parameters) {
            super(parameters);
        }

        public Parameters(Parameters parameters) {
            super(parameters);
        }

        public void setParameters(Learner learner) {
            ((LinearThresholdUnit)learner).setParameters(this);
        }
    }
}

