/*
 * Decompiled with CFR 0.152.
 */
package LBJ2.learn;

import LBJ2.classify.Feature;
import LBJ2.learn.Lexicon;
import LBJ2.util.ClassUtils;
import LBJ2.util.DVector;
import LBJ2.util.ExceptionlessInputStream;
import LBJ2.util.ExceptionlessOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;

public class SparseWeightVector
implements Cloneable,
Serializable {
    protected static final double defaultWeight = 0.0;
    protected static final int defaultCapacity = 1024;
    protected DVector weights;

    public SparseWeightVector() {
        this(new DVector(1024));
    }

    public SparseWeightVector(double[] dArray) {
        this(new DVector(dArray));
    }

    public SparseWeightVector(DVector dVector) {
        this.weights = dVector;
    }

    public double getWeight(int n) {
        return this.getWeight(n, 0.0);
    }

    public double getWeight(int n, double d) {
        return this.weights.get(n, d);
    }

    protected void setWeight(int n, double d) {
        this.setWeight(n, d, 0.0);
    }

    protected void setWeight(int n, double d, double d2) {
        this.weights.set(n, d, d2);
    }

    public double dot(int[] nArray, double[] dArray) {
        return this.dot(nArray, dArray, 0.0);
    }

    public double dot(int[] nArray, double[] dArray, double d) {
        double d2 = 0.0;
        for (int i = 0; i < nArray.length; ++i) {
            double d3 = this.getWeight(nArray[i], d);
            d2 += d3 * dArray[i];
        }
        return d2;
    }

    public void scaledAdd(int[] nArray, double[] dArray) {
        this.scaledAdd(nArray, dArray, 1.0, 0.0);
    }

    public void scaledAdd(int[] nArray, double[] dArray, double d) {
        this.scaledAdd(nArray, dArray, d, 0.0);
    }

    public void scaledAdd(int[] nArray, double[] dArray, double d, double d2) {
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            double d3 = this.getWeight(n, d2) + d * dArray[i];
            this.setWeight(n, d3, d2);
        }
    }

    public void scaledMultiply(int[] nArray, double[] dArray, double d) {
        this.scaledMultiply(nArray, dArray, d, 0.0);
    }

    public void scaledMultiply(int[] nArray, double[] dArray, double d, double d2) {
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            double d3 = dArray[i];
            double d4 = d;
            if (d3 == 0.0) {
                d4 = 1.0;
            } else if (d3 != 1.0) {
                d4 = Math.pow(d, d3);
            }
            double d5 = this.getWeight(n, d2) * d4;
            this.setWeight(n, d5, d2);
        }
    }

    public Object[] pairwiseMultiply(int[] nArray, double[] dArray, double d, boolean bl) {
        int[] nArray2 = new int[nArray.length];
        double[] dArray2 = new double[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            double d2 = this.getWeight(n, d);
            if (bl) {
                d2 = 1.0 / d2;
            }
            nArray2[i] = nArray[i];
            dArray2[i] = d2 * dArray[i];
        }
        return new Object[]{nArray2, dArray2};
    }

    public void clear() {
        this.weights = new DVector(1024);
    }

    public int size() {
        return this.weights.size();
    }

    public void write(PrintStream printStream) {
        printStream.println("Begin SparseWeightVector");
        this.toStringJustWeights(printStream);
        printStream.println("End SparseWeightVector");
    }

    public void write(PrintStream printStream, Lexicon lexicon) {
        printStream.println("Begin SparseWeightVector");
        this.toStringJustWeights(printStream, 0, lexicon);
        printStream.println("End SparseWeightVector");
    }

    public void toStringJustWeights(PrintStream printStream) {
        for (int i = 0; i < this.weights.size(); ++i) {
            printStream.println(this.weights.get(i));
        }
    }

    public void toStringJustWeights(PrintStream printStream, int n, Lexicon lexicon) {
        String string;
        int n2;
        Map map = lexicon.getMap();
        Map.Entry[] entryArray = map.entrySet().toArray(new Map.Entry[map.size()]);
        Arrays.sort(entryArray, new Comparator(){

            public int compare(Object object, Object object2) {
                Map.Entry entry = (Map.Entry)object;
                Map.Entry entry2 = (Map.Entry)object2;
                int n = (Integer)entry.getValue();
                int n2 = (Integer)entry2.getValue();
                if (n < SparseWeightVector.this.weights.size() != n2 < SparseWeightVector.this.weights.size()) {
                    return n - n2;
                }
                return ((Feature)entry.getKey()).compareTo(entry2.getKey());
            }
        });
        int n3 = n;
        for (n2 = 0; n2 < entryArray.length; ++n2) {
            string = entryArray[n2].getKey().toString() + ((Integer)entryArray[n2].getValue() < this.weights.size() ? "" : " (pruned)");
            n3 = Math.max(n3, string.length());
        }
        n3 = n3 % 2 == 0 ? (n3 += 2) : ++n3;
        for (n2 = 0; n2 < entryArray.length; ++n2) {
            string = entryArray[n2].getKey().toString() + ((Integer)entryArray[n2].getValue() < this.weights.size() ? "" : " (pruned)");
            printStream.print(string);
            int n4 = 0;
            while (string.length() + n4 < n3) {
                printStream.print(" ");
                ++n4;
            }
            n4 = (Integer)entryArray[n2].getValue();
            printStream.println(this.weights.get(n4));
        }
    }

    public String toString() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        this.write(printStream);
        return byteArrayOutputStream.toString();
    }

    public String toString(Lexicon lexicon) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        this.write(printStream, lexicon);
        return byteArrayOutputStream.toString();
    }

    public void write(ExceptionlessOutputStream exceptionlessOutputStream) {
        exceptionlessOutputStream.writeString(this.getClass().getName());
        this.weights.write(exceptionlessOutputStream);
    }

    public static SparseWeightVector readWeightVector(ExceptionlessInputStream exceptionlessInputStream) {
        String string = exceptionlessInputStream.readString();
        if (string == null) {
            return null;
        }
        Class clazz = ClassUtils.getClass(string);
        SparseWeightVector sparseWeightVector = null;
        try {
            sparseWeightVector = (SparseWeightVector)clazz.newInstance();
        }
        catch (Exception exception) {
            System.err.println("Error instantiating weight vector '" + string + "':");
            exception.printStackTrace();
            exceptionlessInputStream.close();
            System.exit(1);
        }
        sparseWeightVector.read(exceptionlessInputStream);
        return sparseWeightVector;
    }

    public void read(ExceptionlessInputStream exceptionlessInputStream) {
        this.weights.read(exceptionlessInputStream);
    }

    public Object clone() {
        SparseWeightVector sparseWeightVector = null;
        try {
            sparseWeightVector = (SparseWeightVector)super.clone();
        }
        catch (Exception exception) {
            System.err.println("Error cloning " + this.getClass().getName() + ":");
            exception.printStackTrace();
            System.exit(1);
        }
        sparseWeightVector.weights = (DVector)this.weights.clone();
        return sparseWeightVector;
    }

    public SparseWeightVector emptyClone() {
        return new SparseWeightVector();
    }
}

