/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.cs.cogcomp.lbj.pos;

import LBJ2.classify.LabelVectorReturner;
import LBJ2.classify.TestDiscrete;
import LBJ2.learn.SparseAveragedPerceptron;
import LBJ2.nlp.seg.POSBracketToToken;
import LBJ2.parse.FeatureVectorParser;
import edu.illinois.cs.cogcomp.lbj.pos.POSLabel;
import edu.illinois.cs.cogcomp.lbj.pos.POSTagger;
import edu.illinois.cs.cogcomp.lbj.pos.POSTaggerKnown;
import edu.illinois.cs.cogcomp.lbj.pos.POSTaggerUnknown;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Date;

public class LearningCurve {
    static final POSLabel labeler = new POSLabel();
    static final LabelVectorReturner lvr = new LabelVectorReturner(){

        @Override
        public String getOutputType() {
            return "discrete";
        }

        @Override
        public String[] allowableValues() {
            return labeler.allowableValues();
        }

        @Override
        public String discreteValue(Object object) {
            return this.classify(object).firstFeature().getStringValue();
        }
    };

    public static void main(String[] stringArray) {
        double[] dArray = new double[2];
        double[] dArray2 = new double[2];
        int n = 0;
        try {
            dArray[0] = Double.parseDouble(stringArray[0]);
            dArray[1] = Double.parseDouble(stringArray[1]);
            dArray2[0] = Double.parseDouble(stringArray[2]);
            dArray2[1] = Double.parseDouble(stringArray[3]);
            n = Integer.parseInt(stringArray[4]);
            if (dArray[0] < 0.0 || dArray[1] < dArray[0] || dArray2[0] < 0.0 || dArray2[1] < dArray2[0] || n < 1 || stringArray.length > 5) {
                throw new Exception();
            }
        }
        catch (Exception exception) {
            System.err.println("usage: java edu.illinois.cs.cogcomp.lbj.pos.LearningCurve <knownThicknessLB> \\\n                              <knownThicknessUB> <unKnownThicknessLB> \\\n                              <unKnownThicknessUB> <rounds>");
            System.exit(1);
        }
        POSTagger pOSTagger = new POSTagger();
        POSTaggerKnown pOSTaggerKnown = new POSTaggerKnown();
        POSTaggerUnknown pOSTaggerUnknown = new POSTaggerUnknown();
        pOSTaggerKnown.setLabeler(lvr);
        pOSTaggerUnknown.setLabeler(lvr);
        FeatureVectorParser featureVectorParser = new FeatureVectorParser("lbj/LBJ2/nlp/pos/POSTaggerKnown.ex", "lbj/LBJ2/nlp/pos/POSTaggerKnown.lex");
        FeatureVectorParser featureVectorParser2 = new FeatureVectorParser("lbj/LBJ2/nlp/pos/POSTaggerUnknown.ex", "lbj/LBJ2/nlp/pos/POSTaggerUnknown.lex");
        POSBracketToToken pOSBracketToToken = new POSBracketToToken("/shared/grandpa/corpora/POS/19-21.br");
        double d = 0.0;
        int n2 = 0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (double d4 = dArray[0]; d4 <= dArray[1]; d4 += 0.5) {
            for (double d5 = dArray2[0]; d5 <= dArray2[1]; d5 += 0.5) {
                double d6 = 0.0;
                int n3 = 0;
                PrintStream printStream = null;
                try {
                    printStream = new PrintStream(new FileOutputStream("curves/curve_" + d4 + "_" + d5));
                }
                catch (Exception exception) {
                    System.err.println("Can't open curves/curve_" + d4 + "_" + d5 + " for output: " + exception);
                    System.exit(1);
                }
                System.out.println("Training k = " + d4 + ", u = " + d5 + " started at " + new Date());
                pOSTaggerKnown.forget();
                pOSTaggerUnknown.forget();
                pOSTaggerKnown.setLTU(new SparseAveragedPerceptron(0.1, 0.0, d4));
                pOSTaggerUnknown.setLTU(new SparseAveragedPerceptron(0.1, 0.0, d5));
                for (int i = 0; i < n; ++i) {
                    POSTaggerKnown.isTraining = true;
                    Object object = featureVectorParser.next();
                    while (object != null) {
                        pOSTaggerKnown.learn(object);
                        object = featureVectorParser.next();
                    }
                    POSTaggerKnown.isTraining = false;
                    POSTaggerUnknown.isTraining = true;
                    object = featureVectorParser2.next();
                    while (object != null) {
                        pOSTaggerUnknown.learn(object);
                        object = featureVectorParser2.next();
                    }
                    POSTaggerUnknown.isTraining = false;
                    object = new TestDiscrete();
                    Object object2 = pOSBracketToToken.next();
                    while (object2 != null) {
                        ((TestDiscrete)object).reportPrediction(pOSTagger.discreteValue(object2), labeler.discreteValue(object2));
                        object2 = pOSBracketToToken.next();
                    }
                    double d7 = ((TestDiscrete)object).getOverallStats()[2];
                    printStream.println(i + 1 + "  " + d7);
                    if (d7 > d6) {
                        d6 = d7;
                        n3 = i + 1;
                        if (d7 > d) {
                            d = d7;
                            n2 = i + 1;
                            d2 = d4;
                            d3 = d5;
                            pOSTaggerKnown.save();
                            pOSTaggerUnknown.save();
                        }
                    }
                    if ((i + 1) % 5 == 0) {
                        System.out.println(i + 1 + " rounds.  Best so far: (" + n3 + ") " + d6 + " at " + new Date());
                    }
                    featureVectorParser.reset();
                    featureVectorParser2.reset();
                    pOSBracketToToken.reset();
                }
                printStream.close();
            }
        }
        System.out.println("\nBest overall:");
        System.out.println("  Thickness for POSTaggerKnown: " + d2);
        System.out.println("  Thickness for POSTaggerUnknown: " + d3);
        System.out.println("  Rounds: " + n2);
        System.out.println("  Performance: " + d);
    }
}

