/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.stats;

import edu.stanford.nlp.stats.AbstractCounter;
import edu.stanford.nlp.stats.Counter;
import edu.stanford.nlp.util.ErasureUtils;
import edu.stanford.nlp.util.Factory;
import edu.stanford.nlp.util.Filter;
import edu.stanford.nlp.util.MapFactory;
import edu.stanford.nlp.util.MutableInteger;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntCounter<E>
extends AbstractCounter<E>
implements Serializable {
    private Map<E, MutableInteger> map;
    private MapFactory mapFactory;
    private int totalCount;
    private int defaultValue;
    private static final Comparator<Object> naturalComparator = new NaturalComparator<Object>();
    private static final long serialVersionUID = 4L;
    private transient MutableInteger tempMInteger = null;

    public IntCounter() {
        this(MapFactory.hashMapFactory());
    }

    public IntCounter(MapFactory<E, MutableInteger> mapFactory) {
        this.mapFactory = mapFactory;
        this.map = mapFactory.newMap();
        this.totalCount = 0;
    }

    public IntCounter(IntCounter<E> c) {
        this();
        this.addAll(c);
    }

    public MapFactory<E, MutableInteger> getMapFactory() {
        return (MapFactory)ErasureUtils.uncheckedCast(this.mapFactory);
    }

    @Override
    public void setDefaultReturnValue(double rv) {
        this.defaultValue = (int)rv;
    }

    @Override
    public double defaultReturnValue() {
        return this.defaultValue;
    }

    public int totalIntCount() {
        return this.totalCount;
    }

    public double totalDoubleCount() {
        return this.totalCount;
    }

    public int totalIntCount(Filter<E> filter) {
        int total = 0;
        for (E key : this.map.keySet()) {
            if (!filter.accept(key)) continue;
            total += this.getIntCount(key);
        }
        return total;
    }

    public double totalDoubleCount(Filter<E> filter) {
        return this.totalIntCount(filter);
    }

    public double totalCount(Filter<E> filter) {
        return this.totalDoubleCount(filter);
    }

    public double averageCount() {
        return this.totalCount() / (double)this.map.size();
    }

    @Override
    public double getCount(Object key) {
        return this.getIntCount(key);
    }

    public String getCountAsString(E key) {
        return Integer.toString(this.getIntCount(key));
    }

    public int getIntCount(Object key) {
        MutableInteger count = this.map.get(key);
        if (count == null) {
            return this.defaultValue;
        }
        return count.intValue();
    }

    public double getNormalizedCount(E key) {
        return this.getCount(key) / this.totalCount();
    }

    public void setCount(E key, int count) {
        if (this.tempMInteger == null) {
            this.tempMInteger = new MutableInteger();
        }
        this.tempMInteger.set(count);
        this.tempMInteger = this.map.put(key, this.tempMInteger);
        this.totalCount += count;
        if (this.tempMInteger != null) {
            this.totalCount -= this.tempMInteger.intValue();
        }
    }

    public void setCount(E key, String s) {
        this.setCount(key, Integer.parseInt(s));
    }

    public void setCounts(Collection<E> keys, int count) {
        for (E key : keys) {
            this.setCount(key, count);
        }
    }

    public int incrementCount(E key, int count) {
        if (this.tempMInteger == null) {
            this.tempMInteger = new MutableInteger();
        }
        MutableInteger oldMInteger = this.map.put(key, this.tempMInteger);
        this.totalCount += count;
        if (oldMInteger != null) {
            count += oldMInteger.intValue();
        }
        this.tempMInteger.set(count);
        this.tempMInteger = oldMInteger;
        return count;
    }

    @Override
    public double incrementCount(E key) {
        return this.incrementCount(key, 1.0);
    }

    public void incrementCounts(Collection<E> keys, int count) {
        for (E key : keys) {
            this.incrementCount(key, count);
        }
    }

    public void incrementCounts(Collection<E> keys) {
        this.incrementCounts(keys, 1);
    }

    public int decrementCount(E key, int count) {
        return this.incrementCount(key, -count);
    }

    @Override
    public double decrementCount(E key) {
        return this.decrementCount(key, 1);
    }

    public void decrementCounts(Collection<E> keys, int count) {
        this.incrementCounts(keys, -count);
    }

    public void decrementCounts(Collection<E> keys) {
        this.decrementCounts(keys, 1);
    }

    @Override
    public void addAll(IntCounter<E> counter) {
        for (E key : counter.keySet()) {
            int count = counter.getIntCount(key);
            this.incrementCount(key, count);
        }
    }

    public void subtractAll(IntCounter<E> counter) {
        for (E key : this.map.keySet()) {
            this.decrementCount(key, counter.getIntCount(key));
        }
    }

    @Override
    public boolean containsKey(E key) {
        return this.map.containsKey(key);
    }

    @Override
    public double remove(E key) {
        this.totalCount = (int)((double)this.totalCount - this.getCount(key));
        MutableInteger val = this.map.remove(key);
        if (val == null) {
            return Double.NaN;
        }
        return val.doubleValue();
    }

    public void removeAll(Collection<E> c) {
        for (E key : c) {
            this.remove(key);
        }
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Set<E> keySet() {
        return this.map.keySet();
    }

    @Override
    public Set<Map.Entry<E, Double>> entrySet() {
        return new AbstractSet<Map.Entry<E, Double>>(){

            @Override
            public Iterator<Map.Entry<E, Double>> iterator() {
                return new Iterator<Map.Entry<E, Double>>(){
                    final Iterator<Map.Entry<E, MutableInteger>> inner;
                    {
                        this.inner = IntCounter.this.map.entrySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.inner.hasNext();
                    }

                    @Override
                    public Map.Entry<E, Double> next() {
                        return new Map.Entry<E, Double>(){
                            final Map.Entry<E, MutableInteger> e;
                            {
                                this.e = inner.next();
                            }

                            @Override
                            public E getKey() {
                                return this.e.getKey();
                            }

                            @Override
                            public Double getValue() {
                                return this.e.getValue().doubleValue();
                            }

                            @Override
                            public Double setValue(Double value) {
                                double old = this.e.getValue().doubleValue();
                                this.e.getValue().set(value.intValue());
                                IntCounter.this.totalCount = IntCounter.this.totalCount - (int)old + value.intValue();
                                return old;
                            }
                        };
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return IntCounter.this.map.size();
            }
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IntCounter)) {
            return false;
        }
        IntCounter counter = (IntCounter)o;
        return ((Object)this.map).equals(counter.map);
    }

    public int hashCode() {
        return ((Object)this.map).hashCode();
    }

    public String toString() {
        return this.map.toString();
    }

    public String toString(NumberFormat nf, String preAppend, String postAppend, String keyValSeparator, String itemSeparator) {
        StringBuilder sb = new StringBuilder();
        sb.append(preAppend);
        ArrayList<E> list = new ArrayList<E>(this.map.keySet());
        try {
            Collections.sort(list);
        }
        catch (Exception e) {
            // empty catch block
        }
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object key = iter.next();
            MutableInteger d = this.map.get(key);
            sb.append(key + keyValSeparator);
            sb.append(nf.format(d));
            if (!iter.hasNext()) continue;
            sb.append(itemSeparator);
        }
        sb.append(postAppend);
        return sb.toString();
    }

    public String toString(NumberFormat nf) {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        ArrayList<E> list = new ArrayList<E>(this.map.keySet());
        try {
            Collections.sort(list);
        }
        catch (Exception e) {
            // empty catch block
        }
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object key = iter.next();
            MutableInteger d = this.map.get(key);
            sb.append(key + "=");
            sb.append(nf.format(d));
            if (!iter.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }

    public Object clone() {
        return new IntCounter<E>(this);
    }

    public void removeZeroCounts() {
        Iterator<E> iter = this.map.keySet().iterator();
        while (iter.hasNext()) {
            if (this.getCount(iter.next()) != 0.0) continue;
            iter.remove();
        }
    }

    public int max() {
        int max = Integer.MIN_VALUE;
        for (E key : this.map.keySet()) {
            max = Math.max(max, this.getIntCount(key));
        }
        return max;
    }

    public double doubleMax() {
        return this.max();
    }

    public int min() {
        int min = Integer.MAX_VALUE;
        for (E key : this.map.keySet()) {
            min = Math.min(min, this.getIntCount(key));
        }
        return min;
    }

    public E argmax(Comparator<E> tieBreaker) {
        int max = Integer.MIN_VALUE;
        Object argmax = null;
        for (E key : this.keySet()) {
            int count = this.getIntCount(key);
            if (argmax != null && count <= max && (count != max || tieBreaker.compare(key, argmax) >= 0)) continue;
            max = count;
            argmax = key;
        }
        return (E)argmax;
    }

    public E argmax() {
        return this.argmax((Comparator)ErasureUtils.uncheckedCast(naturalComparator));
    }

    public E argmin(Comparator<E> tieBreaker) {
        int min = Integer.MAX_VALUE;
        Object argmin = null;
        for (E key : this.map.keySet()) {
            int count = this.getIntCount(key);
            if (argmin != null && count >= min && (count != min || tieBreaker.compare(key, argmin) >= 0)) continue;
            min = count;
            argmin = key;
        }
        return (E)argmin;
    }

    public E argmin() {
        return this.argmin((Comparator)ErasureUtils.uncheckedCast(naturalComparator));
    }

    public Set<E> keysAbove(int countThreshold) {
        HashSet<E> keys = new HashSet<E>();
        for (E key : this.map.keySet()) {
            if (this.getIntCount(key) < countThreshold) continue;
            keys.add(key);
        }
        return keys;
    }

    public Set<E> keysBelow(int countThreshold) {
        HashSet<E> keys = new HashSet<E>();
        for (E key : this.map.keySet()) {
            if (this.getIntCount(key) > countThreshold) continue;
            keys.add(key);
        }
        return keys;
    }

    public Set<E> keysAt(int count) {
        HashSet<E> keys = new HashSet<E>();
        for (E key : this.map.keySet()) {
            if (this.getIntCount(key) != count) continue;
            keys.add(key);
        }
        return keys;
    }

    @Override
    public Factory<Counter<E>> getFactory() {
        return new Factory<Counter<E>>(){
            private static final long serialVersionUID = 7470763055803428477L;

            @Override
            public Counter<E> create() {
                return new IntCounter(IntCounter.this.getMapFactory());
            }
        };
    }

    @Override
    public void setCount(E key, double value) {
        this.setCount(key, (int)value);
    }

    @Override
    public double incrementCount(E key, double value) {
        this.incrementCount(key, (int)value);
        return this.getCount(key);
    }

    @Override
    public double totalCount() {
        return this.totalDoubleCount();
    }

    @Override
    public Collection<Double> values() {
        return new AbstractCollection<Double>(){

            @Override
            public Iterator<Double> iterator() {
                return new Iterator<Double>(){
                    Iterator<MutableInteger> inner;
                    {
                        this.inner = IntCounter.this.map.values().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.inner.hasNext();
                    }

                    @Override
                    public Double next() {
                        return this.inner.next().doubleValue();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return IntCounter.this.map.size();
            }
        };
    }

    public Iterator<E> iterator() {
        return this.keySet().iterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NaturalComparator<T>
    implements Comparator<T> {
        private NaturalComparator() {
        }

        @Override
        public int compare(T o1, T o2) {
            if (o1 instanceof Comparable) {
                return ((Comparable)ErasureUtils.uncheckedCast(o1)).compareTo(o2);
            }
            return 0;
        }
    }
}

