/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.io;

import edu.stanford.nlp.io.NumberRangesFileFilter;
import edu.stanford.nlp.tagger.io.TaggedFileReader;
import edu.stanford.nlp.tagger.io.TextTaggedFileReader;
import edu.stanford.nlp.tagger.io.TreeTaggedFileReader;
import edu.stanford.nlp.trees.TreeNormalizer;
import edu.stanford.nlp.trees.TreeTransformer;
import edu.stanford.nlp.util.ReflectionLoading;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaggerFileRecord {
    final String file;
    final Format format;
    final String encoding;
    final String tagSeparator;
    final TreeTransformer treeTransformer;
    final TreeNormalizer treeNormalizer;
    final NumberRangesFileFilter treeRange;
    static final String FORMAT = "format";
    static final String ENCODING = "encoding";
    static final String TAG_SEPARATOR = "tagSeparator";
    static final String TREE_TRANSFORMER = "treeTransformer";
    static final String TREE_NORMALIZER = "treeNormalizer";
    static final String TREE_RANGE = "treeRange";

    private TaggerFileRecord(String file, Format format, String encoding, String tagSeparator, TreeTransformer treeTransformer, TreeNormalizer treeNormalizer, NumberRangesFileFilter treeRange) {
        this.file = file;
        this.format = format;
        this.encoding = encoding;
        this.tagSeparator = tagSeparator;
        this.treeTransformer = treeTransformer;
        this.treeNormalizer = treeNormalizer;
        this.treeRange = treeRange;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("format=" + (Object)((Object)this.format));
        s.append(",encoding=" + this.encoding);
        s.append(",tagSeparator=" + this.tagSeparator);
        if (this.treeTransformer != null) {
            s.append(",treeTransformer=" + this.treeTransformer.getClass().getName());
        }
        if (this.treeNormalizer != null) {
            s.append(",treeNormalizer=" + this.treeNormalizer.getClass().getName());
        }
        if (this.treeRange != null) {
            s.append(",treeRange=" + this.treeRange);
        }
        return s.toString();
    }

    public String filename() {
        return this.file;
    }

    public TaggedFileReader reader() {
        switch (this.format) {
            case TEXT: {
                return new TextTaggedFileReader(this);
            }
            case TREES: {
                return new TreeTaggedFileReader(this);
            }
        }
        throw new IllegalArgumentException("Unknown format " + (Object)((Object)this.format));
    }

    public static List<TaggerFileRecord> createRecords(Properties config, String description) {
        String[] pieces = description.split(";");
        ArrayList<TaggerFileRecord> records = new ArrayList<TaggerFileRecord>();
        for (String piece : pieces) {
            records.add(TaggerFileRecord.createRecord(config, piece));
        }
        return records;
    }

    public static TaggerFileRecord createRecord(Properties config, String description) {
        String[] pieces = description.split(",");
        if (pieces.length == 1) {
            return new TaggerFileRecord(description, Format.TEXT, TaggerFileRecord.getEncoding(config), TaggerFileRecord.getTagSeparator(config), null, null, null);
        }
        String[] args = new String[pieces.length - 1];
        System.arraycopy(pieces, 0, args, 0, pieces.length - 1);
        String file = pieces[pieces.length - 1];
        Format format = Format.TEXT;
        String encoding = TaggerFileRecord.getEncoding(config);
        String tagSeparator = TaggerFileRecord.getTagSeparator(config);
        TreeTransformer treeTransformer = null;
        TreeNormalizer treeNormalizer = null;
        NumberRangesFileFilter treeRange = null;
        for (String arg : args) {
            String[] argPieces = arg.split("=", 2);
            if (argPieces.length != 2) {
                throw new IllegalArgumentException("TaggerFileRecord argument " + arg + " has an unexpected number of =s");
            }
            if (argPieces[0].equalsIgnoreCase(FORMAT)) {
                format = Format.valueOf(argPieces[1]);
                continue;
            }
            if (argPieces[0].equalsIgnoreCase(ENCODING)) {
                encoding = argPieces[1];
                continue;
            }
            if (argPieces[0].equalsIgnoreCase(TAG_SEPARATOR)) {
                tagSeparator = argPieces[1];
                continue;
            }
            if (argPieces[0].equalsIgnoreCase(TREE_TRANSFORMER)) {
                treeTransformer = (TreeTransformer)ReflectionLoading.loadByReflection(argPieces[1], new Object[0]);
                continue;
            }
            if (argPieces[0].equalsIgnoreCase(TREE_NORMALIZER)) {
                treeNormalizer = (TreeNormalizer)ReflectionLoading.loadByReflection(argPieces[1], new Object[0]);
                continue;
            }
            if (argPieces[0].equalsIgnoreCase(TREE_RANGE)) {
                treeRange = new NumberRangesFileFilter(argPieces[1], true);
                continue;
            }
            throw new IllegalArgumentException("TaggerFileRecord argument " + argPieces[0] + " is unknown");
        }
        return new TaggerFileRecord(file, format, encoding, tagSeparator, treeTransformer, treeNormalizer, treeRange);
    }

    public static String getEncoding(Properties config) {
        String encoding = config.getProperty(ENCODING);
        if (encoding == null) {
            return "UTF-8";
        }
        return encoding;
    }

    public static String getTagSeparator(Properties config) {
        String tagSeparator = config.getProperty(TAG_SEPARATOR);
        if (tagSeparator == null) {
            return "/";
        }
        return tagSeparator;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Format {
        TEXT,
        TREES;

    }
}

