/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.io;

import edu.stanford.nlp.ling.TaggedWord;
import edu.stanford.nlp.tagger.io.TaggedFileReader;
import edu.stanford.nlp.tagger.io.TaggerFileRecord;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextTaggedFileReader
implements TaggedFileReader {
    final BufferedReader reader;
    final String tagSeparator;
    final String filename;
    int numSentences = 0;
    List<TaggedWord> next;

    public TextTaggedFileReader(TaggerFileRecord record) {
        this.filename = record.file;
        try {
            this.reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.filename), record.encoding));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.tagSeparator = record.tagSeparator;
        this.primeNext();
    }

    @Override
    public Iterator<List<TaggedWord>> iterator() {
        return this;
    }

    @Override
    public String filename() {
        return this.filename;
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public List<TaggedWord> next() {
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        List<TaggedWord> thisIteration = this.next;
        this.primeNext();
        return thisIteration;
    }

    void primeNext() {
        String line;
        try {
            line = this.reader.readLine();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (line == null) {
            this.next = null;
            return;
        }
        ++this.numSentences;
        this.next = new ArrayList<TaggedWord>();
        StringTokenizer st = new StringTokenizer(line);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            int indexUnd = token.lastIndexOf(this.tagSeparator);
            if (indexUnd < 0) {
                throw new IllegalArgumentException("Data format error: can't find delimiter \"" + this.tagSeparator + "\" in word \"" + token + "\" (line " + (this.numSentences + 1) + " of " + this.filename + ')');
            }
            String word = token.substring(0, indexUnd).intern();
            String tag = token.substring(indexUnd + 1).intern();
            this.next.add(new TaggedWord(word, tag));
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

