/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.io;

import edu.stanford.nlp.ling.TaggedWord;
import edu.stanford.nlp.tagger.io.TaggedFileReader;
import edu.stanford.nlp.tagger.io.TaggerFileRecord;
import edu.stanford.nlp.trees.DiskTreebank;
import edu.stanford.nlp.trees.LabeledScoredTreeReaderFactory;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeNormalizer;
import edu.stanford.nlp.trees.TreeReaderFactory;
import edu.stanford.nlp.trees.TreeTransformer;
import edu.stanford.nlp.trees.Treebank;
import java.io.FileFilter;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeTaggedFileReader
implements TaggedFileReader {
    final Treebank treebank;
    final String filename;
    final TreeReaderFactory trf;
    final TreeTransformer transformer;
    final TreeNormalizer normalizer;
    final Iterator<Tree> treeIterator;
    int numSentences = 0;

    public TreeTaggedFileReader(TaggerFileRecord record) {
        this.filename = record.file;
        this.trf = new LabeledScoredTreeReaderFactory();
        this.transformer = record.treeTransformer;
        this.normalizer = record.treeNormalizer;
        this.treebank = new DiskTreebank(this.trf, record.encoding);
        if (record.treeRange != null) {
            this.treebank.loadPath(this.filename, (FileFilter)record.treeRange);
        } else {
            this.treebank.loadPath(this.filename);
        }
        this.treeIterator = this.treebank.iterator();
    }

    @Override
    public Iterator<List<TaggedWord>> iterator() {
        return this;
    }

    @Override
    public String filename() {
        return this.filename;
    }

    @Override
    public boolean hasNext() {
        return this.treeIterator.hasNext();
    }

    @Override
    public List<TaggedWord> next() {
        Tree t = this.treeIterator.next();
        if (this.normalizer != null) {
            t = this.normalizer.normalizeWholeTree(t, t.treeFactory());
        }
        if (this.transformer != null) {
            t = t.transform(this.transformer);
        }
        return t.taggedYield();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

