/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.maxent;

import edu.stanford.nlp.tagger.maxent.MaxentTagger;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class MaxentTaggerGUI
extends JFrame {
    private static final long serialVersionUID = -2574711492469740892L;
    private final JTextArea inputBox = new JTextArea();
    private final JTextArea outputBox = new JTextArea();
    private final JButton tagButton = new JButton();
    private static MaxentTagger tagger;

    public MaxentTaggerGUI() {
        super("Maximum Entropy Part of Speech Tagger");
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(final String[] args) {
        Thread t = new Thread(){

            public void run() {
                try {
                    String file = args.length > 0 ? args[args.length - 1] : "models/left3words-wsj-0-18.tagger";
                    tagger = new MaxentTagger(file);
                }
                catch (Exception e) {
                    try {
                        String file = MaxentTagger.DEFAULT_NLP_GROUP_MODEL_PATH;
                        tagger = new MaxentTagger(file);
                    }
                    catch (Exception e2) {
                        e.printStackTrace();
                    }
                }
            }
        };
        t.start();
        MaxentTaggerGUI mainFrame1 = new MaxentTaggerGUI();
        mainFrame1.setPreferredSize(new Dimension(400, 200));
        mainFrame1.pack();
        mainFrame1.setVisible(true);
    }

    private void jbInit() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        this.inputBox.setLineWrap(true);
        this.inputBox.setWrapStyleWord(true);
        this.outputBox.setLineWrap(true);
        this.outputBox.setWrapStyleWord(true);
        this.outputBox.setEditable(false);
        JScrollPane scroll1 = new JScrollPane(this.inputBox);
        JScrollPane scroll2 = new JScrollPane(this.outputBox);
        scroll1.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Type a sentence to tag: "));
        scroll2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Tagged sentence: "));
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBackground(Color.WHITE);
        buttonPanel.applyComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        FlowLayout fl = new FlowLayout();
        fl.setAlignment(2);
        buttonPanel.setLayout(fl);
        this.tagButton.setText("Tag sentence!");
        this.tagButton.setBackground(Color.WHITE);
        buttonPanel.add(this.tagButton);
        this.tagButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MaxentTaggerGUI.this.performTagAction(e);
            }
        });
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.gridwidth = 0;
        c.weightx = 4.0;
        c.weighty = 4.0;
        this.add((Component)scroll1, c);
        c.weighty = 1.0;
        this.add((Component)buttonPanel, c);
        c.weighty = 4.0;
        c.gridheight = 0;
        this.add((Component)scroll2, c);
    }

    private void performTagAction(ActionEvent e) {
        final String s = this.inputBox.getText();
        Thread t = new Thread(){

            public void run() {
                final String taggedStr = tagger.tagString(s);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        MaxentTaggerGUI.this.outputBox.setText(taggedStr);
                    }
                });
            }
        };
        t.start();
    }
}

