/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.maxent;

import edu.stanford.nlp.io.InDataStreamFile;
import edu.stanford.nlp.io.OutDataStreamFile;
import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.util.HashIndex;
import edu.stanford.nlp.util.Index;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TTags {
    private Index<String> index = new HashIndex<String>();
    private final HashSet<String> closed = new HashSet();
    private HashSet<String> openTags = null;
    private boolean isEnglish = false;
    private boolean openFixed = false;
    static final int CLOSED_TAG_THRESHOLD = 40;
    private final int closedTagThreshold = 40;
    private boolean learnClosedTags = false;
    private final Map<String, String[]> deterministicExpansionMemoizer = new HashMap<String, String[]>();

    public TTags() {
    }

    TTags(String language) {
        if (language.equalsIgnoreCase("english")) {
            this.closed.add(".");
            this.closed.add(",");
            this.closed.add("``");
            this.closed.add("''");
            this.closed.add(":");
            this.closed.add("$");
            this.closed.add("EX");
            this.closed.add("(");
            this.closed.add(")");
            this.closed.add("#");
            this.closed.add("MD");
            this.closed.add("CC");
            this.closed.add("DT");
            this.closed.add("LS");
            this.closed.add("PDT");
            this.closed.add("POS");
            this.closed.add("PRP");
            this.closed.add("PRP$");
            this.closed.add("RP");
            this.closed.add("TO");
            this.closed.add(".$$.");
            this.closed.add("UH");
            this.closed.add("WDT");
            this.closed.add("WP");
            this.closed.add("WP$");
            this.closed.add("WRB");
            this.closed.add("-LRB-");
            this.closed.add("-RRB-");
            this.isEnglish = true;
        } else if (language.equalsIgnoreCase("polish")) {
            this.closed.add(".");
            this.closed.add(",");
            this.closed.add("``");
            this.closed.add("''");
            this.closed.add(":");
            this.closed.add("$");
            this.closed.add("(");
            this.closed.add(")");
            this.closed.add("#");
            this.closed.add("POS");
            this.closed.add(".$$.");
            this.closed.add("ppron12");
            this.closed.add("ppron3");
            this.closed.add("siebie");
            this.closed.add("qub");
            this.closed.add("conj");
        } else if (language.equalsIgnoreCase("chinese")) {
            this.closed.add("AS");
            this.closed.add("BA");
            this.closed.add("CC");
            this.closed.add("CS");
            this.closed.add("DEC");
            this.closed.add("DEG");
            this.closed.add("DER");
            this.closed.add("DEV");
            this.closed.add("DT");
            this.closed.add("ETC");
            this.closed.add("IJ");
            this.closed.add("LB");
            this.closed.add("LC");
            this.closed.add("P");
            this.closed.add("PN");
            this.closed.add("PU");
            this.closed.add("SB");
            this.closed.add("SP");
            this.closed.add("VC");
            this.closed.add("VE");
        } else if (language.equalsIgnoreCase("arabic")) {
            this.closed.add("PUNC");
            this.closed.add("CC");
            this.closed.add("CPRP$");
            this.closed.add(".$$.");
        } else if (language.equalsIgnoreCase("german")) {
            this.closed.add("$,");
            this.closed.add("$.");
            this.closed.add("$(");
            this.closed.add("--");
            this.closed.add(".$$.");
            this.closed.add("KOKOM");
            this.closed.add("PPOSS");
            this.closed.add("PTKA");
            this.closed.add("PTKNEG");
            this.closed.add("PWAT");
            this.closed.add("VAINF");
            this.closed.add("VAPP");
            this.closed.add("VMINF");
            this.closed.add("VMPP");
        } else if (language.equalsIgnoreCase("medpost")) {
            this.closed.add(".");
            this.closed.add(",");
            this.closed.add("``");
            this.closed.add("''");
            this.closed.add(":");
            this.closed.add("$");
            this.closed.add("EX");
            this.closed.add("(");
            this.closed.add(")");
            this.closed.add("VM");
            this.closed.add("CC");
            this.closed.add("DD");
            this.closed.add("DB");
            this.closed.add("GE");
            this.closed.add("PND");
            this.closed.add("PNG");
            this.closed.add("TO");
            this.closed.add(".$$.");
            this.closed.add("-LRB-");
            this.closed.add("-RRB-");
        } else if (!language.equalsIgnoreCase("")) {
            throw new RuntimeException("unknown language: " + language);
        }
    }

    public Set<String> getOpenTags() {
        if (this.openTags == null) {
            HashSet<String> open = new HashSet<String>();
            for (String tag : this.index) {
                if (this.closed.contains(tag)) continue;
                open.add(tag);
            }
            this.openTags = open;
        }
        return this.openTags;
    }

    protected int add(String tag) {
        this.index.add(tag);
        return this.index.indexOf(tag);
    }

    public String getTag(int i) {
        return this.index.get(i);
    }

    protected void save(String filename, HashMap<String, HashSet<String>> tagTokens) {
        try {
            OutDataStreamFile out2 = new OutDataStreamFile(filename);
            this.save(out2, tagTokens);
            out2.close();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    protected void save(DataOutputStream file, HashMap<String, HashSet<String>> tagTokens) {
        try {
            file.writeInt(this.index.size());
            for (String item : this.index) {
                file.writeUTF(item);
                if (this.learnClosedTags && tagTokens.get(item).size() < 40) {
                    this.markClosed(item);
                }
                file.writeBoolean(this.isClosed(item));
            }
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    protected void read(String filename) {
        try {
            InDataStreamFile in = new InDataStreamFile(filename);
            this.read(in);
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void read(DataInputStream file) {
        try {
            int size = file.readInt();
            this.index = new HashIndex<String>();
            for (int i = 0; i < size; ++i) {
                String tag = file.readUTF();
                boolean inClosed = file.readBoolean();
                this.index.add(tag);
                if (!inClosed) continue;
                this.closed.add(tag);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected boolean isClosed(String tag) {
        if (this.openFixed) {
            return !this.openTags.contains(tag);
        }
        return this.closed.contains(tag);
    }

    void markClosed(String tag) {
        this.add(tag);
        this.closed.add(tag);
    }

    public void setLearnClosedTags(boolean learn) {
        this.learnClosedTags = learn;
    }

    public void setOpenClassTags(String[] openClassTags) {
        this.openTags = new HashSet();
        this.openTags.addAll(Arrays.asList(openClassTags));
        for (String tag : openClassTags) {
            this.add(tag);
        }
        this.openFixed = true;
    }

    public void setClosedClassTags(String[] closedClassTags) {
        for (String tag : closedClassTags) {
            this.markClosed(tag);
        }
    }

    int getIndex(String tag) {
        return this.index.indexOf(tag);
    }

    public int getSize() {
        return this.index.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String[] deterministicallyExpandTags(String[] tags, String word) {
        String[] cached;
        Map<String, String[]> map = this.deterministicExpansionMemoizer;
        synchronized (map) {
            cached = this.deterministicExpansionMemoizer.get(word);
        }
        if (cached != null) {
            return cached;
        }
        if (this.isEnglish) {
            ArrayList<String> tl = new ArrayList<String>(tags.length + 2);
            int yVBD = this.getIndex("VBD");
            int yVBN = this.getIndex("VBN");
            int yVBP = this.getIndex("VBP");
            int yVB = this.getIndex("VB");
            if (yVBD < 0 || yVBN < 0 || yVBP < 0 || yVB < 0) {
                System.err.println("Language erroneously set to 'english' when it isn't UPenn English tag set!!");
                return tags;
            }
            for (String tag : tags) {
                int y = this.getIndex(tag);
                assert (y >= 0);
                TTags.addIfAbsent(tl, tag);
                if (y == yVBD) {
                    TTags.addIfAbsent(tl, "VBN");
                    continue;
                }
                if (y == yVBN) {
                    TTags.addIfAbsent(tl, "VBD");
                    continue;
                }
                if (y == yVB) {
                    TTags.addIfAbsent(tl, "VBP");
                    continue;
                }
                if (y != yVBP) continue;
                TTags.addIfAbsent(tl, "VB");
            }
            String[] newtags = tl.toArray(new String[tl.size()]);
            Map<String, String[]> map2 = this.deterministicExpansionMemoizer;
            synchronized (map2) {
                this.deterministicExpansionMemoizer.put(word, newtags);
            }
            return newtags;
        }
        return tags;
    }

    private static void addIfAbsent(List<String> list, String item) {
        if (!list.contains(item)) {
            list.add(item);
        }
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(this.index.toString());
        s.append(" ");
        if (this.openFixed) {
            s.append(" OPEN:" + this.getOpenTags());
        } else {
            s.append(" open:" + this.getOpenTags() + " CLOSED:" + this.closed);
        }
        return s.toString();
    }
}

