/*
 * Decompiled with CFR 0.152.
 */
package AutoExtractor;

import AutoExtractor.Actors;
import AutoExtractor.GovDepReln;
import AutoExtractor.ReadAndImprove;
import AutoExtractor.Sentiwordnet;
import AutoExtractor.SpecialVerbs;
import AutoExtractor.SubOb;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.ling.LabeledWord;
import edu.stanford.nlp.ling.Word;
import edu.stanford.nlp.parser.lexparser.LexicalizedParser;
import edu.stanford.nlp.process.DocumentPreprocessor;
import edu.stanford.nlp.trees.GrammaticalStructure;
import edu.stanford.nlp.trees.GrammaticalStructureFactory;
import edu.stanford.nlp.trees.PennTreebankLanguagePack;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TypedDependency;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import rita.wordnet.RiWordnet;

public class Parser {
    static Tree parse;
    static LexicalizedParser lp;
    static RiWordnet wordnet;
    static String passage;
    static ArrayList<String> verbList;
    static ArrayList<GovDepReln> allRelations;
    static HashMap<String, ArrayList<SubOb>> humans;
    static HashMap<String, ArrayList<SubOb>> subjects;
    static HashMap<String, ArrayList<SubOb>> objects;
    static HashMap<String, ArrayList<SubOb>> passSubj;
    static ArrayList<Actors> actorProperties;
    static ArrayList<String> conj;

    static {
        lp = LexicalizedParser.loadModel("edu/stanford/nlp/models/lexparser/englishPCFG.ser.gz", new String[0]);
        wordnet = new RiWordnet();
        passage = "";
        verbList = new ArrayList();
        allRelations = new ArrayList();
        humans = new HashMap();
        subjects = new HashMap();
        objects = new HashMap();
        passSubj = new HashMap();
        actorProperties = new ArrayList();
        conj = new ArrayList();
    }

    public static void main(String[] args) throws IOException, ClassNotFoundException {
        ArrayList<String> sentences = ReadAndImprove.parseSentence("text");
        for (String sent : sentences) {
            ReadAndImprove.writeBackToFile(sent, "text");
            Parser.caller("text");
        }
    }

    public static void caller(String fileName) throws IOException {
        Parser.readFromFileAB(fileName);
        Parser.returnVerbList(fileName);
        Parser.allRealtions();
        Parser.conjPassList();
        Parser.actors();
        Parser.returnImportantVerbsforEachActor();
        Parser.subjectRemove();
        for (Actors a : actorProperties) {
            Parser.addMoreModifiers(a);
            Parser.actorType(a);
            Parser.actionImpactDeterminer(a);
        }
        Parser.cleanUP();
        String toSendAttV = "";
        String toSendAttI = "";
        String toSendUs = "";
        System.out.println("\n");
        for (Actors s : actorProperties) {
            if (s.type.equalsIgnoreCase("at")) {
                for (String sV : s.vectors) {
                    if (!sV.isEmpty()) {
                        toSendAttV = String.valueOf(toSendAttV) + sV + " || ";
                    }
                    System.out.println("\nAttacker Actions: " + sV);
                }
                if (toSendAttV.endsWith(" || ")) {
                    toSendAttV = toSendAttV.substring(0, toSendAttV.lastIndexOf(" || "));
                }
                for (String sT : s.impact) {
                    if (!sT.isEmpty()) {
                        toSendAttI = String.valueOf(toSendAttI) + sT + " || ";
                    }
                    System.out.println("\nPost Conditions : " + sT);
                }
                if (!toSendAttI.endsWith(" || ")) continue;
                toSendAttI = toSendAttI.substring(0, toSendAttI.lastIndexOf(" || "));
                continue;
            }
            if (s.type.equalsIgnoreCase("ot")) {
                for (String sT : s.actions) {
                    System.out.println("\nOther actions: " + sT);
                }
                continue;
            }
            for (String sT : s.actions) {
                if (!sT.isEmpty()) {
                    toSendUs = String.valueOf(toSendUs) + sT + " || ";
                }
                System.out.println("\nUser actions: " + sT);
            }
            if (!toSendUs.endsWith(" || ")) continue;
            toSendUs = toSendUs.substring(0, toSendUs.lastIndexOf(" || "));
        }
    }

    private static void cleanUP() {
        boolean b = true;
        while (b) {
            for (Actors act : actorProperties) {
                if (act.type.equalsIgnoreCase("ot")) continue;
                for (Actors actOther : actorProperties) {
                    String replaceF;
                    int indexOfCutF;
                    int indu;
                    String ifRemove;
                    String s;
                    if (actOther.type.equalsIgnoreCase("ot")) continue;
                    ArrayList<String> toRemove = new ArrayList<String>();
                    Iterator<String> iterator = act.actions.iterator();
                    while (iterator.hasNext()) {
                        ifRemove = s = iterator.next();
                        s = Parser.andOrRemover(s);
                        for (String s1 : actOther.actions) {
                            indu = actOther.actions.indexOf(s1);
                            if (s.equalsIgnoreCase(s1 = Parser.andOrRemover(s1))) continue;
                            indexOfCutF = s1.indexOf(s);
                            replaceF = "";
                            if (indexOfCutF == -1) continue;
                            replaceF = s1.substring(indexOfCutF, indexOfCutF + s.length());
                            s1 = s1.replaceAll(replaceF, "");
                            actOther.actions.set(indu, s1);
                            b = false;
                            toRemove.add(ifRemove);
                        }
                        for (String s1 : actOther.impact) {
                            indu = actOther.impact.indexOf(s1);
                            s1 = Parser.andOrRemover(s1);
                            indexOfCutF = s1.indexOf(s);
                            replaceF = "";
                            if (indexOfCutF == -1) continue;
                            replaceF = s1.substring(indexOfCutF, indexOfCutF + s.length());
                            s1 = s1.replaceAll(replaceF, "");
                            actOther.impact.set(indu, s1);
                            b = false;
                            toRemove.add(ifRemove);
                        }
                        for (String s1 : actOther.vectors) {
                            indu = actOther.vectors.indexOf(s1);
                            s1 = Parser.andOrRemover(s1);
                            indexOfCutF = s1.indexOf(s);
                            replaceF = "";
                            if (indexOfCutF == -1) continue;
                            replaceF = s1.substring(indexOfCutF, indexOfCutF + s.length());
                            s1 = s1.replaceAll(replaceF, "");
                            actOther.vectors.set(indu, s1);
                            b = false;
                            toRemove.add(ifRemove);
                        }
                    }
                    toRemove.clear();
                    iterator = act.impact.iterator();
                    while (iterator.hasNext()) {
                        ifRemove = s = iterator.next();
                        s = Parser.andOrRemover(s);
                        for (String s1 : actOther.actions) {
                            indu = actOther.actions.indexOf(s1);
                            s1 = Parser.andOrRemover(s1);
                            indexOfCutF = s1.indexOf(s);
                            replaceF = "";
                            if (indexOfCutF == -1) continue;
                            replaceF = s1.substring(indexOfCutF, indexOfCutF + s.length());
                            s1 = s1.replaceAll(replaceF, "");
                            actOther.actions.set(indu, s1);
                            b = false;
                            toRemove.add(ifRemove);
                        }
                        for (String s1 : actOther.impact) {
                            indu = actOther.impact.indexOf(s1);
                            if (s.equalsIgnoreCase(s1 = Parser.andOrRemover(s1))) continue;
                            indexOfCutF = s1.indexOf(s);
                            replaceF = "";
                            if (indexOfCutF == -1) continue;
                            replaceF = s1.substring(indexOfCutF, indexOfCutF + s.length());
                            s1 = s1.replaceAll(replaceF, "");
                            actOther.impact.set(indu, s1);
                            b = false;
                            toRemove.add(ifRemove);
                        }
                        for (String s1 : actOther.vectors) {
                            indu = actOther.vectors.indexOf(s1);
                            s1 = Parser.andOrRemover(s1);
                            indexOfCutF = s1.indexOf(s);
                            replaceF = "";
                            if (indexOfCutF == -1) continue;
                            replaceF = s1.substring(indexOfCutF, indexOfCutF + s.length());
                            s1 = s1.replaceAll(replaceF, "");
                            actOther.vectors.set(indu, s1);
                            b = false;
                            toRemove.add(ifRemove);
                        }
                    }
                    toRemove.clear();
                    iterator = act.vectors.iterator();
                    while (iterator.hasNext()) {
                        String replaceF2;
                        int indu2;
                        ifRemove = s = iterator.next();
                        s = Parser.andOrRemover(s);
                        boolean removable = false;
                        for (String s1 : actOther.vectors) {
                            indu2 = actOther.vectors.indexOf(s1);
                            if (s.equalsIgnoreCase(s1 = Parser.andOrRemover(s1))) continue;
                            int indexOfCutF2 = s1.indexOf(s);
                            replaceF2 = "";
                            if (indexOfCutF2 == -1) continue;
                            if (!act.equals(actOther)) {
                                replaceF2 = s1.substring(indexOfCutF2, indexOfCutF2 + s.length());
                                s1 = s1.replaceAll(replaceF2, "");
                                actOther.vectors.set(indu2, s1);
                                b = false;
                                continue;
                            }
                            removable = true;
                            toRemove.add(ifRemove);
                        }
                        if (removable) continue;
                        for (String s1 : actOther.actions) {
                            indu2 = actOther.actions.indexOf(s1);
                            s1 = Parser.andOrRemover(s1);
                            int indexOfCutF3 = s1.indexOf(s);
                            replaceF2 = "";
                            if (indexOfCutF3 == -1) continue;
                            replaceF2 = s1.substring(indexOfCutF3, indexOfCutF3 + s.length());
                            s1 = s1.replaceAll(replaceF2, "");
                            actOther.actions.set(indu2, s1);
                            b = false;
                        }
                        for (String s1 : actOther.impact) {
                            indu2 = actOther.impact.indexOf(s1);
                            s1 = Parser.andOrRemover(s1);
                            int indexOfCutF4 = s1.indexOf(s);
                            replaceF2 = "";
                            if (indexOfCutF4 == -1) continue;
                            replaceF2 = s1.substring(indexOfCutF4, indexOfCutF4 + s.length());
                            s1 = s1.replaceAll(replaceF2, "");
                            actOther.impact.set(indu2, s1);
                            b = false;
                        }
                    }
                    act.vectors.removeAll(toRemove);
                    toRemove.clear();
                }
            }
            b = !b;
        }
        for (Actors act : actorProperties) {
            for (String s : act.actions) {
                int indu = act.actions.indexOf(s);
                s = Parser.andOrRemover(s);
                act.actions.set(indu, s);
            }
            for (String s : act.impact) {
                int indu = act.impact.indexOf(s);
                s = Parser.andOrRemover(s);
                act.impact.set(indu, s);
            }
            for (String s : act.vectors) {
                int indu = act.vectors.indexOf(s);
                s = Parser.andOrRemover(s);
                act.vectors.set(indu, s);
            }
        }
    }

    private static String extendPP(String mainVP, String PP) {
        int indexOfCutF = mainVP.indexOf(PP);
        if (indexOfCutF != -1) {
            PP = mainVP.substring(indexOfCutF, mainVP.length());
        }
        return PP.trim();
    }

    private static void actionImpactDeterminer(Actors act) throws IOException {
        ArrayList<SpecialVerbs> sV = act.verbList;
        for (SpecialVerbs s : sV) {
            Tree PP3;
            String PP3S;
            Tree PP2;
            String PP2S;
            Tree PP1;
            String PP1S;
            Tree VP2;
            String VP2S;
            Tree VP1L;
            String VP1LS;
            String changed1;
            if (Parser.treeToString(s.VP.firstChild()).equalsIgnoreCase("via") || Parser.treeToString(s.VP.firstChild()).equalsIgnoreCase("through") || Parser.treeToString(s.VP.firstChild()).equalsIgnoreCase("by") || Parser.treeToString(s.VP.firstChild()).equalsIgnoreCase("using")) {
                changed1 = s.treeString.trim();
                if (!changed1.contains(s.verb)) continue;
                if (act.type.equalsIgnoreCase("us")) {
                    act.addactions(changed1);
                    continue;
                }
                if (!act.type.equalsIgnoreCase("at")) continue;
                act.addvectors(changed1);
                continue;
            }
            if (act.type.equalsIgnoreCase("us")) {
                changed1 = s.treeString.trim();
                if (!changed1.contains(s.verb)) continue;
                act.addactions(changed1);
                continue;
            }
            if (!act.type.equalsIgnoreCase("at")) continue;
            changed1 = s.treeString.trim();
            Tree VP1 = Parser.traverseTreeReturnTree(s.VP, "VP", "resulting");
            String VP1S = Parser.treeToString(VP1);
            if (!VP1S.isEmpty()) {
                VP1S = VP1S.trim();
                act.addimpact(VP1S);
            }
            if (!(VP1LS = Parser.treeToString(VP1L = Parser.traverseTreeReturnTree(s.VP, "VP", "leading"))).isEmpty()) {
                VP1LS = VP1LS.trim();
                act.addimpact(VP1LS);
            }
            if (!(VP2S = Parser.treeToString(VP2 = Parser.traverseTreeReturnTree(s.VP, "VP", "using"))).isEmpty()) {
                VP2S = VP2S.trim();
                VP2S = Parser.extendPP(changed1, VP2S);
                act.addvectors(VP2S);
            }
            if (!(PP1S = Parser.treeToString(PP1 = Parser.traverseTreeReturnTree(s.VP, "PP", "with"))).isEmpty()) {
                PP1S = PP1S.trim();
                PP1S = Parser.extendPP(changed1, PP1S);
                act.addvectors(PP1S);
            }
            if (!(PP2S = Parser.treeToString(PP2 = Parser.traverseTreeReturnTree(s.VP, "PP", "via"))).isEmpty()) {
                PP2S = PP2S.trim();
                PP2S = Parser.extendPP(changed1, PP2S);
                act.addvectors(PP2S);
            }
            if (!(PP3S = Parser.treeToString(PP3 = Parser.traverseTreeReturnTree(s.VP, "PP", "by"))).isEmpty()) {
                PP3S = PP3S.trim();
                PP3S = Parser.extendPP(changed1, PP3S);
                act.addvectors(PP3S);
            }
            act.addimpact(changed1);
        }
    }

    private static String andOrRemover(String toRemove) {
        toRemove = toRemove.trim();
        toRemove = toRemove.replaceAll("[^a-zA-Z0-9]*$", "");
        boolean b = true;
        while (b) {
            for (String s : conj) {
                if (toRemove.startsWith(String.valueOf(s) + " ")) {
                    toRemove = toRemove.replaceFirst(s, "");
                    b = false;
                }
                if (!toRemove.endsWith(" " + s)) continue;
                toRemove = toRemove.substring(0, toRemove.lastIndexOf(s));
                b = false;
            }
            if (!b) {
                toRemove = toRemove.trim();
                toRemove = toRemove.replaceAll("[^a-zA-Z0-9]*$", "");
                b = true;
                continue;
            }
            b = false;
        }
        return toRemove.trim();
    }

    private static void conjPassList() {
        for (GovDepReln g : allRelations) {
            String[] splitut2;
            if (g.reln.contains("aux")) {
                conj.add(g.dep);
            }
            try {
                if (g.reln.contains("conj")) {
                    splitut2 = g.reln.split("_");
                    conj.add(splitut2[1]);
                }
            }
            catch (ArrayIndexOutOfBoundsException splitut2) {
                // empty catch block
            }
            if (g.reln.equalsIgnoreCase("cc")) {
                conj.add(g.gov);
            }
            if (g.reln.contains("cop")) {
                conj.add(g.gov);
            }
            if (g.dep.contains("when")) {
                conj.add(g.dep);
            }
            try {
                if (g.reln.contains("prep")) {
                    splitut2 = g.reln.split("_");
                    conj.add(splitut2[1]);
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            conj.add("that");
        }
    }

    private static void actorType(Actors act) throws IOException {
        if (act.name.contains("attacker")) {
            act.type = "at";
        } else if (act.name.contains("victim")) {
            act.type = "us";
        } else {
            if (act.isPassive) {
                for (SpecialVerbs sV : act.verbList) {
                    if (!sV.type.equalsIgnoreCase("SV") || !Parser.passiveSubjectVerify(act.name, sV.verb)) continue;
                    act.type = "ot";
                    break;
                }
            }
            if (!act.type.equalsIgnoreCase("ot")) {
                boolean foundNegetive = false;
                for (String string : act.modifiers) {
                    if (!Parser.isNegetive(string, "a").booleanValue()) continue;
                    foundNegetive = true;
                }
                if (foundNegetive) {
                    act.type = "at";
                } else {
                    for (SpecialVerbs specialVerbs : act.verbList) {
                        if (!Parser.isNegetive(specialVerbs.verb, "v").booleanValue()) continue;
                        foundNegetive = true;
                    }
                }
                act.type = foundNegetive ? "at" : (act.name.contains("user") ? "us" : (act.isPassive ? "us" : "ot"));
            }
        }
    }

    private static Boolean isNegetive(String s, String type) throws IOException {
        Boolean isNegetive = false;
        double score = 0.0;
        if (wordnet.exists(s)) {
            String[] stems = Parser.stemmer(s, type);
            try {
                String[] stringArray = stems;
                int n = stems.length;
                int n2 = 0;
                while (n2 < n) {
                    String stemmed = stringArray[n2];
                    double tempScore = 0.0;
                    tempScore = Sentiwordnet.sentiScore(stemmed, type);
                    if (tempScore != 1000.0) {
                        score += tempScore;
                    }
                    ++n2;
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            if (score < 0.0) {
                isNegetive = true;
            }
        }
        return isNegetive;
    }

    public static String[] stemmer(String query, String pos) {
        String[] stems = wordnet.getStems(query, pos);
        return stems;
    }

    private static void returnImportantVerbsforEachActor() {
        Set<String> humanSet = humans.keySet();
        Set<String> passiveSet = passSubj.keySet();
        for (String human : humanSet) {
            Object mD;
            Actors act = new Actors();
            act.name = human;
            if (!passiveSet.contains(human)) {
                ArrayList<String> temp;
                String aux;
                Tree cutOffTree2 = Parser.traverseTreeReturnTree(parse, "NP", human);
                String cutOff = Parser.treeToString(cutOffTree2);
                act.cutOffPart = cutOff.trim();
                Set<String> k1 = subjects.keySet();
                if (k1.contains(human)) {
                    for (SubOb s : subjects.get(human)) {
                        SpecialVerbs sV = new SpecialVerbs();
                        sV.verb = s.verb;
                        aux = Parser.checkForAux(s.verb);
                        if (!aux.isEmpty()) {
                            temp = new ArrayList();
                            temp.add(aux);
                            temp.add(s.verb);
                            sV.VP = Parser.traverseMultiTree(parse, "S", temp);
                        } else {
                            sV.VP = Parser.traverseTreeReturnTree(parse, "S", s.verb);
                        }
                        sV.treeString = Parser.treeToString(sV.VP);
                        sV.VPsize = sV.treeString.length();
                        sV.type = "SV";
                        act.addSpecialVerbs(sV);
                        for (GovDepReln g : allRelations) {
                            if (!g.reln.contains("xcomp") || !verbList.contains(g.dep) || !g.gov.equalsIgnoreCase(s.verb)) continue;
                            SpecialVerbs mD2 = new SpecialVerbs();
                            mD2.verb = g.dep;
                            String aux1 = Parser.checkForAux(g.dep);
                            if (!aux1.isEmpty()) {
                                ArrayList<String> temp1 = new ArrayList<String>();
                                temp1.add(aux1);
                                temp1.add(g.dep);
                                mD2.VP = Parser.traverseMultiTree(parse, "VP", temp1);
                            } else {
                                mD2.VP = Parser.traverseTreeReturnTree(parse, "VP", g.dep);
                            }
                            mD2.treeString = Parser.treeToString(mD2.VP);
                            mD2.VPsize = mD2.treeString.length();
                            mD2.type = "MD";
                            act.addSpecialVerbs(mD2);
                        }
                    }
                }
                for (GovDepReln g : allRelations) {
                    if (!g.reln.contains("vmod") || !verbList.contains(g.dep) || !g.gov.equalsIgnoreCase(human)) continue;
                    mD = new SpecialVerbs();
                    ((SpecialVerbs)mD).verb = g.dep;
                    aux = Parser.checkForAux(g.dep);
                    if (!aux.isEmpty()) {
                        temp = new ArrayList<String>();
                        temp.add(aux);
                        temp.add(g.dep);
                        ((SpecialVerbs)mD).VP = Parser.traverseMultiTree(parse, "VP", temp);
                    } else {
                        ((SpecialVerbs)mD).VP = Parser.traverseTreeReturnTree(parse, "VP", g.dep);
                    }
                    ((SpecialVerbs)mD).treeString = Parser.treeToString(((SpecialVerbs)mD).VP);
                    ((SpecialVerbs)mD).VPsize = ((SpecialVerbs)mD).treeString.length();
                    ((SpecialVerbs)mD).type = "CS";
                    act.addSpecialVerbs((SpecialVerbs)mD);
                }
                Set<String> k2 = objects.keySet();
                if (k2.contains(human)) {
                    for (SubOb subOb : objects.get(human)) {
                        for (GovDepReln g : allRelations) {
                            if (!g.reln.contains("xcomp") || !verbList.contains(g.dep) || !g.gov.equalsIgnoreCase(subOb.verb)) continue;
                            SpecialVerbs mD3 = new SpecialVerbs();
                            mD3.verb = g.dep;
                            String aux2 = Parser.checkForAux(g.dep);
                            if (!aux2.isEmpty()) {
                                ArrayList<String> temp2 = new ArrayList<String>();
                                temp2.add(aux2);
                                temp2.add(g.dep);
                                mD3.VP = Parser.traverseMultiTree(parse, "VP", temp2);
                            } else {
                                mD3.VP = Parser.traverseTreeReturnTree(parse, "VP", g.dep);
                            }
                            mD3.treeString = Parser.treeToString(mD3.VP);
                            mD3.VPsize = mD3.treeString.length();
                            mD3.type = "CO";
                            act.addSpecialVerbs(mD3);
                        }
                    }
                }
                for (GovDepReln govDepReln : allRelations) {
                    boolean contains;
                    boolean bl = contains = govDepReln.reln.contains("advmod") || govDepReln.reln.contains("amod");
                    if (!contains || !govDepReln.gov.equals(human)) continue;
                    act.addModifiers(govDepReln.dep);
                }
            } else {
                act.isPassive = true;
                Set<String> k1 = passSubj.keySet();
                if (k1.contains(human)) {
                    for (SubOb s : passSubj.get(human)) {
                        for (GovDepReln g : allRelations) {
                            if (!g.reln.contains("xcomp") || !verbList.contains(g.dep) || !g.gov.equalsIgnoreCase(s.verb)) continue;
                            mD = new SpecialVerbs();
                            ((SpecialVerbs)mD).verb = g.dep;
                            String aux1 = Parser.checkForAux(g.dep);
                            if (!aux1.isEmpty()) {
                                ArrayList<String> temp1 = new ArrayList<String>();
                                temp1.add(aux1);
                                temp1.add(g.dep);
                                ((SpecialVerbs)mD).VP = Parser.traverseMultiTree(parse, "VP", temp1);
                            } else {
                                ((SpecialVerbs)mD).VP = Parser.traverseTreeReturnTree(parse, "VP", g.dep);
                            }
                            ((SpecialVerbs)mD).treeString = Parser.treeToString(((SpecialVerbs)mD).VP);
                            ((SpecialVerbs)mD).VPsize = ((SpecialVerbs)mD).treeString.length();
                            ((SpecialVerbs)mD).type = "CS";
                            act.addSpecialVerbs((SpecialVerbs)mD);
                        }
                        SpecialVerbs sV = new SpecialVerbs();
                        sV.verb = s.verb;
                        String string = Parser.checkForAux(s.verb);
                        if (!string.isEmpty()) {
                            ArrayList<String> temp = new ArrayList<String>();
                            temp.add(string);
                            temp.add(s.verb);
                            sV.VP = Parser.traverseMultiTree(parse, "S", temp);
                        } else {
                            sV.VP = Parser.traverseTreeReturnTree(parse, "S", s.verb);
                        }
                        sV.treeString = Parser.treeToString(sV.VP);
                        sV.VPsize = sV.treeString.length();
                        sV.type = "SV";
                        act.addSpecialVerbs(sV);
                    }
                }
            }
            act.BubbleSort();
            actorProperties.add(act);
        }
    }

    private static void addMoreModifiers(Actors act) {
        ArrayList<SpecialVerbs> verbList = act.verbList;
        ArrayList<String> objects = new ArrayList<String>();
        ArrayList<String> objectModifiers = new ArrayList<String>();
        for (SpecialVerbs specialVerbs : verbList) {
            for (GovDepReln g : allRelations) {
                if (!g.gov.contains(specialVerbs.verb) || !g.reln.contains("obj")) continue;
                objects.add(g.dep);
            }
        }
        for (String string : objects) {
            for (GovDepReln g : allRelations) {
                if (!g.gov.contains(string) || !g.reln.contains("amod")) continue;
                objectModifiers.add(g.dep);
            }
        }
        for (String string : objectModifiers) {
            act.addModifiers(string);
        }
    }

    private static boolean passiveSubjectVerify(String object, String verb) {
        boolean isLinked = false;
        ArrayList<String> tempVerbs = new ArrayList<String>();
        for (GovDepReln g : allRelations) {
            boolean conditions2;
            boolean conditions1 = g.gov.contains(object) & verbList.contains(g.dep) || g.gov.contains(verb) & verbList.contains(g.dep);
            boolean bl = conditions2 = g.dep.contains(object) & verbList.contains(g.gov) || g.dep.contains(verb) & verbList.contains(g.gov);
            if (conditions1 && !conditions2) {
                if (tempVerbs.contains(g.dep)) continue;
                tempVerbs.add(g.dep);
                continue;
            }
            if (conditions1 || !conditions2 || tempVerbs.contains(g.gov)) continue;
            tempVerbs.add(g.gov);
        }
        Set<String> subj = subjects.keySet();
        int i = 0;
        while (i < tempVerbs.size()) {
            String verbTemp = (String)tempVerbs.get(i);
            boolean done = false;
            for (GovDepReln g : allRelations) {
                if (g.reln.contains("nsubj") || g.reln.contains("agent")) {
                    if (!(g.gov.contains(verbTemp) & subj.contains(g.dep))) continue;
                    done = true;
                    break;
                }
                if (g.reln.contains("vmod")) {
                    if (!(g.dep.contains(verbTemp) & subj.contains(g.gov))) continue;
                    done = true;
                    break;
                }
                boolean conditions1 = g.gov.contains(verbTemp) & verbList.contains(g.dep);
                boolean conditions2 = g.dep.contains(verbTemp) & verbList.contains(g.gov);
                if (conditions1 && !conditions2) {
                    if (tempVerbs.contains(g.dep)) continue;
                    tempVerbs.add(i + 1, g.dep);
                    continue;
                }
                if (conditions1 || !conditions2 || tempVerbs.contains(g.gov)) continue;
                tempVerbs.add(i + 1, g.gov);
            }
            if (done) {
                isLinked = true;
                break;
            }
            ++i;
        }
        return isLinked;
    }

    private static String checkForAux(String verb) {
        String returning = "";
        for (GovDepReln g : allRelations) {
            if (!g.reln.contains("aux") || !g.gov.equalsIgnoreCase(verb)) continue;
            returning = g.dep;
        }
        return returning;
    }

    private static void returnVerbList(String filename) {
        for (List<HasWord> sentence : new DocumentPreprocessor(filename)) {
            parse = lp.apply(sentence);
            List<LabeledWord> labelList = parse.labeledYield();
            for (LabeledWord l : labelList) {
                if (!l.tag().toString().contains("VB") || !wordnet.exists(l.value()) || !wordnet.isVerb(l.value()) || verbList.contains(l.value())) continue;
                verbList.add(l.value());
            }
        }
    }

    private static void allRealtions() {
        PennTreebankLanguagePack tlp = new PennTreebankLanguagePack();
        GrammaticalStructureFactory gsf = tlp.grammaticalStructureFactory();
        GrammaticalStructure gs = gsf.newGrammaticalStructure(parse);
        List<TypedDependency> tdl = gs.typedDependenciesCCprocessed();
        for (TypedDependency depedents : tdl) {
            String govSplit;
            String depSplit;
            GovDepReln g = new GovDepReln();
            g.reln = depedents.reln().toString();
            int locate_depInd = depedents.dep().toOneLineString().lastIndexOf("-");
            g.dep = depSplit = depedents.dep().toOneLineString().substring(0, locate_depInd);
            int locate_govInd = depedents.gov().toOneLineString().lastIndexOf("-");
            g.gov = govSplit = depedents.gov().toOneLineString().substring(0, locate_govInd);
            if (allRelations.contains(g)) continue;
            allRelations.add(g);
        }
    }

    private static void actors() {
        for (GovDepReln g : allRelations) {
            ArrayList<SubOb> newAr;
            SubOb s;
            if (!g.reln.contains("nsubj") && !g.reln.contains("agent") && !g.reln.contains("obj") || !verbList.contains(g.gov)) continue;
            if ((g.reln.contains("nsubj") || g.reln.contains("agent")) && !g.reln.contains("pass")) {
                s = new SubOb();
                s.verb = g.gov;
                s.subOrob = g.dep;
                if (subjects.containsKey(g.dep)) {
                    subjects.get(g.dep).add(s);
                } else {
                    newAr = new ArrayList<SubOb>();
                    newAr.add(s);
                    subjects.put(g.dep, newAr);
                }
            }
            if (g.reln.contains("obj")) {
                s = new SubOb();
                s.verb = g.gov;
                s.subOrob = g.dep;
                if (objects.containsKey(g.dep)) {
                    objects.get(g.dep).add(s);
                } else {
                    newAr = new ArrayList();
                    newAr.add(s);
                    objects.put(g.dep, newAr);
                }
            }
            try {
                ArrayList<SubOb> newAr2;
                SubOb s2;
                String outs = wordnet.getGloss(g.dep, "n");
                if (outs != null && (outs.contains("someone") || outs.contains("who") || outs.contains("human"))) {
                    s2 = new SubOb();
                    s2.verb = g.gov;
                    s2.subOrob = g.dep;
                    if (!Character.isUpperCase(g.dep.charAt(0))) {
                        if (humans.containsKey(g.dep)) {
                            humans.get(g.dep).add(s2);
                        } else {
                            newAr2 = new ArrayList();
                            newAr2.add(s2);
                            humans.put(g.dep, newAr2);
                        }
                    }
                }
                if (!g.reln.contains("pass")) continue;
                s2 = new SubOb();
                s2.verb = g.gov;
                s2.subOrob = g.dep;
                if (passSubj.containsKey(g.dep)) {
                    passSubj.get(g.dep).add(s2);
                } else {
                    newAr2 = new ArrayList<SubOb>();
                    newAr2.add(s2);
                    passSubj.put(g.dep, newAr2);
                }
                if (humans.containsKey(g.dep)) {
                    humans.get(g.dep).add(s2);
                    continue;
                }
                newAr2 = new ArrayList();
                newAr2.add(s2);
                humans.put(g.dep, newAr2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void subjectRemove() {
        Set<String> human = humans.keySet();
        Set<String> subj = subjects.keySet();
        ArrayList<String> toRemove = new ArrayList<String>();
        for (String hum : human) {
            if (!subj.contains(hum)) continue;
            toRemove.add(hum);
        }
        for (String s : toRemove) {
            subjects.remove(s);
        }
    }

    private static String treeToString(Tree tree) {
        String StringVersion = "";
        try {
            List<LabeledWord> finalSubList = tree.labeledYield();
            for (LabeledWord l : finalSubList) {
                StringVersion = String.valueOf(StringVersion) + " " + l.value().trim();
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return StringVersion;
    }

    private static Tree traverseMultiTree(Tree toBeTraversed, String tagToBeMatched, ArrayList<String> valueToBeMatched) {
        Tree thisChild = toBeTraversed;
        Tree finalSubSentence = null;
        do {
            int totalChildrern = thisChild.numChildren();
            boolean added = false;
            int i = 0;
            while (i < totalChildrern) {
                Tree child = thisChild.getChild(i);
                ArrayList<Word> words = child.yieldWords();
                boolean result = true;
                for (String su : valueToBeMatched) {
                    int count = 0;
                    for (Word w : words) {
                        if (!w.value().equals(su)) continue;
                        ++count;
                    }
                    if (count > 0) {
                        result &= true;
                        continue;
                    }
                    result &= false;
                    break;
                }
                if (result) {
                    if (child.label().toString().equals(tagToBeMatched)) {
                        finalSubSentence = child;
                    }
                    thisChild = child;
                    added = true;
                    break;
                }
                ++i;
            }
            if (!added) break;
            added = false;
        } while (!thisChild.isLeaf());
        return finalSubSentence;
    }

    private static Tree traverseTreeReturnTree(Tree toBeTraversed, String tagToBeMatched, String valueToBeMatched) {
        Tree thisChild = toBeTraversed;
        Tree finalSubSentence = null;
        do {
            int totalChildrern = thisChild.numChildren();
            boolean added = false;
            int i = 0;
            while (i < totalChildrern) {
                Tree child = thisChild.getChild(i);
                ArrayList<Word> words = child.yieldWords();
                for (Word w : words) {
                    if (!w.value().equals(valueToBeMatched)) continue;
                    if (child.label().toString().equals(tagToBeMatched)) {
                        finalSubSentence = child;
                    }
                    thisChild = child;
                    added = true;
                    break;
                }
                if (added) break;
                ++i;
            }
            if (!added) break;
            added = false;
        } while (!thisChild.isLeaf());
        return finalSubSentence;
    }

    private static void readFromFileAB(String input_filename) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(new FileReader(input_filename));
        while ((line = br.readLine()) != null) {
            passage = String.valueOf(passage) + line;
        }
        br.close();
    }
}

