/*
 * Decompiled with CFR 0.152.
 */
package AutoExtractor;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class Sentiwordnet {
    private Map<String, Double> dictionary = new HashMap<String, Double>();

    public Sentiwordnet(String pathToSWN) throws IOException {
        HashMap tempDictionary = new HashMap();
        try (BufferedReader csv = null;){
            try {
                String line;
                csv = new BufferedReader(new FileReader(pathToSWN));
                int lineNumber = 0;
                while ((line = csv.readLine()) != null) {
                    String[] synTermsSplit;
                    ++lineNumber;
                    if (line.trim().startsWith("#")) continue;
                    String[] data = line.split("\t");
                    String wordTypeMarker = data[0];
                    if (data.length != 6) {
                        throw new IllegalArgumentException("Incorrect tabulation format in file, line: " + lineNumber);
                    }
                    Double synsetScore = Double.parseDouble(data[2]) - Double.parseDouble(data[3]);
                    String[] stringArray = synTermsSplit = data[4].split(" ");
                    int n = synTermsSplit.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String synTermSplit = stringArray[n2];
                        String[] synTermAndRank = synTermSplit.split("#");
                        String synTerm = String.valueOf(synTermAndRank[0]) + "#" + wordTypeMarker;
                        int synTermRank = Integer.parseInt(synTermAndRank[1]);
                        if (!tempDictionary.containsKey(synTerm)) {
                            tempDictionary.put(synTerm, new HashMap());
                        }
                        ((HashMap)tempDictionary.get(synTerm)).put(synTermRank, synsetScore);
                        ++n2;
                    }
                }
                for (Map.Entry entry : tempDictionary.entrySet()) {
                    String word = (String)entry.getKey();
                    Map synSetScoreMap = (Map)entry.getValue();
                    double score = 0.0;
                    double sum = 0.0;
                    for (Map.Entry setScore : synSetScoreMap.entrySet()) {
                        score += (Double)setScore.getValue() / (double)((Integer)setScore.getKey()).intValue();
                        sum += 1.0 / (double)((Integer)setScore.getKey()).intValue();
                    }
                    this.dictionary.put(word, score /= sum);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (csv != null) {
                    csv.close();
                }
            }
        }
    }

    public double extract(String word, String pos) {
        return this.dictionary.get(String.valueOf(word) + "#" + pos);
    }

    public static double sentiScore(String what, String pos) throws IOException {
        String pathToSWN = "SentiWordNet_3.0.0_20130122.txt";
        Sentiwordnet sentiwordnet = new Sentiwordnet(pathToSWN);
        try {
            return sentiwordnet.extract(what, pos);
        }
        catch (NullPointerException n) {
            return 1000.0;
        }
    }
}

