/*
 * Decompiled with CFR 0.152.
 */
package LBJ2.classify;

import LBJ2.classify.Classifier;
import LBJ2.classify.DiscreteFeature;
import LBJ2.classify.Feature;
import LBJ2.classify.RealConjunctiveFeature;
import LBJ2.classify.RealFeature;
import LBJ2.learn.ChildLexicon;
import LBJ2.learn.Lexicon;
import LBJ2.util.ByteString;
import LBJ2.util.ExceptionlessInputStream;
import LBJ2.util.ExceptionlessOutputStream;

public class DiscreteConjunctiveFeature
extends DiscreteFeature {
    protected DiscreteFeature left;
    protected DiscreteFeature right;

    public DiscreteConjunctiveFeature() {
    }

    public DiscreteConjunctiveFeature(String string, String string2, DiscreteFeature discreteFeature, DiscreteFeature discreteFeature2) {
        this(string, string2, discreteFeature, discreteFeature2, -1, 0);
    }

    public DiscreteConjunctiveFeature(String string, String string2, DiscreteFeature discreteFeature, DiscreteFeature discreteFeature2, short s, short s2) {
        super(string, string2, s, s2);
        this.left = discreteFeature;
        this.right = discreteFeature2;
    }

    public DiscreteConjunctiveFeature(Classifier classifier, DiscreteFeature discreteFeature, DiscreteFeature discreteFeature2) {
        this(classifier.containingPackage, classifier.name, discreteFeature, discreteFeature2);
        if (classifier.allowableValues().length == 0) {
            this.valueIndex = (short)-1;
        } else {
            short s = discreteFeature.totalValues();
            this.valueIndex = (short)(s * discreteFeature2.getValueIndex() + discreteFeature.getValueIndex());
            this.totalValues = (short)(s * discreteFeature2.totalValues());
        }
    }

    public boolean isConjunctive() {
        return true;
    }

    public DiscreteFeature getLeft() {
        return this.left;
    }

    public DiscreteFeature getRight() {
        return this.right;
    }

    public String getStringIdentifier() {
        return "";
    }

    public ByteString getByteStringIdentifier() {
        return ByteString.emptyString;
    }

    public String getStringValue() {
        return this.left.getStringValue() + this.right.getStringValue();
    }

    public ByteString getByteStringValue() {
        ByteString byteString = this.left.getByteStringValue();
        ByteString[] byteStringArray = new ByteString[]{new ByteString("&", byteString.getEncoding()), this.right.getByteStringValue()};
        return byteString.append(byteStringArray);
    }

    public int depth() {
        return Math.max(this.left.depth(), this.right.depth()) + 1;
    }

    public boolean valueEquals(String string) {
        return this.getStringValue().equals(string);
    }

    public double getStrength() {
        return 1.0;
    }

    public Feature getFeatureKey(Lexicon lexicon, boolean bl, int n) {
        if (!bl) {
            return this;
        }
        return new DiscreteConjunctiveFeature(this.containingPackage, this.generatingClassifier, this.getArgumentKey(this.left, lexicon, n), this.getArgumentKey(this.right, lexicon, n), this.valueIndex, this.totalValues);
    }

    protected DiscreteFeature getArgumentKey(Feature feature, Lexicon lexicon, int n) {
        if (!feature.isPrimitive()) {
            feature = feature.getFeatureKey(lexicon, true, n);
        }
        return (DiscreteFeature)lexicon.getChildFeature(feature, n);
    }

    public RealFeature makeReal() {
        return new RealConjunctiveFeature(this.containingPackage, this.generatingClassifier, this.left, this.right);
    }

    public Feature withStrength(double d) {
        return d == 1.0 ? this : null;
    }

    public Feature encode(String string) {
        DiscreteFeature discreteFeature = (DiscreteFeature)this.left.encode(string);
        DiscreteFeature discreteFeature2 = (DiscreteFeature)this.right.encode(string);
        if (discreteFeature == this.left && discreteFeature2 == this.right) {
            return this;
        }
        return new DiscreteConjunctiveFeature(this.containingPackage, this.generatingClassifier, discreteFeature, discreteFeature2, this.valueIndex, this.totalValues);
    }

    public void removeFromChildLexicon(ChildLexicon childLexicon) {
        childLexicon.decrementParentCounts(this.left);
        childLexicon.decrementParentCounts(this.right);
    }

    public int childLexiconLookup(ChildLexicon childLexicon, int n) {
        return childLexicon.childLexiconLookup(this, n);
    }

    public int hashCode() {
        return 31 * super.hashCode() + 17 * this.left.hashCode() + this.right.hashCode();
    }

    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        DiscreteConjunctiveFeature discreteConjunctiveFeature = (DiscreteConjunctiveFeature)object;
        return !(this.left != discreteConjunctiveFeature.left && !this.left.equals(discreteConjunctiveFeature.left) || this.right != discreteConjunctiveFeature.right && !this.right.equals(discreteConjunctiveFeature.right));
    }

    public int compareTo(Object object) {
        int n = this.compareNameStrings(object);
        if (n != 0) {
            return n;
        }
        DiscreteConjunctiveFeature discreteConjunctiveFeature = (DiscreteConjunctiveFeature)object;
        n = this.left.compareTo(discreteConjunctiveFeature.left);
        if (n != 0) {
            return n;
        }
        return this.right.compareTo(discreteConjunctiveFeature.right);
    }

    public void write(StringBuffer stringBuffer) {
        this.writeNameString(stringBuffer);
        stringBuffer.append('{');
        this.left.write(stringBuffer);
        stringBuffer.append(", ");
        this.right.write(stringBuffer);
        stringBuffer.append('}');
    }

    public void writeNoPackage(StringBuffer stringBuffer) {
        String string = this.containingPackage;
        this.containingPackage = null;
        this.writeNameString(stringBuffer);
        stringBuffer.append('{');
        this.left.writeNoPackage(stringBuffer);
        stringBuffer.append(", ");
        this.right.writeNoPackage(stringBuffer);
        stringBuffer.append('}');
        this.containingPackage = string;
    }

    public void write(ExceptionlessOutputStream exceptionlessOutputStream) {
        super.write(exceptionlessOutputStream);
        this.left.write(exceptionlessOutputStream);
        this.right.write(exceptionlessOutputStream);
    }

    public void read(ExceptionlessInputStream exceptionlessInputStream) {
        super.read(exceptionlessInputStream);
        this.left = (DiscreteFeature)Feature.readFeature(exceptionlessInputStream);
        this.right = (DiscreteFeature)Feature.readFeature(exceptionlessInputStream);
    }

    public String lexWrite(ExceptionlessOutputStream exceptionlessOutputStream, Lexicon lexicon, String string, String string2, String string3, String string4, ByteString byteString) {
        String string5 = super.lexWrite(exceptionlessOutputStream, lexicon, string, string2, string3, string4, byteString);
        exceptionlessOutputStream.writeInt(lexicon.lookupChild(this.left));
        exceptionlessOutputStream.writeInt(lexicon.lookupChild(this.right));
        return string5;
    }

    public void lexRead(ExceptionlessInputStream exceptionlessInputStream, Lexicon lexicon, String string, String string2, String string3, ByteString byteString) {
        super.lexRead(exceptionlessInputStream, lexicon, string, string2, string3, byteString);
        this.left = (DiscreteFeature)lexicon.lookupKey(exceptionlessInputStream.readInt());
        this.right = (DiscreteFeature)lexicon.lookupKey(exceptionlessInputStream.readInt());
    }
}

