/*
 * Decompiled with CFR 0.152.
 */
package LBJ2.classify;

import LBJ2.classify.DiscreteFeature;
import LBJ2.classify.DiscretePrimitiveFeature;
import LBJ2.classify.Feature;
import LBJ2.classify.RealFeature;
import LBJ2.classify.RealPrimitiveStringFeature;
import LBJ2.learn.Lexicon;
import LBJ2.util.ByteString;
import LBJ2.util.ExceptionlessInputStream;
import LBJ2.util.ExceptionlessOutputStream;

public class DiscretePrimitiveStringFeature
extends DiscreteFeature {
    protected String identifier;
    protected String value;

    protected DiscretePrimitiveStringFeature() {
    }

    public DiscretePrimitiveStringFeature(String string, String string2, String string3, String string4) {
        this(string, string2, string3, string4, -1, 0);
    }

    public DiscretePrimitiveStringFeature(String string, String string2, String string3, String string4, short s, short s2) {
        super(string, string2, s, s2);
        this.identifier = string3;
        this.value = string4;
    }

    public boolean hasStringIdentifier() {
        return true;
    }

    public boolean isPrimitive() {
        return true;
    }

    public String getStringIdentifier() {
        return this.identifier;
    }

    public ByteString getByteStringIdentifier() {
        return new ByteString(this.identifier);
    }

    public String getStringValue() {
        return this.value;
    }

    public ByteString getByteStringValue() {
        return new ByteString(this.value);
    }

    public boolean valueEquals(String string) {
        return string.equals(this.value);
    }

    public Feature getFeatureKey(Lexicon lexicon, boolean bl, int n) {
        if (this.totalValues() == 2) {
            return new DiscretePrimitiveStringFeature(this.containingPackage, this.generatingClassifier, this.identifier, "", -1, 2);
        }
        return this;
    }

    public RealFeature makeReal() {
        if (this.totalValues == 2) {
            return new RealPrimitiveStringFeature(this.containingPackage, this.generatingClassifier, this.identifier, this.valueIndex);
        }
        StringBuffer stringBuffer = new StringBuffer(this.identifier);
        stringBuffer.append('_');
        stringBuffer.append(this.value);
        return new RealPrimitiveStringFeature(this.containingPackage, this.generatingClassifier, stringBuffer.toString(), 1.0);
    }

    public Feature withStrength(double d) {
        if (this.totalValues != 2 || d != 0.0 && d != 1.0) {
            return null;
        }
        return new DiscretePrimitiveStringFeature(this.containingPackage, this.generatingClassifier, this.identifier, "", (short)Math.round(d), 2);
    }

    public Feature encode(String string) {
        if (string == null || string == "String") {
            return this;
        }
        ByteString byteString = this.identifier.length() == 0 ? ByteString.emptyString : new ByteString(this.identifier, string);
        return new DiscretePrimitiveFeature(this.containingPackage, this.generatingClassifier, byteString, new ByteString(this.value, string), this.valueIndex, this.totalValues);
    }

    public int hashCode() {
        return 31 * super.hashCode() + 17 * this.identifier.hashCode() + this.value.hashCode();
    }

    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        if (object instanceof DiscretePrimitiveStringFeature) {
            DiscretePrimitiveStringFeature discretePrimitiveStringFeature = (DiscretePrimitiveStringFeature)object;
            return this.identifier.equals(discretePrimitiveStringFeature.identifier) && this.valueIndex > -1 ? this.valueIndex == discretePrimitiveStringFeature.valueIndex : this.value.equals(discretePrimitiveStringFeature.value);
        }
        DiscretePrimitiveFeature discretePrimitiveFeature = (DiscretePrimitiveFeature)object;
        return discretePrimitiveFeature.identifier.equals(this.identifier) && this.valueIndex > -1 ? this.valueIndex == discretePrimitiveFeature.valueIndex : discretePrimitiveFeature.value.equals(this.value);
    }

    public boolean classEquivalent(Feature feature) {
        return feature instanceof DiscretePrimitiveFeature;
    }

    public int compareTo(Object object) {
        int n = this.compareNameStrings(object);
        if (n != 0) {
            return n;
        }
        DiscretePrimitiveStringFeature discretePrimitiveStringFeature = (DiscretePrimitiveStringFeature)object;
        n = this.identifier.compareTo(discretePrimitiveStringFeature.identifier);
        if (n != 0) {
            return n;
        }
        return this.value.compareTo(discretePrimitiveStringFeature.value);
    }

    public void write(StringBuffer stringBuffer) {
        this.writeNameString(stringBuffer);
        stringBuffer.append("(");
        stringBuffer.append(this.value);
        stringBuffer.append(")");
    }

    public void writeNameString(StringBuffer stringBuffer) {
        super.writeNameString(stringBuffer);
        stringBuffer.append(":");
        stringBuffer.append(this.identifier);
    }

    public void write(ExceptionlessOutputStream exceptionlessOutputStream) {
        super.write(exceptionlessOutputStream);
        exceptionlessOutputStream.writeString(this.identifier);
        exceptionlessOutputStream.writeString(this.value);
    }

    public void read(ExceptionlessInputStream exceptionlessInputStream) {
        super.read(exceptionlessInputStream);
        this.identifier = exceptionlessInputStream.readString();
        this.value = exceptionlessInputStream.readString();
    }

    public String lexWrite(ExceptionlessOutputStream exceptionlessOutputStream, Lexicon lexicon, String string, String string2, String string3, String string4, ByteString byteString) {
        String string5 = super.lexWrite(exceptionlessOutputStream, lexicon, string, string2, string3, string4, byteString);
        exceptionlessOutputStream.writeString(this.identifier.equals(string4) ? null : this.identifier);
        exceptionlessOutputStream.writeString(this.value);
        return string5;
    }

    public void lexRead(ExceptionlessInputStream exceptionlessInputStream, Lexicon lexicon, String string, String string2, String string3, ByteString byteString) {
        super.lexRead(exceptionlessInputStream, lexicon, string, string2, string3, byteString);
        this.identifier = exceptionlessInputStream.readString();
        if (this.identifier == null) {
            this.identifier = string3;
        }
        this.value = exceptionlessInputStream.readString();
    }
}

