/*
 * Decompiled with CFR 0.152.
 */
package LBJ2.classify;

import LBJ2.classify.Classifier;
import LBJ2.classify.DiscreteFeature;
import LBJ2.classify.DiscreteReferrer;
import LBJ2.classify.DiscreteReferringStringFeature;
import LBJ2.classify.Feature;
import LBJ2.classify.RealFeature;
import LBJ2.classify.RealReferringFeature;
import LBJ2.learn.Lexicon;
import LBJ2.util.ByteString;
import LBJ2.util.ExceptionlessInputStream;
import LBJ2.util.ExceptionlessOutputStream;

public class DiscreteReferringFeature
extends DiscreteReferrer {
    protected ByteString identifier;

    protected DiscreteReferringFeature() {
    }

    public DiscreteReferringFeature(Classifier classifier, ByteString byteString, DiscreteFeature discreteFeature) {
        this(classifier.containingPackage, classifier.name, byteString, discreteFeature, discreteFeature.getValueIndex(), discreteFeature.totalValues());
    }

    public DiscreteReferringFeature(Classifier classifier, ByteString byteString, DiscreteFeature discreteFeature, String[] stringArray) {
        super(classifier, discreteFeature, stringArray);
        this.identifier = byteString;
    }

    public DiscreteReferringFeature(String string, String string2, ByteString byteString, DiscreteFeature discreteFeature, short s, short s2) {
        super(string, string2, discreteFeature, s, s2);
        this.identifier = byteString;
    }

    public boolean hasByteStringIdentifier() {
        return true;
    }

    public String getStringIdentifier() {
        return this.identifier.toString();
    }

    public ByteString getByteStringIdentifier() {
        return (ByteString)this.identifier.clone();
    }

    public Feature getFeatureKey(Lexicon lexicon, boolean bl, int n) {
        DiscreteFeature discreteFeature = (DiscreteFeature)this.referent.getFeatureKey(lexicon, bl, n);
        if (bl) {
            discreteFeature = (DiscreteFeature)lexicon.getChildFeature(discreteFeature, n);
        } else if (discreteFeature == this.referent) {
            return this;
        }
        return new DiscreteReferringFeature(this.containingPackage, this.generatingClassifier, this.identifier, discreteFeature, this.valueIndex, this.totalValues);
    }

    public RealFeature makeReal() {
        return new RealReferringFeature(this.containingPackage, this.generatingClassifier, this.identifier, this.referent.makeReal());
    }

    public double getStrength() {
        return this.referent.getStrength();
    }

    public Feature withStrength(double d) {
        DiscreteFeature discreteFeature = (DiscreteFeature)this.referent.withStrength(d);
        if (discreteFeature == null) {
            return null;
        }
        return new DiscreteReferringFeature(this.containingPackage, this.generatingClassifier, this.identifier, discreteFeature, (short)Math.round(discreteFeature.getStrength()), this.totalValues);
    }

    public Feature encode(String string) {
        DiscreteFeature discreteFeature = (DiscreteFeature)this.referent.encode(string);
        if (discreteFeature == this.referent) {
            return this;
        }
        return new DiscreteReferringFeature(this.containingPackage, this.generatingClassifier, this.identifier, discreteFeature, this.valueIndex, this.totalValues);
    }

    public int hashCode() {
        return 17 * super.hashCode() + this.identifier.hashCode();
    }

    public boolean equals(Object object) {
        return super.equals(object) && (object instanceof DiscreteReferringStringFeature ? this.identifier.equals(((DiscreteReferringStringFeature)object).identifier) : this.identifier.equals(((DiscreteReferringFeature)object).identifier)) && this.referent.equals(((DiscreteReferrer)object).referent);
    }

    public boolean classEquivalent(Feature feature) {
        return feature instanceof DiscreteReferringStringFeature;
    }

    public int compareNameStrings(Object object) {
        int n = super.compareNameStrings(object);
        if (n != 0) {
            return n;
        }
        return this.identifier.compareTo(((DiscreteReferringFeature)object).identifier);
    }

    public void writeNameString(StringBuffer stringBuffer) {
        super.writeNameString(stringBuffer);
        stringBuffer.append(":");
        stringBuffer.append(this.identifier.toString());
    }

    public void write(ExceptionlessOutputStream exceptionlessOutputStream) {
        super.write(exceptionlessOutputStream);
        this.identifier.write(exceptionlessOutputStream);
    }

    public void read(ExceptionlessInputStream exceptionlessInputStream) {
        super.read(exceptionlessInputStream);
        this.identifier = ByteString.readByteString(exceptionlessInputStream);
    }

    public String lexWrite(ExceptionlessOutputStream exceptionlessOutputStream, Lexicon lexicon, String string, String string2, String string3, String string4, ByteString byteString) {
        String string5 = super.lexWrite(exceptionlessOutputStream, lexicon, string, string2, string3, string4, byteString);
        this.identifier.lexWrite(exceptionlessOutputStream, byteString);
        return string5;
    }

    public void lexRead(ExceptionlessInputStream exceptionlessInputStream, Lexicon lexicon, String string, String string2, String string3, ByteString byteString) {
        super.lexRead(exceptionlessInputStream, lexicon, string, string2, string3, byteString);
        this.identifier = ByteString.lexReadByteString(exceptionlessInputStream, byteString);
    }
}

