/*
 * Decompiled with CFR 0.152.
 */
package LBJ2.classify;

import LBJ2.classify.Classifier;
import LBJ2.classify.DiscreteFeature;
import LBJ2.classify.DiscreteReferrer;
import LBJ2.classify.DiscreteReferringFeature;
import LBJ2.classify.Feature;
import LBJ2.classify.RealFeature;
import LBJ2.classify.RealReferringStringFeature;
import LBJ2.learn.Lexicon;
import LBJ2.util.ByteString;
import LBJ2.util.ExceptionlessInputStream;
import LBJ2.util.ExceptionlessOutputStream;

public class DiscreteReferringStringFeature
extends DiscreteReferrer {
    protected String identifier;

    protected DiscreteReferringStringFeature() {
    }

    public DiscreteReferringStringFeature(Classifier classifier, String string, DiscreteFeature discreteFeature) {
        this(classifier.containingPackage, classifier.name, string, discreteFeature, discreteFeature.getValueIndex(), discreteFeature.totalValues());
    }

    public DiscreteReferringStringFeature(Classifier classifier, String string, DiscreteFeature discreteFeature, String[] stringArray) {
        super(classifier, discreteFeature, stringArray);
        this.identifier = string;
    }

    public DiscreteReferringStringFeature(String string, String string2, String string3, DiscreteFeature discreteFeature, short s, short s2) {
        super(string, string2, discreteFeature, s, s2);
        this.identifier = string3;
    }

    public boolean hasStringIdentifier() {
        return true;
    }

    public String getStringIdentifier() {
        return this.identifier;
    }

    public ByteString getByteStringIdentifier() {
        return new ByteString(this.identifier);
    }

    public Feature getFeatureKey(Lexicon lexicon, boolean bl, int n) {
        DiscreteFeature discreteFeature = (DiscreteFeature)this.referent.getFeatureKey(lexicon, bl, n);
        if (bl) {
            discreteFeature = (DiscreteFeature)lexicon.getChildFeature(discreteFeature, n);
        } else if (discreteFeature == this.referent) {
            return this;
        }
        return new DiscreteReferringStringFeature(this.containingPackage, this.generatingClassifier, this.identifier, discreteFeature, this.valueIndex, this.totalValues);
    }

    public RealFeature makeReal() {
        return new RealReferringStringFeature(this.containingPackage, this.generatingClassifier, this.identifier, this.referent.makeReal());
    }

    public double getStrength() {
        return this.referent.getStrength();
    }

    public Feature withStrength(double d) {
        DiscreteFeature discreteFeature = (DiscreteFeature)this.referent.withStrength(d);
        if (discreteFeature == null) {
            return null;
        }
        return new DiscreteReferringStringFeature(this.containingPackage, this.generatingClassifier, this.identifier, discreteFeature, (short)Math.round(discreteFeature.getStrength()), this.totalValues);
    }

    public Feature encode(String string) {
        DiscreteFeature discreteFeature = (DiscreteFeature)this.referent.encode(string);
        if (this.referent == discreteFeature && (string == null || string == "String")) {
            return this;
        }
        ByteString byteString = this.identifier.length() == 0 ? ByteString.emptyString : new ByteString(this.identifier, string);
        return new DiscreteReferringFeature(this.containingPackage, this.generatingClassifier, byteString, discreteFeature, this.valueIndex, this.totalValues);
    }

    public int hashCode() {
        return 17 * super.hashCode() + this.identifier.hashCode();
    }

    public boolean equals(Object object) {
        return super.equals(object) && (object instanceof DiscreteReferringStringFeature ? this.identifier.equals(((DiscreteReferringStringFeature)object).identifier) : this.identifier.equals(((DiscreteReferringFeature)object).identifier)) && this.referent.equals(((DiscreteReferrer)object).referent);
    }

    public boolean classEquivalent(Feature feature) {
        return feature instanceof DiscreteReferringFeature;
    }

    public int compareNameStrings(Object object) {
        int n = super.compareNameStrings(object);
        if (n != 0) {
            return n;
        }
        return this.identifier.compareTo(((DiscreteReferringStringFeature)object).identifier);
    }

    public void writeNameString(StringBuffer stringBuffer) {
        super.writeNameString(stringBuffer);
        stringBuffer.append(":");
        stringBuffer.append(this.identifier);
    }

    public void write(ExceptionlessOutputStream exceptionlessOutputStream) {
        super.write(exceptionlessOutputStream);
        exceptionlessOutputStream.writeString(this.identifier);
    }

    public void read(ExceptionlessInputStream exceptionlessInputStream) {
        super.read(exceptionlessInputStream);
        this.identifier = exceptionlessInputStream.readString();
    }

    public String lexWrite(ExceptionlessOutputStream exceptionlessOutputStream, Lexicon lexicon, String string, String string2, String string3, String string4, ByteString byteString) {
        String string5 = super.lexWrite(exceptionlessOutputStream, lexicon, string, string2, string3, string4, byteString);
        exceptionlessOutputStream.writeString(this.identifier.equals(string4) ? null : this.identifier);
        return string5;
    }

    public void lexRead(ExceptionlessInputStream exceptionlessInputStream, Lexicon lexicon, String string, String string2, String string3, ByteString byteString) {
        super.lexRead(exceptionlessInputStream, lexicon, string, string2, string3, byteString);
        this.identifier = exceptionlessInputStream.readString();
        if (this.identifier == null) {
            this.identifier = string3;
        }
    }
}

