/*
 * Decompiled with CFR 0.152.
 */
package LBJ2.infer;

import LBJ2.infer.Inference;
import LBJ2.infer.PropositionalAtLeast;
import LBJ2.infer.PropositionalBinaryConstraint;
import LBJ2.infer.PropositionalConjunction;
import LBJ2.infer.PropositionalConstant;
import LBJ2.infer.PropositionalConstraint;
import LBJ2.infer.PropositionalDisjunction;
import LBJ2.infer.PropositionalImplication;
import LBJ2.infer.PropositionalNegation;
import LBJ2.infer.PropositionalVariable;

public class PropositionalDoubleImplication
extends PropositionalBinaryConstraint {
    public PropositionalDoubleImplication(PropositionalConstraint propositionalConstraint, PropositionalConstraint propositionalConstraint2) {
        super(propositionalConstraint, propositionalConstraint2);
    }

    public boolean evaluate() {
        return this.left.evaluate() == this.right.evaluate();
    }

    public PropositionalConstraint simplify() {
        return new PropositionalConjunction(new PropositionalDisjunction(this.left.negate(), this.right), new PropositionalDisjunction(this.right.negate(), this.left)).simplify();
    }

    public PropositionalConstraint negate() {
        return new PropositionalConjunction(new PropositionalDisjunction(this.left.negate(), this.right.negate()), new PropositionalDisjunction(this.left, this.right));
    }

    public PropositionalConstraint CNF() {
        return new PropositionalConjunction(new PropositionalDisjunction(new PropositionalNegation(this.left), this.right), new PropositionalDisjunction(new PropositionalNegation(this.right), this.left)).CNF();
    }

    public PropositionalConstraint DNF() {
        return new PropositionalDisjunction(new PropositionalConjunction(this.left, this.right), new PropositionalConjunction(new PropositionalNegation(this.left), new PropositionalNegation(this.right))).DNF();
    }

    public boolean moreGeneralThan(PropositionalConstraint propositionalConstraint) {
        return propositionalConstraint.moreSpecificThan(this);
    }

    public boolean moreSpecificThan(PropositionalImplication propositionalImplication) {
        PropositionalConstraint[] propositionalConstraintArray = (PropositionalConstraint[])propositionalImplication.getChildren();
        return this.left.equals(propositionalConstraintArray[0]) && this.right.equals(propositionalConstraintArray[1]) || this.left.equals(propositionalConstraintArray[1]) && this.right.equals(propositionalConstraintArray[0]);
    }

    public boolean moreSpecificThan(PropositionalDoubleImplication propositionalDoubleImplication) {
        return false;
    }

    public boolean moreSpecificThan(PropositionalConjunction propositionalConjunction) {
        return false;
    }

    public boolean moreSpecificThan(PropositionalDisjunction propositionalDisjunction) {
        PropositionalConstraint[] propositionalConstraintArray = (PropositionalConstraint[])propositionalDisjunction.getChildren();
        return propositionalConstraintArray.length == 2 && (new PropositionalNegation(this.left).equals(propositionalConstraintArray[0]) && this.right.equals(propositionalConstraintArray[1]) || new PropositionalNegation(this.left).equals(propositionalConstraintArray[1]) && this.right.equals(propositionalConstraintArray[0]) || this.left.equals(propositionalConstraintArray[0]) && new PropositionalNegation(this.right).equals(propositionalConstraintArray[1]) || this.left.equals(propositionalConstraintArray[1]) && new PropositionalNegation(this.right).equals(propositionalConstraintArray[0]));
    }

    public boolean moreSpecificThan(PropositionalAtLeast propositionalAtLeast) {
        return false;
    }

    public boolean moreSpecificThan(PropositionalNegation propositionalNegation) {
        return false;
    }

    public boolean moreSpecificThan(PropositionalVariable propositionalVariable) {
        return false;
    }

    public boolean moreSpecificThan(PropositionalConstant propositionalConstant) {
        return propositionalConstant.evaluate();
    }

    public int hashCode() {
        return this.left.hashCode() + this.right.hashCode() + 3;
    }

    public boolean equals(Object object) {
        if (!(object instanceof PropositionalDoubleImplication)) {
            return false;
        }
        PropositionalDoubleImplication propositionalDoubleImplication = (PropositionalDoubleImplication)object;
        return this.left.equals(propositionalDoubleImplication.left) && this.right.equals(propositionalDoubleImplication.right) || this.left.equals(propositionalDoubleImplication.right) && this.right.equals(propositionalDoubleImplication.left);
    }

    public void runVisit(Inference inference) {
        inference.visit(this);
    }

    public void write(StringBuffer stringBuffer) {
        stringBuffer.append("(");
        this.left.write(stringBuffer);
        stringBuffer.append(" <=> ");
        this.right.write(stringBuffer);
        stringBuffer.append(")");
    }
}

