/*
 * Decompiled with CFR 0.152.
 */
package LBJ2.infer;

import LBJ2.infer.Constraint;
import LBJ2.infer.Inference;
import LBJ2.infer.PropositionalAtLeast;
import LBJ2.infer.PropositionalConjunction;
import LBJ2.infer.PropositionalConstant;
import LBJ2.infer.PropositionalConstraint;
import LBJ2.infer.PropositionalDisjunction;
import LBJ2.infer.PropositionalDoubleImplication;
import LBJ2.infer.PropositionalImplication;
import LBJ2.infer.PropositionalNegation;
import LBJ2.learn.Learner;
import java.util.AbstractMap;

public class PropositionalVariable
extends PropositionalConstraint {
    protected Learner classifier;
    protected Object example;
    protected String prediction;
    public boolean value;

    public PropositionalVariable(Learner learner, Object object, String string) {
        this.classifier = learner;
        this.example = object;
        this.prediction = string;
        this.value = false;
    }

    public void consolidateVariables(AbstractMap abstractMap) {
    }

    public Learner getClassifier() {
        return this.classifier;
    }

    public Object getExample() {
        return this.example;
    }

    public String getPrediction() {
        return this.prediction;
    }

    public boolean evaluate() {
        return this.value;
    }

    public PropositionalConstraint simplify() {
        return this;
    }

    public PropositionalConstraint negate() {
        return new PropositionalNegation(this);
    }

    public PropositionalConstraint CNF() {
        return this;
    }

    public PropositionalConstraint DNF() {
        return this;
    }

    public Constraint[] getChildren() {
        return new PropositionalConstraint[0];
    }

    public boolean moreGeneralThan(PropositionalConstraint propositionalConstraint) {
        return propositionalConstraint.moreSpecificThan(this);
    }

    public boolean moreSpecificThan(PropositionalImplication propositionalImplication) {
        PropositionalConstraint[] propositionalConstraintArray = (PropositionalConstraint[])propositionalImplication.getChildren();
        return new PropositionalNegation(this).equals(propositionalConstraintArray[0]) || this.equals(propositionalConstraintArray[1]);
    }

    public boolean moreSpecificThan(PropositionalDoubleImplication propositionalDoubleImplication) {
        return false;
    }

    public boolean moreSpecificThan(PropositionalConjunction propositionalConjunction) {
        return false;
    }

    public boolean moreSpecificThan(PropositionalDisjunction propositionalDisjunction) {
        return propositionalDisjunction.size() > 1 && propositionalDisjunction.contains(this);
    }

    public boolean moreSpecificThan(PropositionalAtLeast propositionalAtLeast) {
        return false;
    }

    public boolean moreSpecificThan(PropositionalNegation propositionalNegation) {
        return false;
    }

    public boolean moreSpecificThan(PropositionalVariable propositionalVariable) {
        return false;
    }

    public boolean moreSpecificThan(PropositionalConstant propositionalConstant) {
        return propositionalConstant.evaluate();
    }

    public int hashCode() {
        return this.classifier.toString().hashCode() + System.identityHashCode(this.example) + this.prediction.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof PropositionalVariable)) {
            return false;
        }
        PropositionalVariable propositionalVariable = (PropositionalVariable)object;
        return this.classifier.equals(propositionalVariable.classifier) && this.example == propositionalVariable.example && this.prediction.equals(propositionalVariable.prediction);
    }

    public void runVisit(Inference inference) {
        inference.visit(this);
    }

    public void write(StringBuffer stringBuffer) {
        stringBuffer.append(this.classifier);
        stringBuffer.append("(");
        stringBuffer.append(this.example);
        stringBuffer.append(") :: ");
        stringBuffer.append(this.prediction);
    }
}

