/*
 * Decompiled with CFR 0.152.
 */
package LBJ2.infer;

import LBJ2.classify.Score;
import LBJ2.infer.ILPSolver;
import LBJ2.util.DVector;
import LBJ2.util.DVector2D;
import LBJ2.util.IVector;
import LBJ2.util.IVector2D;
import com.dashoptimization.XPRS;
import com.dashoptimization.XPRSprob;
import java.util.Arrays;

public class XpressMPHook
implements ILPSolver {
    private static final byte[] typeCodes = new byte[]{76, 69, 71};
    private static final int ROWLESSTHAN = 0;
    private static final int ROWEQUAL = 1;
    private static final int ROWGREATERTHAN = 2;
    private static int nextID = 0;
    private int problemID;
    protected int verbosity;
    private XPRSprob problem;
    private double[] x;
    private boolean maximize;
    private DVector objective;
    private IVector rowTypes;
    private DVector rhs;
    private XMPIVector2D rowIndexes;
    private XMPDVector2D coefficients;
    private XMPIVector2D setColumns;

    public XpressMPHook() {
        this(0);
    }

    public XpressMPHook(int n) {
        this.verbosity = n;
        if (nextID == 0) {
            try {
                XPRS.init();
            }
            catch (Exception exception) {
                System.err.println("Couldn't initialize Xpress-MP: " + exception);
                System.exit(1);
            }
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void run() {
                    XPRS.free();
                }
            });
        }
        this.problemID = nextID++;
        this.reset();
    }

    public void reset() {
        if (this.problem != null) {
            this.problemID = nextID++;
            this.problem = null;
        }
        this.x = null;
        this.objective = new DVector();
        this.rowTypes = new IVector();
        this.rhs = new DVector();
        this.rowIndexes = new XMPIVector2D();
        this.coefficients = new XMPDVector2D();
        this.setColumns = new XMPIVector2D();
    }

    public void setMaximize(boolean bl) {
        this.maximize = bl;
    }

    public int addBooleanVariable(double d) {
        int n = this.objective.size();
        this.objective.add(d);
        return n;
    }

    public int[] addDiscreteVariable(double[] dArray) {
        int n = this.setColumns.size();
        int[] nArray = new int[dArray.length];
        int n2 = this.objective.size();
        int n3 = this.setColumns.size(n);
        for (int i = 0; i < dArray.length; ++i) {
            nArray[i] = n2 + i;
            this.setColumns.set(n, n3 + i, n2 + i);
            this.objective.add(dArray[i]);
        }
        double[] dArray2 = new double[dArray.length];
        Arrays.fill(dArray2, 1.0);
        this.addGreaterThanConstraint(nArray, dArray2, 1.0);
        return nArray;
    }

    public int[] addDiscreteVariable(Score[] scoreArray) {
        int n = this.setColumns.size();
        int[] nArray = new int[scoreArray.length];
        int n2 = this.objective.size();
        int n3 = this.setColumns.size(n);
        for (int i = 0; i < scoreArray.length; ++i) {
            nArray[i] = n2 + i;
            this.setColumns.set(n, n3 + i, n2 + i);
            this.objective.add(scoreArray[i].score);
        }
        double[] dArray = new double[scoreArray.length];
        Arrays.fill(dArray, 1.0);
        this.addGreaterThanConstraint(nArray, dArray, 1.0);
        return nArray;
    }

    public void addConstraint(int[] nArray, double[] dArray, double d, int n) {
        int n2 = this.rowTypes.size();
        this.rowTypes.add(n);
        this.rhs.add(d);
        for (int i = 0; i < nArray.length; ++i) {
            int n3 = this.rowIndexes.size(nArray[i]);
            this.rowIndexes.set(nArray[i], n3, n2);
            this.coefficients.set(nArray[i], n3, dArray[i]);
        }
    }

    public void addEqualityConstraint(int[] nArray, double[] dArray, double d) {
        this.addConstraint(nArray, dArray, d, 1);
    }

    public void addGreaterThanConstraint(int[] nArray, double[] dArray, double d) {
        this.addConstraint(nArray, dArray, d, 2);
    }

    public void addLessThanConstraint(int[] nArray, double[] dArray, double d) {
        this.addConstraint(nArray, dArray, d, 0);
    }

    public boolean solve() throws Exception {
        int n = this.objective.size();
        int n2 = this.rowTypes.size();
        byte[] byArray = new byte[n2];
        for (int i = 0; i < n2; ++i) {
            byArray[i] = typeCodes[this.rowTypes.get(i)];
        }
        double[] dArray = this.rhs.toArray();
        double[] dArray2 = this.objective.toArray();
        int[] nArray = this.rowIndexes.indexMap();
        int[] nArray2 = this.rowIndexes.flatten();
        double[] dArray3 = this.coefficients.flatten();
        double[] dArray4 = new double[n];
        double[] dArray5 = new double[n];
        Arrays.fill(dArray5, 1.0);
        int n3 = this.setColumns.size();
        byte[] byArray2 = new byte[n];
        int[] nArray3 = new int[n];
        Arrays.fill(byArray2, (byte)66);
        for (int i = 0; i < n; ++i) {
            nArray3[i] = i;
        }
        byte[] byArray3 = new byte[n3];
        Arrays.fill(byArray3, (byte)49);
        int[] nArray4 = this.setColumns.indexMap();
        int[] nArray5 = this.setColumns.flatten();
        double[] dArray6 = new double[nArray5.length];
        for (int i = 0; i < dArray6.length; ++i) {
            dArray6[i] = i + 1;
        }
        if (this.verbosity > 0) {
            System.out.println(" variables: " + dArray2.length);
            System.out.println(" constraints: " + dArray.length);
        }
        if (this.verbosity == 2) {
            StringBuffer stringBuffer = new StringBuffer();
            this.write(stringBuffer);
            System.out.print(stringBuffer);
        }
        this.problem = new XPRSprob();
        try {
            this.problem.setIntControl(8047, 0);
            this.problem.setIntControl(8028, 0);
            this.problem.setIntControl(8035, 0);
        }
        catch (Exception exception) {
            System.err.println("Can't set Xpress-MP output control: " + exception);
            System.err.println("Xpress-MP will probably be very verbose.");
        }
        String string = "" + this.problemID;
        while (string.length() < 5) {
            string = "0" + string;
        }
        string = "xmp" + string;
        this.problem.loadGlobal(string, n, n2, byArray, dArray, null, dArray2, nArray, null, nArray2, dArray3, dArray4, dArray5, n, n3, byArray2, nArray3, null, byArray3, nArray4, nArray5, dArray6);
        if (this.maximize) {
            this.problem.maxim("g");
        } else {
            this.problem.minim("g");
        }
        int n4 = this.problem.getIntAttrib(1011);
        return n4 == 6 || n4 == 4;
    }

    private static String arrayToString(byte[] byArray) {
        String string = "[";
        for (int i = 0; i < byArray.length; ++i) {
            string = string + " " + (char)byArray[i];
            if (i >= byArray.length - 1) continue;
            string = string + ",";
        }
        string = string + " ]";
        return string;
    }

    private static String arrayToString(int[] nArray) {
        String string = "[";
        for (int i = 0; i < nArray.length; ++i) {
            string = string + " " + nArray[i];
            if (i >= nArray.length - 1) continue;
            string = string + ",";
        }
        string = string + " ]";
        return string;
    }

    private static String arrayToString(double[] dArray) {
        String string = "[";
        for (int i = 0; i < dArray.length; ++i) {
            string = string + " " + dArray[i];
            if (i >= dArray.length - 1) continue;
            string = string + ",";
        }
        string = string + " ]";
        return string;
    }

    public boolean isSolved() {
        return this.problem != null;
    }

    public boolean getBooleanValue(int n) {
        if (this.x == null) {
            this.x = new double[this.objective.size()];
            try {
                this.problem.getSol(this.x, null, null, null);
            }
            catch (Exception exception) {
                System.err.println("Couldn't get Xpress-MP problem solution: " + exception);
                System.exit(1);
            }
        }
        return this.x[n] > 0.5;
    }

    public double objectiveValue() {
        int n = this.problem.getIntAttrib(1011);
        if (n == 5) {
            return this.maximize ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
        }
        if (n == 6 || n == 4) {
            return this.problem.getDblAttrib(2003);
        }
        return 0.0;
    }

    public void write(StringBuffer stringBuffer) {
        int n;
        int n2;
        int n3;
        int n4;
        if (this.maximize) {
            stringBuffer.append("max");
        } else {
            stringBuffer.append("min");
        }
        int n5 = this.objective.size();
        for (n4 = 0; n4 < n5; ++n4) {
            double d = this.objective.get(n4);
            stringBuffer.append(" ");
            if (d >= 0.0) {
                stringBuffer.append("+");
            }
            stringBuffer.append(d);
            stringBuffer.append(" x_");
            stringBuffer.append(n4);
        }
        stringBuffer.append("\n");
        n4 = this.setColumns.size();
        for (n3 = 0; n3 < n4; ++n3) {
            stringBuffer.append(" atmost 1 of (x in {");
            int n6 = this.setColumns.size(n3);
            for (n2 = 0; n2 < n6; ++n2) {
                stringBuffer.append("x_");
                stringBuffer.append(this.setColumns.get(n3, n2));
                if (n2 + 1 >= n6) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append("}) (x > 0)\n");
        }
        n3 = this.rowTypes.size();
        StringBuffer[] stringBufferArray = new StringBuffer[n3];
        for (n2 = 0; n2 < stringBufferArray.length; ++n2) {
            stringBufferArray[n2] = new StringBuffer();
            stringBufferArray[n2].append(" ");
        }
        for (n2 = 0; n2 < n5; ++n2) {
            n = this.rowIndexes.size(n2);
            for (int i = 0; i < n; ++i) {
                int n7 = this.rowIndexes.get(n2, i);
                double d = this.coefficients.get(n2, i);
                stringBufferArray[n7].append(" ");
                if (d >= 0.0) {
                    stringBufferArray[n7].append("+");
                }
                stringBufferArray[n7].append(d);
                stringBufferArray[n7].append(" x_");
                stringBufferArray[n7].append(n2);
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            n = this.rowTypes.get(n2);
            if (typeCodes[n] == 76) {
                stringBufferArray[n2].append(" <= ");
            } else if (typeCodes[n] == 69) {
                stringBufferArray[n2].append(" = ");
            } else if (typeCodes[n] == 71) {
                stringBufferArray[n2].append(" >= ");
            }
            stringBufferArray[n2].append(this.rhs.get(n2));
        }
        for (n2 = 0; n2 < stringBufferArray.length; ++n2) {
            stringBuffer.append(stringBufferArray[n2]);
            stringBuffer.append("\n");
        }
    }

    private static class XMPIVector2D
    extends IVector2D {
        public int[] indexMap() {
            int n = this.sizes.size();
            int[] nArray = new int[n + 1];
            for (int i = 0; i < n; ++i) {
                nArray[i + 1] = nArray[i] + this.sizes.get(i);
            }
            return nArray;
        }

        public int[] flatten() {
            int n = this.sizes.size();
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                n2 += this.sizes.get(i);
            }
            int[] nArray = new int[n2];
            n2 = 0;
            for (int i = 0; i < n; ++i) {
                int n3 = this.sizes.get(i);
                System.arraycopy(this.vector[i], 0, nArray, n2, n3);
                n2 += n3;
            }
            return nArray;
        }
    }

    private static class XMPDVector2D
    extends DVector2D {
        public int[] indexMap() {
            int n = this.sizes.size();
            int[] nArray = new int[n + 1];
            for (int i = 0; i < n; ++i) {
                nArray[i + 1] = nArray[i] + this.sizes.get(i);
            }
            return nArray;
        }

        public double[] flatten() {
            int n = this.sizes.size();
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                n2 += this.sizes.get(i);
            }
            double[] dArray = new double[n2];
            n2 = 0;
            for (int i = 0; i < n; ++i) {
                int n3 = this.sizes.get(i);
                System.arraycopy(this.vector[i], 0, dArray, n2, n3);
                n2 += n3;
            }
            return dArray;
        }
    }
}

