/*
 * Decompiled with CFR 0.152.
 */
package LBJ2.infer;

import LBJ2.classify.Score;
import LBJ2.parse.LineByLine;
import LBJ2.util.DVector;
import LBJ2.util.DVector2D;
import LBJ2.util.IVector;
import LBJ2.util.IVector2D;
import LBJ2.util.Sort;
import java.util.Arrays;

public class ZeroOneILPProblem {
    public static final int EQUALITY = 0;
    public static final int LESS_THAN = 1;
    public static final int GREATER_THAN = 2;
    public static final String[] boundTypeSymbols = new String[]{"=", "<=", ">="};
    public static final double TOLERANCE = 1.0E-10;
    protected boolean maximize;
    protected DVector objectiveCoefficients;
    protected IVector2D Av;
    protected DVector2D Ac;
    protected IVector boundTypes;
    protected DVector bounds;

    public ZeroOneILPProblem() {
        this.reset();
    }

    public ZeroOneILPProblem(String string) {
        int n;
        int n2;
        this.reset();
        LineByLine lineByLine = new LineByLine(string){

            public Object next() {
                String string = this.readLine();
                while (string != null && string.matches("\\s*")) {
                    string = this.readLine();
                }
                return string;
            }
        };
        String string2 = (String)lineByLine.next();
        String[] stringArray = string2.split(" ");
        this.maximize = stringArray[0].startsWith("max");
        for (n2 = 1; n2 < stringArray.length; n2 += 2) {
            double d = Double.parseDouble(stringArray[n2]);
            n = Integer.parseInt(stringArray[n2 + 1].substring(2));
            this.objectiveCoefficients.set(n, d);
        }
        string2 = (String)lineByLine.next();
        if (string2.indexOf("subject") != -1) {
            string2 = (String)lineByLine.next();
        }
        n2 = 0;
        while (string2 != null) {
            stringArray = string2.substring(2).split(" ");
            int[] nArray = new int[stringArray.length / 2 - 1];
            double[] dArray = new double[nArray.length];
            for (n = 0; n < stringArray.length - 2; n += 2) {
                dArray[n / 2] = Double.parseDouble(stringArray[n]);
                nArray[n / 2] = Integer.parseInt(stringArray[n + 1].substring(2));
            }
            n = 0;
            if (stringArray[stringArray.length - 2].charAt(0) == '>') {
                n = 2;
            } else if (stringArray[stringArray.length - 2].charAt(0) == '<') {
                n = 1;
            }
            double d = Double.parseDouble(stringArray[stringArray.length - 1]);
            this.addConstraint(nArray, dArray, n, d);
            string2 = (String)lineByLine.next();
            ++n2;
        }
    }

    public void reset() {
        this.maximize = false;
        this.objectiveCoefficients = new DVector();
        this.Av = new IVector2D();
        this.Ac = new DVector2D();
        this.boundTypes = new IVector();
        this.bounds = new DVector();
    }

    public void setMaximize(boolean bl) {
        this.maximize = bl;
    }

    public boolean getMaximize() {
        return this.maximize;
    }

    public int rows() {
        return this.bounds.size();
    }

    public int columns() {
        return this.objectiveCoefficients.size();
    }

    public void setObjectiveCoefficient(int n, double d) {
        this.objectiveCoefficients.set(n, d);
    }

    public double getObjectiveCoefficient(int n) {
        return this.objectiveCoefficients.get(n);
    }

    public void setConstraintCoefficient(int n, int n2, double d) {
        int n3 = this.Av.binarySearch(n, n2);
        if (n3 < 0) {
            n3 = -n3 - 1;
            for (int i = this.Av.size(n) - 1; i >= n3; --i) {
                this.Av.set(n, i + 1, this.Av.get(n, i));
                this.Ac.set(n, i + 1, this.Ac.get(n, i));
            }
            this.Av.set(n, n3, n2);
        }
        this.Ac.set(n, n3, d);
    }

    public double getConstraintCoefficient(int n, int n2) {
        int n3 = this.Av.binarySearch(n, n2);
        if (n3 < 0) {
            return 0.0;
        }
        return this.Ac.get(n, n3);
    }

    public void setBoundType(int n, int n2) {
        this.boundTypes.set(n, n2);
    }

    public int getBoundType(int n) {
        return this.boundTypes.get(n);
    }

    public void setConstraintBound(int n, double d) {
        this.bounds.set(n, d);
    }

    public double getConstraintBound(int n) {
        return this.bounds.get(n);
    }

    public boolean constraintsSatisfied(int[] nArray) {
        int n = this.Av.size();
        for (int i = 0; i < n; ++i) {
            double d = 0.0;
            int n2 = this.Av.size(i);
            for (int j = 0; j < n2; ++j) {
                d += this.Ac.get(i, j) * (double)nArray[this.Av.get(i, j)];
            }
            if (!(this.boundTypes.get(i) == 0 && d != this.bounds.get(i) || this.boundTypes.get(i) == 1 && d > this.bounds.get(i)) && (this.boundTypes.get(i) != 2 || !(d < this.bounds.get(i)))) continue;
            return false;
        }
        return true;
    }

    public int addBooleanVariable(double d) {
        this.objectiveCoefficients.add(d);
        return this.objectiveCoefficients.size() - 1;
    }

    public int[] addDiscreteVariable(double[] dArray) {
        int n = this.objectiveCoefficients.size();
        int[] nArray = new int[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            this.objectiveCoefficients.add(dArray[i]);
            nArray[i] = n + i;
        }
        double[] dArray2 = new double[dArray.length];
        Arrays.fill(dArray2, 1.0);
        this.addEqualityConstraint(nArray, dArray2, 1.0);
        return nArray;
    }

    public int[] addDiscreteVariable(Score[] scoreArray) {
        double[] dArray = new double[scoreArray.length];
        for (int i = 0; i < scoreArray.length; ++i) {
            dArray[i] = scoreArray[i].score;
        }
        return this.addDiscreteVariable(dArray);
    }

    protected void addConstraint(final int[] nArray, double[] dArray, double d) {
        int n;
        int[] nArray2 = new int[nArray.length];
        for (n = 0; n < nArray.length; ++n) {
            nArray2[n] = n;
        }
        Sort.sort(nArray2, new Sort.IntComparator(){

            public int compare(int n, int n2) {
                return nArray[n] - nArray[n2];
            }
        });
        n = this.Av.size();
        for (int i = 0; i < nArray.length; ++i) {
            this.Av.set(n, i, nArray[nArray2[i]]);
            double d2 = dArray[nArray2[i]];
            double d3 = Math.round(d2);
            if (Math.abs(d2 - d3) < 1.0E-10) {
                d2 = d3;
            }
            this.Ac.set(n, i, d2);
        }
        this.bounds.add(d);
    }

    protected void addConstraint(int[] nArray, double[] dArray, int n, double d) {
        this.addConstraint(nArray, dArray, d);
        this.boundTypes.add(n);
    }

    public void addEqualityConstraint(int[] nArray, double[] dArray, double d) {
        this.addConstraint(nArray, dArray, 0, d);
    }

    public void addGreaterThanConstraint(int[] nArray, double[] dArray, double d) {
        this.addConstraint(nArray, dArray, 2, d);
    }

    public void addLessThanConstraint(int[] nArray, double[] dArray, double d) {
        this.addConstraint(nArray, dArray, 1, d);
    }

    public double evaluate(int[] nArray) {
        double d = 0.0;
        for (int i = 0; i < nArray.length; ++i) {
            d += (double)nArray[i] * this.objectiveCoefficients.get(i);
        }
        return d;
    }

    public void write(StringBuffer stringBuffer) {
        int n;
        if (this.maximize) {
            stringBuffer.append("max");
        } else {
            stringBuffer.append("min");
        }
        int n2 = this.objectiveCoefficients.size();
        for (n = 0; n < n2; ++n) {
            double d = this.objectiveCoefficients.get(n);
            stringBuffer.append(" ");
            if (d >= 0.0) {
                stringBuffer.append("+");
            }
            stringBuffer.append(d);
            stringBuffer.append(" x_");
            stringBuffer.append(n);
        }
        stringBuffer.append("\n");
        n = this.Ac.size();
        for (int i = 0; i < n; ++i) {
            int n3 = this.Ac.size(i);
            stringBuffer.append(" ");
            for (int j = 0; j < n3; ++j) {
                double d = this.Ac.get(i, j);
                stringBuffer.append(" ");
                if (d >= 0.0) {
                    stringBuffer.append("+");
                }
                stringBuffer.append(d);
                stringBuffer.append(" x_");
                stringBuffer.append(this.Av.get(i, j));
            }
            stringBuffer.append(" ");
            stringBuffer.append(boundTypeSymbols[this.boundTypes.get(i)]);
            stringBuffer.append(" ");
            stringBuffer.append(this.bounds.get(i));
            stringBuffer.append("\n");
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.write(stringBuffer);
        return stringBuffer.toString();
    }
}

