/*
 * Decompiled with CFR 0.152.
 */
package LBJ2.learn;

import LBJ2.classify.DiscreteConjunctiveFeature;
import LBJ2.classify.DiscreteReferrer;
import LBJ2.classify.Feature;
import LBJ2.classify.RealConjunctiveFeature;
import LBJ2.classify.RealReferrer;
import LBJ2.learn.Lexicon;
import LBJ2.util.ExceptionlessInputStream;
import LBJ2.util.ExceptionlessOutputStream;
import LBJ2.util.IVector;

public class ChildLexicon
extends Lexicon {
    private IVector parents;
    private Lexicon parentLexicon;

    public ChildLexicon() {
    }

    public ChildLexicon(Lexicon lexicon) {
        this.parentLexicon = lexicon;
    }

    public ChildLexicon(Lexicon lexicon, String string) {
        super(string);
        this.parentLexicon = lexicon;
    }

    public void clear() {
        super.clear();
        this.parents = new IVector();
    }

    public void setParent(Lexicon lexicon) {
        this.parentLexicon = lexicon;
        int n = this.lexiconInv.size();
        for (int i = 0; i < n; ++i) {
            Feature feature = this.lexiconInv.get(i);
            if (feature == null || this.parents.get(i) >= 0) continue;
            Feature feature2 = lexicon.lookupKey(lexicon.lookup(feature));
            if (feature2 == null) {
                System.err.println("LBJ ERROR: Can't find feature " + feature + " in parent lexicon.");
                new Exception().printStackTrace();
                System.exit(1);
            }
            this.lexiconInv.set(i, feature2);
            if (this.lexicon == null) continue;
            this.lexicon.put(feature2, this.lexicon.remove(feature));
        }
    }

    public Feature remove(Feature feature) {
        if (this.contains(feature)) {
            int n = this.lookup(feature);
            int n2 = this.parents.get(n);
            if (n2 == 0) {
                feature.removeFromChildLexicon(this);
                this.lexicon.remove(feature);
                return this.lexiconInv.set(n, null);
            }
            if (n2 > 0) {
                this.parents.set(n, -n2);
                return this.lexiconInv.get(n);
            }
            System.err.println("LBJ ERROR: Marking feature as removable for the second time: " + feature);
            new Exception().printStackTrace();
            System.exit(1);
        }
        return null;
    }

    public void decrementParentCounts(Feature feature) {
        int n = this.lookup(feature);
        int n2 = this.parents.get(n);
        if (n2 == 0) {
            System.err.println("LBJ ERROR: Parent count incorrect for feature " + feature);
            new Exception().printStackTrace();
            System.exit(1);
        } else if (n2 < 0) {
            this.parents.increment(n);
            if (n2 == -1) {
                feature.removeFromChildLexicon(this);
                this.lexicon.remove(feature);
                this.lexiconInv.set(n, null);
            }
        } else {
            this.parents.decrement(n);
        }
    }

    public Feature getChildFeature(Feature feature, int n) {
        return this.lexiconInv.get(feature.childLexiconLookup(this, n));
    }

    public int childLexiconLookup(Feature feature, int n) {
        return this.lookup(feature, true, n);
    }

    public int childLexiconLookup(DiscreteConjunctiveFeature discreteConjunctiveFeature, int n) {
        int n2 = this.lexiconInv.size();
        int n3 = this.lookup(discreteConjunctiveFeature, true, n);
        if (n2 < this.lexiconInv.size()) {
            this.incrementParentCounts(discreteConjunctiveFeature.getLeft(), n);
            this.incrementParentCounts(discreteConjunctiveFeature.getRight(), n);
        }
        return n3;
    }

    public int childLexiconLookup(RealConjunctiveFeature realConjunctiveFeature, int n) {
        int n2 = this.lexiconInv.size();
        int n3 = this.lookup(realConjunctiveFeature, true, n);
        if (n2 < this.lexiconInv.size()) {
            this.incrementParentCounts(realConjunctiveFeature.getLeft(), n);
            this.incrementParentCounts(realConjunctiveFeature.getRight(), n);
        }
        return n3;
    }

    public int childLexiconLookup(DiscreteReferrer discreteReferrer, int n) {
        int n2 = this.lexiconInv.size();
        int n3 = this.lookup(discreteReferrer, true, n);
        if (n2 < this.lexiconInv.size()) {
            this.incrementParentCounts(discreteReferrer.getReferent(), n);
        }
        return n3;
    }

    public int childLexiconLookup(RealReferrer realReferrer, int n) {
        int n2 = this.lexiconInv.size();
        int n3 = this.lookup(realReferrer, true, n);
        if (n2 < this.lexiconInv.size()) {
            this.incrementParentCounts(realReferrer.getReferent(), n);
        }
        return n3;
    }

    protected void incrementParentCounts(Feature feature, int n) {
        int n2 = feature.childLexiconLookup(this, n);
        if (this.parents.get(n2) == 0) {
            this.parents.set(n2, this.parentLexicon.contains(feature) ? -1 : 1);
        } else if (this.parents.get(n2) > 0) {
            this.parents.increment(n2);
        } else {
            this.parents.decrement(n2);
        }
    }

    public int lookupChild(Feature feature) {
        this.lazyMapCreation();
        Integer n = (Integer)this.lexicon.get(feature);
        if (n != null) {
            return n;
        }
        throw new UnsupportedOperationException("When calling ChildLexicon.lookupChild(Feature), the feature must be present in the lexicon. (" + feature + ")");
    }

    public void write(ExceptionlessOutputStream exceptionlessOutputStream) {
        int n;
        int n2;
        int n3 = this.lexiconInv.size();
        for (n2 = 0; n2 < n3 && this.lexiconInv.get(n2) != null; ++n2) {
        }
        for (n = n2; n < n3 && this.lexiconInv.get(n) == null; ++n) {
        }
        while (n < n3) {
            this.parents.set(n2++, this.parents.get(n++));
            while (n < n3 && this.lexiconInv.get(n) == null) {
                ++n;
            }
        }
        n3 = this.parents.size();
        if (n2 < n3) {
            for (n = n3 - 1; n >= n2; --n) {
                this.parents.remove(n);
            }
            this.parents = new IVector(this.parents);
        }
        this.lexiconInv.consolidate();
        this.lexicon = null;
        super.write(exceptionlessOutputStream);
        this.parents.write(exceptionlessOutputStream);
    }

    public void read(ExceptionlessInputStream exceptionlessInputStream, boolean bl) {
        super.read(exceptionlessInputStream, bl);
        this.parents.read(exceptionlessInputStream);
    }

    public void printCountTable(boolean bl) {
        this.featureCounts = this.parents;
        super.printCountTable(bl);
        this.featureCounts = null;
    }
}

