/*
 * Decompiled with CFR 0.152.
 */
package LBJ2.learn;

import LBJ2.classify.Classifier;
import LBJ2.classify.DiscretePrimitiveStringFeature;
import LBJ2.classify.Feature;
import LBJ2.classify.FeatureVector;
import LBJ2.classify.FeatureVectorReturner;
import LBJ2.classify.LabelVectorReturner;
import LBJ2.classify.ScoreSet;
import LBJ2.learn.Lexicon;
import LBJ2.util.ClassUtils;
import LBJ2.util.ExceptionlessInputStream;
import LBJ2.util.ExceptionlessOutputStream;
import LBJ2.util.FVector;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.URL;

public abstract class Learner
extends Classifier {
    protected Classifier labeler;
    protected Classifier extractor;
    protected Lexicon lexicon;
    protected Lexicon labelLexicon;
    protected String encoding;
    protected FVector predictions;
    protected URL lcFilePath;
    protected URL lexFilePath;
    protected boolean readLexiconOnDemand;
    static /* synthetic */ Class class$LBJ2$learn$Learner;

    protected Learner() {
    }

    protected Learner(String string) {
        super(string);
        this.lexicon = new Lexicon();
        this.labelLexicon = new Lexicon();
        this.predictions = new FVector();
    }

    protected Learner(String string, Classifier classifier) {
        this(string, null, classifier);
    }

    protected Learner(String string, Classifier classifier, Classifier classifier2) {
        super(string);
        this.setLabeler(classifier);
        this.setExtractor(classifier2);
        this.lexicon = new Lexicon();
        this.labelLexicon = new Lexicon();
        this.predictions = new FVector();
    }

    public void setParameters(Parameters parameters) {
        parameters.setParameters(this);
    }

    public Parameters getParameters() {
        return new Parameters();
    }

    public void setLabeler(Classifier classifier) {
        this.labeler = classifier;
    }

    public Classifier getLabeler() {
        return this.labeler;
    }

    public void setExtractor(Classifier classifier) {
        this.extractor = classifier;
    }

    public Classifier getExtractor() {
        return this.extractor;
    }

    public void setLexicon(Lexicon lexicon) {
        this.lexicon = lexicon;
        if (lexicon == null) {
            System.gc();
        } else {
            lexicon.setEncoding(this.encoding);
        }
    }

    public Lexicon getLexicon() {
        this.demandLexicon();
        return this.lexicon;
    }

    public void setLabelLexicon(Lexicon lexicon) {
        this.labelLexicon = lexicon;
        if (this.labelLexicon == null) {
            this.predictions = null;
            return;
        }
        int n = this.labelLexicon.size();
        this.predictions = new FVector(n);
        for (int i = 0; i < n; ++i) {
            this.createPrediction(i);
        }
    }

    public Lexicon getLabelLexicon() {
        return this.labelLexicon;
    }

    public void setEncoding(String string) {
        this.encoding = string;
        this.lexicon.setEncoding(string);
    }

    public void setModelLocation(String string) {
        try {
            this.lcFilePath = new URL("file:" + string);
        }
        catch (Exception exception) {
            System.err.println("ERROR: Can't create URL for file '" + string + "':");
            exception.printStackTrace();
            System.exit(1);
        }
    }

    public void setModelLocation(URL uRL) {
        this.lcFilePath = uRL;
    }

    public URL getModelLocation() {
        return this.lcFilePath;
    }

    public void setLexiconLocation(String string) {
        try {
            this.lexFilePath = new URL("file:" + string);
        }
        catch (Exception exception) {
            System.err.println("ERROR: Can't create URL for file '" + string + "':");
            exception.printStackTrace();
            System.exit(1);
        }
    }

    public void setLexiconLocation(URL uRL) {
        this.lexFilePath = uRL;
    }

    public URL getLexiconLocation() {
        return this.lexFilePath;
    }

    public void countFeatures(Lexicon.CountPolicy countPolicy) {
        if (countPolicy == Lexicon.CountPolicy.perClass && !this.getOutputType().equals("discrete")) {
            throw new IllegalArgumentException("LBJ ERROR: Learner.countFeatures: Can't do 'per class' feature counting unless the learner is discrete.");
        }
        this.demandLexicon();
        this.lexicon.countFeatures(countPolicy);
    }

    public Lexicon getLexiconDiscardCounts() {
        if (this.readLexiconOnDemand && (this.lexicon == null || this.lexicon.size() == 0)) {
            this.lexicon = Lexicon.readLexicon(this.lexFilePath, false);
        } else {
            this.lexicon.countFeatures(Lexicon.CountPolicy.none);
        }
        return this.lexicon;
    }

    public Learner emptyClone() {
        Learner learner = (Learner)super.clone();
        learner.forget();
        return learner;
    }

    public void learn(Object object) {
        Object[] objectArray = this.getExampleArray(object);
        this.learn((int[])objectArray[0], (double[])objectArray[1], (int[])objectArray[2], (double[])objectArray[3]);
    }

    public void learn(FeatureVector featureVector) {
        Classifier classifier = this.getExtractor();
        Classifier classifier2 = this.getLabeler();
        this.setExtractor(new FeatureVectorReturner());
        this.setLabeler(new LabelVectorReturner());
        this.learn((Object)featureVector);
        this.setExtractor(classifier);
        this.setLabeler(classifier2);
    }

    public abstract void learn(int[] var1, double[] var2, int[] var3, double[] var4);

    public void learn(Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            this.learn(objectArray[i]);
        }
        this.doneLearning();
    }

    public void learn(FeatureVector[] featureVectorArray) {
        for (int i = 0; i < featureVectorArray.length; ++i) {
            this.learn(featureVectorArray[i]);
        }
        this.doneLearning();
    }

    public FeatureVector classify(Object object) {
        Object[] objectArray = this.getExampleArray(object, false);
        return this.classify((int[])objectArray[0], (double[])objectArray[1]);
    }

    public FeatureVector classify(FeatureVector featureVector) {
        Classifier classifier = this.getExtractor();
        Classifier classifier2 = this.getLabeler();
        this.setExtractor(new FeatureVectorReturner());
        this.setLabeler(new LabelVectorReturner());
        FeatureVector featureVector2 = this.classify((Object)featureVector);
        this.setExtractor(classifier);
        this.setLabeler(classifier2);
        return featureVector2;
    }

    public abstract FeatureVector classify(int[] var1, double[] var2);

    public FeatureVector[] classify(FeatureVector[] featureVectorArray) {
        FeatureVector[] featureVectorArray2 = new FeatureVector[featureVectorArray.length];
        for (int i = 0; i < featureVectorArray.length; ++i) {
            featureVectorArray2[i] = this.classify(featureVectorArray[i]);
        }
        return featureVectorArray2;
    }

    public FeatureVector[] classify(Object[][] objectArray) {
        FeatureVector[] featureVectorArray = new FeatureVector[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            featureVectorArray[i] = this.classify((int[])objectArray[i][0], (double[])objectArray[i][1]);
        }
        return featureVectorArray;
    }

    public Feature featureValue(Object object) {
        Object[] objectArray = this.getExampleArray(object, false);
        return this.featureValue((int[])objectArray[0], (double[])objectArray[1]);
    }

    public Feature featureValue(FeatureVector featureVector) {
        Classifier classifier = this.getExtractor();
        Classifier classifier2 = this.getLabeler();
        this.setExtractor(new FeatureVectorReturner());
        this.setLabeler(new LabelVectorReturner());
        Feature feature = this.featureValue((Object)featureVector);
        this.setExtractor(classifier);
        this.setLabeler(classifier2);
        return feature;
    }

    public Feature featureValue(int[] nArray, double[] dArray) {
        throw new UnsupportedOperationException("The featureValue(int[], double[]) method has not been overridden in class '" + this.getClass().getName() + "'.");
    }

    public String discreteValue(Object object) {
        Object[] objectArray = this.getExampleArray(object, false);
        return this.discreteValue((int[])objectArray[0], (double[])objectArray[1]);
    }

    public String discreteValue(FeatureVector featureVector) {
        Classifier classifier = this.getExtractor();
        Classifier classifier2 = this.getLabeler();
        this.setExtractor(new FeatureVectorReturner());
        this.setLabeler(new LabelVectorReturner());
        String string = this.discreteValue((Object)featureVector);
        this.setExtractor(classifier);
        this.setLabeler(classifier2);
        return string;
    }

    public String discreteValue(int[] nArray, double[] dArray) {
        throw new UnsupportedOperationException("The discreteValue(Object) method has not been overridden in class '" + this.getClass().getName() + "'.");
    }

    public double realValue(Object object) {
        Object[] objectArray = this.getExampleArray(object, false);
        return this.realValue((int[])objectArray[0], (double[])objectArray[1]);
    }

    public double realValue(FeatureVector featureVector) {
        Classifier classifier = this.getExtractor();
        Classifier classifier2 = this.getLabeler();
        this.setExtractor(new FeatureVectorReturner());
        this.setLabeler(new LabelVectorReturner());
        double d = this.realValue((Object)featureVector);
        this.setExtractor(classifier);
        this.setLabeler(classifier2);
        return d;
    }

    public double realValue(int[] nArray, double[] dArray) {
        throw new UnsupportedOperationException("The realValue(Object) method has not been overridden in class '" + this.getClass().getName() + "'.");
    }

    public void doneLearning() {
    }

    public void initialize(int n, int n2) {
    }

    public void doneWithRound() {
    }

    public Object[] getExampleArray(Object object) {
        return this.getExampleArray(object, true);
    }

    public Object[] getExampleArray(Object object, boolean bl) {
        Feature feature;
        int n;
        double[] dArray;
        int[] nArray;
        int n2;
        FeatureVector featureVector;
        if (object instanceof Object[] && ((Object[])object)[0] instanceof int[] && ((Object[])object)[1] instanceof double[]) {
            return (Object[])object;
        }
        if (this.readLexiconOnDemand && (this.lexicon == null || this.lexicon.size() == 0)) {
            this.readLexicon(this.lexFilePath);
            this.readLexiconOnDemand = false;
        }
        Object[] objectArray = null;
        Lexicon.CountPolicy countPolicy = this.lexicon.getCountPolicy();
        int n3 = -1;
        if (bl) {
            featureVector = this.labeler.classify(object);
            n2 = featureVector.featuresSize();
            nArray = new int[n2];
            dArray = new double[n2];
            for (n = 0; n < n2; ++n) {
                feature = featureVector.getFeature(n);
                nArray[n] = feature.isDiscrete() ? this.labelLexicon.lookup(feature, true) : this.labelLexicon.lookup(feature.getFeatureKey(this.labelLexicon), true);
                int n4 = n;
                dArray[n4] = dArray[n4] + feature.getStrength();
                this.createPrediction(nArray[n]);
            }
            objectArray = new Object[]{null, null, nArray, dArray};
            if (countPolicy == Lexicon.CountPolicy.perClass) {
                n3 = nArray[0];
            }
        } else {
            objectArray = new Object[2];
        }
        featureVector = this.extractor.classify(object);
        n2 = featureVector.featuresSize();
        nArray = new int[n2];
        dArray = new double[n2];
        objectArray[0] = nArray;
        objectArray[1] = dArray;
        n = 0;
        while (n < n2) {
            feature = featureVector.getFeature(n);
            nArray[n] = this.lexicon.lookup(feature.getFeatureKey(this.lexicon, bl, n3), bl, n3);
            int n5 = n++;
            dArray[n5] = dArray[n5] + feature.getStrength();
        }
        return objectArray;
    }

    protected void createPrediction(int n) {
        this.createPrediction(this.labelLexicon, n);
    }

    protected void createPrediction(Lexicon lexicon, int n) {
        if (this.predictions.get(n) != null || !this.getOutputType().equals("discrete")) {
            return;
        }
        Feature feature = lexicon.lookupKey(n);
        this.predictions.set(n, new DiscretePrimitiveStringFeature(this.containingPackage, this.name, "", feature.getStringValue(), feature.getValueIndex(), feature.totalValues()));
    }

    public void forget() {
        this.lexicon = new Lexicon(this.encoding);
        this.labelLexicon = new Lexicon();
        this.predictions = new FVector();
        this.initialize(0, 0);
        this.readLexiconOnDemand = false;
    }

    public ScoreSet scores(Object object) {
        Object[] objectArray = this.getExampleArray(object, false);
        return this.scores((int[])objectArray[0], (double[])objectArray[1]);
    }

    public ScoreSet scores(FeatureVector featureVector) {
        Classifier classifier = this.getExtractor();
        Classifier classifier2 = this.getLabeler();
        this.setExtractor(new FeatureVectorReturner());
        this.setLabeler(new LabelVectorReturner());
        ScoreSet scoreSet = this.scores((Object)featureVector);
        this.setExtractor(classifier);
        this.setLabeler(classifier2);
        return scoreSet;
    }

    public abstract ScoreSet scores(int[] var1, double[] var2);

    public abstract void write(PrintStream var1);

    public void unclone() {
    }

    public int getPrunedLexiconSize() {
        if ((this.lexicon == null || this.lexicon.size() == 0) && this.readLexiconOnDemand) {
            ExceptionlessInputStream exceptionlessInputStream = ExceptionlessInputStream.openCompressedStream(this.lexFilePath);
            int n = Lexicon.readPrunedSize(exceptionlessInputStream);
            exceptionlessInputStream.close();
            return n;
        }
        return this.lexicon == null ? 0 : this.lexicon.getCutoff();
    }

    public Object clone() {
        Learner learner = (Learner)super.clone();
        if (this.lexicon != null) {
            learner.lexicon = (Lexicon)this.lexicon.clone();
        }
        if (this.labelLexicon != null) {
            learner.labelLexicon = (Lexicon)this.labelLexicon.clone();
        }
        if (this.predictions != null) {
            learner.predictions = (FVector)this.predictions.clone();
        }
        return learner;
    }

    public void save() {
        if (this.lcFilePath != null) {
            this.saveModel();
        }
        if (this.lexFilePath != null && this.lexicon != null && this.lexicon.size() > 0) {
            this.saveLexicon();
        }
    }

    public void saveModel() {
        if (this.lcFilePath == null) {
            System.err.println("LBJ ERROR: saveModel() called without a cached location");
            new Exception().printStackTrace();
            System.exit(1);
        }
        ExceptionlessOutputStream exceptionlessOutputStream = ExceptionlessOutputStream.openCompressedStream(this.lcFilePath);
        this.write(exceptionlessOutputStream);
        exceptionlessOutputStream.close();
    }

    public void saveLexicon() {
        if (this.lexFilePath == null) {
            System.err.println("LBJ ERROR: saveLexicon() called without a cached location");
            new Exception().printStackTrace();
            System.exit(1);
        }
        ExceptionlessOutputStream exceptionlessOutputStream = ExceptionlessOutputStream.openCompressedStream(this.lexFilePath);
        if (this.lexicon == null) {
            exceptionlessOutputStream.writeInt(0);
        } else {
            this.lexicon.write(exceptionlessOutputStream);
        }
        exceptionlessOutputStream.close();
    }

    public void write(String string, String string2) {
        this.writeModel(string);
        if (this.lexicon != null && this.lexicon.size() > 0) {
            this.writeLexicon(string2);
        }
    }

    public void writeModel(String string) {
        ExceptionlessOutputStream exceptionlessOutputStream = ExceptionlessOutputStream.openCompressedStream(string);
        this.write(exceptionlessOutputStream);
        exceptionlessOutputStream.close();
        try {
            this.lcFilePath = new URL("file:" + string);
        }
        catch (Exception exception) {
            System.err.println("Error constructing URL:");
            exception.printStackTrace();
            System.exit(1);
        }
    }

    public void writeLexicon(String string) {
        ExceptionlessOutputStream exceptionlessOutputStream = ExceptionlessOutputStream.openCompressedStream(string);
        if (this.lexicon == null) {
            exceptionlessOutputStream.writeInt(0);
        } else {
            this.lexicon.write(exceptionlessOutputStream);
        }
        exceptionlessOutputStream.close();
        try {
            this.lexFilePath = new URL("file:" + string);
        }
        catch (Exception exception) {
            System.err.println("Error constructing URL:");
            exception.printStackTrace();
            System.exit(1);
        }
    }

    public void write(ExceptionlessOutputStream exceptionlessOutputStream) {
        exceptionlessOutputStream.writeString(this.getClass().getName());
        exceptionlessOutputStream.writeString(this.containingPackage);
        exceptionlessOutputStream.writeString(this.name);
        exceptionlessOutputStream.writeString(this.encoding);
        if (this.labeler == null) {
            exceptionlessOutputStream.writeString(null);
        } else {
            exceptionlessOutputStream.writeString(this.labeler.getClass().getName());
        }
        if (this.extractor == null) {
            exceptionlessOutputStream.writeString(null);
        } else {
            exceptionlessOutputStream.writeString(this.extractor.getClass().getName());
        }
        if (this.labelLexicon == null) {
            exceptionlessOutputStream.writeInt(0);
        } else {
            this.labelLexicon.write(exceptionlessOutputStream);
        }
        if (this.predictions == null) {
            exceptionlessOutputStream.writeInt(0);
        } else {
            this.predictions.write(exceptionlessOutputStream);
        }
    }

    public void read(String string, String string2) {
        this.readModel(string);
        this.readLexicon(string2);
    }

    public void readModel(String string) {
        try {
            this.readModel(new URL("file:" + string));
        }
        catch (Exception exception) {
            System.err.println("Error constructing URL:");
            exception.printStackTrace();
            System.exit(1);
        }
    }

    public void readModel(URL uRL) {
        String string;
        ExceptionlessInputStream exceptionlessInputStream = ExceptionlessInputStream.openCompressedStream(uRL);
        String string2 = exceptionlessInputStream.readString();
        if (!string2.equals(string = this.getClass().getName())) {
            System.err.println("Error reading model from '" + uRL + "':");
            System.err.println("  Expected '" + string + "' but received '" + string2 + "'");
            new Exception().printStackTrace();
            exceptionlessInputStream.close();
            System.exit(1);
        }
        this.read(exceptionlessInputStream);
        exceptionlessInputStream.close();
        this.lcFilePath = uRL;
    }

    public void readLexicon(String string) {
        try {
            this.readLexicon(new URL("file:" + string));
        }
        catch (Exception exception) {
            System.err.println("Error constructing URL:");
            exception.printStackTrace();
            System.exit(1);
        }
    }

    public void readLexicon(URL uRL) {
        this.lexicon = Lexicon.readLexicon(uRL);
        this.lexFilePath = uRL;
    }

    public static Learner readLearner(String string) {
        return Learner.readLearner(string, true);
    }

    public static Learner readLearner(String string, boolean bl) {
        URL uRL = null;
        try {
            uRL = new URL("file:" + string);
        }
        catch (Exception exception) {
            System.err.println("Error constructing URL:");
            exception.printStackTrace();
            System.exit(1);
        }
        return Learner.readLearner(uRL, bl);
    }

    public static Learner readLearner(URL uRL) {
        return Learner.readLearner(uRL, true);
    }

    public static Learner readLearner(URL uRL, boolean bl) {
        ExceptionlessInputStream exceptionlessInputStream = ExceptionlessInputStream.openCompressedStream(uRL);
        Learner learner = Learner.readLearner(exceptionlessInputStream, bl);
        exceptionlessInputStream.close();
        learner.lcFilePath = uRL;
        return learner;
    }

    public static Learner readLearner(ExceptionlessInputStream exceptionlessInputStream) {
        return Learner.readLearner(exceptionlessInputStream, true);
    }

    public static Learner readLearner(ExceptionlessInputStream exceptionlessInputStream, boolean bl) {
        String string = exceptionlessInputStream.readString();
        if (string == null) {
            return null;
        }
        Learner learner = ClassUtils.getLearner(string);
        learner.unclone();
        if (bl) {
            learner.read(exceptionlessInputStream);
        } else {
            learner.readLabelLexicon(exceptionlessInputStream);
            Lexicon lexicon = learner.getLabelLexicon();
            learner.forget();
            learner.setLabelLexicon(lexicon);
        }
        return learner;
    }

    public void read(ExceptionlessInputStream exceptionlessInputStream) {
        this.readLabelLexicon(exceptionlessInputStream);
    }

    public void readLabelLexicon(ExceptionlessInputStream exceptionlessInputStream) {
        String string;
        this.containingPackage = exceptionlessInputStream.readString().intern();
        this.name = exceptionlessInputStream.readString().intern();
        this.encoding = exceptionlessInputStream.readString();
        if (this.encoding != null) {
            this.encoding = this.encoding.intern();
        }
        this.labeler = (string = exceptionlessInputStream.readString()) == null ? null : ClassUtils.getClassifier(string);
        string = exceptionlessInputStream.readString();
        this.extractor = string == null ? null : ClassUtils.getClassifier(string);
        this.labelLexicon = Lexicon.readLexicon(exceptionlessInputStream);
        if (this.predictions == null) {
            this.predictions = new FVector();
        }
        this.predictions.read(exceptionlessInputStream);
    }

    public void readLexiconOnDemand(String string) {
        URL uRL = null;
        try {
            uRL = new URL("file:" + string);
        }
        catch (Exception exception) {
            System.err.println("Error constructing URL:");
            exception.printStackTrace();
            System.exit(1);
        }
        this.readLexiconOnDemand(uRL);
    }

    public void readLexiconOnDemand(URL uRL) {
        this.lexFilePath = uRL;
        this.readLexiconOnDemand = true;
    }

    public Lexicon demandLexicon() {
        if (this.readLexiconOnDemand && (this.lexicon == null || this.lexicon.size() == 0)) {
            this.readLexicon(this.lexFilePath);
            this.readLexiconOnDemand = false;
        }
        return this.lexicon;
    }

    public static void writeParameters(Parameters parameters, String string) {
        ObjectOutputStream objectOutputStream = null;
        try {
            objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(string)));
        }
        catch (Exception exception) {
            System.err.println("Can't create object output stream in '" + string + "': " + exception);
            System.exit(1);
        }
        try {
            objectOutputStream.writeObject(parameters);
        }
        catch (Exception exception) {
            System.err.println("Can't write to object output stream in '" + string + "': " + exception);
            System.exit(1);
        }
        try {
            objectOutputStream.close();
        }
        catch (Exception exception) {
            System.err.println("Can't close object stream in '" + string + "': " + exception);
            System.exit(1);
        }
    }

    public static Parameters readParameters(URL uRL) {
        ObjectInputStream objectInputStream = null;
        try {
            objectInputStream = new ObjectInputStream(new BufferedInputStream(uRL.openStream()));
        }
        catch (Exception exception) {
            System.err.println("Can't open '" + uRL + "' for input: " + exception);
            System.exit(1);
        }
        Parameters parameters = null;
        try {
            parameters = (Parameters)objectInputStream.readObject();
        }
        catch (Exception exception) {
            System.err.println("Can't read from '" + uRL + "': " + exception);
            System.exit(1);
        }
        try {
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.err.println("Can't close '" + uRL + "': " + exception);
            System.exit(1);
        }
        return parameters;
    }

    public static class Parameters
    implements Serializable {
        public int rounds;

        public Parameters() {
        }

        public Parameters(Parameters parameters) {
        }

        public void setParameters(Learner learner) {
            Class<?> clazz;
            if ((class$LBJ2$learn$Learner == null ? (class$LBJ2$learn$Learner = Learner.class$("LBJ2.learn.Learner")) : class$LBJ2$learn$Learner).equals(clazz = this.getClass())) {
                throw new UnsupportedOperationException("LBJ ERROR: Learner.Parameters.setParameters should never be called.");
            }
            throw new UnsupportedOperationException("LBJ ERROR: " + clazz.getName() + ".Parameters.setParameters has not " + "been implemented.");
        }

        public String nonDefaultString() {
            return "";
        }
    }
}

