/*
 * Decompiled with CFR 0.152.
 */
package LBJ2.learn;

import LBJ2.classify.Feature;
import LBJ2.learn.ChildLexicon;
import LBJ2.util.ByteString;
import LBJ2.util.ClassUtils;
import LBJ2.util.ExceptionlessInputStream;
import LBJ2.util.ExceptionlessOutputStream;
import LBJ2.util.FVector;
import LBJ2.util.IVector;
import LBJ2.util.IVector2D;
import LBJ2.util.Sort;
import LBJ2.util.TableFormat;
import java.io.Serializable;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class Lexicon
implements Cloneable,
Serializable {
    private static final int defaultCapacity = 1024;
    protected Map lexicon;
    protected FVector lexiconInv;
    private String encoding;
    private boolean encodingSet;
    protected IVector featureCounts;
    protected IVector2D perClassFeatureCounts;
    protected int pruneCutoff;
    protected ChildLexicon lexiconChildren;

    public static Lexicon readLexicon(String string) {
        try {
            return Lexicon.readLexicon(new URL("file:" + string));
        }
        catch (Exception exception) {
            System.err.println("Error constructing URL:");
            exception.printStackTrace();
            System.exit(1);
            return null;
        }
    }

    public static Lexicon readLexicon(URL uRL) {
        return Lexicon.readLexicon(uRL, true);
    }

    public static Lexicon readLexicon(URL uRL, boolean bl) {
        ExceptionlessInputStream exceptionlessInputStream = ExceptionlessInputStream.openCompressedStream(uRL);
        Lexicon lexicon = Lexicon.readLexicon(exceptionlessInputStream, bl);
        exceptionlessInputStream.close();
        return lexicon;
    }

    public static Lexicon readLexicon(ExceptionlessInputStream exceptionlessInputStream) {
        return Lexicon.readLexicon(exceptionlessInputStream, true);
    }

    public static Lexicon readLexicon(ExceptionlessInputStream exceptionlessInputStream, boolean bl) {
        String string = exceptionlessInputStream.readString();
        if (string == null) {
            return null;
        }
        Class clazz = ClassUtils.getClass(string);
        Lexicon lexicon = null;
        try {
            lexicon = (Lexicon)clazz.newInstance();
        }
        catch (Exception exception) {
            System.err.println("Can't instantiate '" + string + "': " + exception);
            System.exit(1);
        }
        lexicon.read(exceptionlessInputStream, bl);
        return lexicon;
    }

    public Lexicon() {
        this.clear();
    }

    public Lexicon(String string) {
        this.encoding = string;
        this.encodingSet = true;
        this.clear();
    }

    public void clear() {
        this.lexicon = new HashMap();
        this.lexiconInv = new FVector();
        this.lexiconChildren = null;
        this.pruneCutoff = -1;
    }

    public void setEncoding(String string) {
        if (this.encodingSet && (this.encoding == null ? string != null : !this.encoding.equals(string))) {
            System.err.println("LBJ ERROR: Once established, the encoding of a lexicon cannot be changed.");
            new Exception().printStackTrace();
            System.exit(1);
        }
        this.encoding = string;
        this.encodingSet = true;
    }

    public Map getMap() {
        this.lazyMapCreation();
        return Collections.unmodifiableMap(this.lexicon);
    }

    public int size() {
        return this.lexiconInv.size();
    }

    public int getCutoff() {
        return this.pruneCutoff == -1 ? this.size() : this.pruneCutoff;
    }

    public void countFeatures(CountPolicy countPolicy) {
        this.featureCounts = null;
        this.perClassFeatureCounts = null;
        if (countPolicy == CountPolicy.global) {
            this.featureCounts = new IVector(1024);
        } else if (countPolicy == CountPolicy.perClass) {
            this.perClassFeatureCounts = new IVector2D(8, 1024);
        }
    }

    public CountPolicy getCountPolicy() {
        if (this.featureCounts != null) {
            return CountPolicy.global;
        }
        if (this.perClassFeatureCounts != null) {
            return CountPolicy.perClass;
        }
        return CountPolicy.none;
    }

    public void perClassToGlobalCounts() {
        int n;
        if (this.perClassFeatureCounts == null) {
            throw new IllegalArgumentException("LBJ ERROR: Lexicon.perClassToGlobalCounts: Cannot be called if there are not per-class counts.");
        }
        int n2 = this.perClassFeatureCounts.size();
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            n3 = Math.max(n3, this.perClassFeatureCounts.size(n));
        }
        this.featureCounts = new IVector(1024);
        for (n = 0; n < n3; ++n) {
            int n4 = 0;
            for (int i = 0; i < n2; ++i) {
                n4 += this.perClassFeatureCounts.get(i, n);
            }
            this.featureCounts.set(n, n4);
        }
        this.perClassFeatureCounts = null;
    }

    public boolean contains(Feature feature) {
        this.lazyMapCreation();
        return this.lexicon.containsKey(feature);
    }

    public int lookup(Feature feature) {
        return this.lookup(feature, false, -1);
    }

    public int lookup(Feature feature, boolean bl) {
        return this.lookup(feature, bl, -1);
    }

    public int lookup(Feature feature, boolean bl, int n) {
        if (n < 0) {
            if (bl && this.perClassFeatureCounts != null) {
                throw new IllegalArgumentException("LBJ ERROR: Lexicon.lookup: Must supply a label when training with per class feature counts.");
            }
        } else if (!bl || this.perClassFeatureCounts == null) {
            throw new IllegalArgumentException("LBJ ERROR: Lexicon.lookup: A label has been supplied when not training with per class feature counts.");
        }
        this.lazyMapCreation();
        Integer n2 = (Integer)this.lexicon.get(feature);
        if (n2 == null) {
            Feature feature2;
            if (!bl) {
                return this.getCutoff();
            }
            feature = feature.encode(this.encoding);
            if (this.lexiconChildren != null && (feature2 = this.lexiconChildren.remove(feature)) != null) {
                feature = feature2;
            }
            int n3 = this.lexiconInv.size();
            this.lexicon.put(feature, new Integer(n3));
            this.lexiconInv.add(feature);
            this.incrementCount(n3, n);
            return n3;
        }
        int n4 = n2;
        if (bl) {
            this.incrementCount(n4, n);
        }
        return n4;
    }

    public Feature getChildFeature(Feature feature, int n) {
        this.lazyMapCreation();
        Integer n2 = (Integer)this.lexicon.get(feature);
        if (n2 != null) {
            int n3 = n2;
            this.incrementCount(n3, n);
            return this.lexiconInv.get(n3);
        }
        if (this.lexiconChildren == null) {
            this.lexiconChildren = new ChildLexicon(this);
        }
        return this.lexiconChildren.getChildFeature(feature, -1);
    }

    protected void incrementCount(int n, int n2) {
        if (this.featureCounts != null) {
            this.featureCounts.increment(n);
        } else if (this.perClassFeatureCounts != null) {
            this.perClassFeatureCounts.increment(n2, n);
        }
    }

    public int lookupChild(Feature feature) {
        this.lazyMapCreation();
        Integer n = (Integer)this.lexicon.get(feature);
        if (n != null) {
            return n;
        }
        if (this.lexiconChildren == null) {
            throw new UnsupportedOperationException("When calling Lexicon.lookupChild(Feature), the feature must be present in the lexicon.");
        }
        return -this.lexiconChildren.lookupChild(feature) - 1;
    }

    public Feature lookupKey(int n) {
        if (n < 0) {
            return this.lexiconChildren.lookupKey(-n - 1);
        }
        return this.lexiconInv.get(n);
    }

    public boolean isPruned(int n, PruningPolicy pruningPolicy) {
        return this.isPruned(n, -1, pruningPolicy);
    }

    public boolean isPruned(int n, int n2, PruningPolicy pruningPolicy) {
        if (pruningPolicy.isNone()) {
            return false;
        }
        if (this.featureCounts == null && this.perClassFeatureCounts == null) {
            throw new IllegalArgumentException("LBJ ERROR: Lexicon.isPruned: pruning policy wasn't 'None', but there are no counts.");
        }
        if (this.featureCounts != null) {
            return this.featureCounts.get(n) < pruningPolicy.getThreshold(0);
        }
        if (n2 >= 0) {
            return this.perClassFeatureCounts.get(n2, n) < pruningPolicy.getThreshold(n2);
        }
        for (int i = 0; i < this.perClassFeatureCounts.size(); ++i) {
            if (this.perClassFeatureCounts.get(i, n) < pruningPolicy.getThreshold(i)) continue;
            return false;
        }
        return true;
    }

    public int[] prune(PruningPolicy pruningPolicy) {
        int n;
        int n2;
        if (pruningPolicy.isNone()) {
            this.pruneCutoff = -1;
            return null;
        }
        if (this.featureCounts == null && this.perClassFeatureCounts == null) {
            throw new UnsupportedOperationException("LBJ ERROR: Lexicon.prune: Can't prune if there's no feature counts.");
        }
        if (pruningPolicy.isPercentage()) {
            if (this.featureCounts != null) {
                long l = Math.round(Math.ceil((double)this.featureCounts.max() * pruningPolicy.getPercentage()));
                pruningPolicy.setThresholds(new int[]{(int)l});
            } else {
                int[] nArray = new int[this.perClassFeatureCounts.size()];
                n2 = this.perClassFeatureCounts.size();
                double d = pruningPolicy.getPercentage();
                for (n = 0; n < n2; ++n) {
                    nArray[n] = (int)Math.round(Math.ceil((double)this.perClassFeatureCounts.max(n) * d));
                }
                pruningPolicy.setThresholds(nArray);
            }
        } else if (!pruningPolicy.isAbsolute()) {
            throw new UnsupportedOperationException("LBJ ERROR: Lexicon.prune: Pruning policy '" + pruningPolicy + "' is not supported.");
        }
        this.pruneCutoff = this.size();
        int[] nArray = new int[this.pruneCutoff];
        while (this.pruneCutoff > 0 && this.isPruned(this.pruneCutoff - 1, pruningPolicy)) {
            --this.pruneCutoff;
            nArray[this.pruneCutoff] = this.pruneCutoff;
        }
        if (this.pruneCutoff > 0) {
            nArray[this.pruneCutoff - 1] = this.pruneCutoff - 1;
        }
        for (n2 = this.pruneCutoff - 2; n2 >= 0; --n2) {
            if (this.isPruned(n2, pruningPolicy)) {
                --this.pruneCutoff;
                Feature feature = this.lexiconInv.get(n2);
                Feature feature2 = this.lexiconInv.get(this.pruneCutoff);
                if (this.lexicon != null) {
                    this.lexicon.put(feature, this.lexicon.put(feature2, new Integer(n2)));
                }
                this.lexiconInv.set(n2, feature2);
                this.lexiconInv.set(this.pruneCutoff, feature);
                if (this.featureCounts != null) {
                    this.featureCounts.set(n2, this.featureCounts.set(this.pruneCutoff, this.featureCounts.get(n2)));
                } else {
                    for (n = 0; n < this.perClassFeatureCounts.size(); ++n) {
                        this.perClassFeatureCounts.set(n, n2, this.perClassFeatureCounts.set(n, this.pruneCutoff, this.perClassFeatureCounts.get(n, n2)));
                    }
                }
                nArray[n2] = nArray[this.pruneCutoff];
                nArray[this.pruneCutoff] = n2;
                continue;
            }
            nArray[n2] = n2;
        }
        n2 = 0;
        while (n2 < nArray.length) {
            int n3 = 0;
            int n4 = n2;
            do {
                n = nArray[n4];
                nArray[n4] = -n3;
                n3 = n4;
            } while ((n4 = n) != n2);
            nArray[n2] = n3;
            ++n2;
            while (n2 < nArray.length && nArray[n2] <= 0) {
                nArray[n2] = -nArray[n2];
                ++n2;
            }
        }
        return nArray;
    }

    public void discardPrunedFeatures() {
        if (this.pruneCutoff == -1) {
            return;
        }
        this.featureCounts = null;
        this.perClassFeatureCounts = null;
        for (int i = this.lexiconInv.size() - 1; i >= this.pruneCutoff; --i) {
            Feature feature = this.lexiconInv.remove(i);
            if (this.lexicon == null) continue;
            this.lexicon.remove(feature);
        }
        this.lexiconInv = new FVector(this.lexiconInv);
        this.pruneCutoff = -1;
    }

    public Object clone() {
        Lexicon lexicon = null;
        try {
            lexicon = (Lexicon)super.clone();
        }
        catch (Exception exception) {
            System.err.println("Error cloning Lexicon: " + exception);
            exception.printStackTrace();
            System.exit(1);
        }
        if (this.lexicon != null) {
            lexicon.lexicon = new HashMap();
            lexicon.lexicon.putAll(this.lexicon);
        }
        lexicon.lexiconInv = (FVector)this.lexiconInv.clone();
        if (this.featureCounts != null) {
            lexicon.featureCounts = (IVector)this.featureCounts.clone();
        }
        if (this.perClassFeatureCounts != null) {
            lexicon.perClassFeatureCounts = (IVector2D)this.perClassFeatureCounts.clone();
        }
        if (this.lexiconChildren != null) {
            lexicon.lexiconChildren = (ChildLexicon)this.lexiconChildren.clone();
        }
        return lexicon;
    }

    public boolean equals(Object object) {
        if (!object.getClass().equals(this.getClass())) {
            return false;
        }
        Lexicon lexicon = (Lexicon)object;
        return this.pruneCutoff == lexicon.pruneCutoff && (this.lexicon == null ? lexicon.lexicon == null : ((Object)this.lexicon).equals(lexicon.lexicon)) && (this.featureCounts == null ? lexicon.featureCounts == null : this.featureCounts.equals(lexicon.featureCounts)) && (this.perClassFeatureCounts == null ? lexicon.perClassFeatureCounts == null : this.perClassFeatureCounts.equals(lexicon.perClassFeatureCounts)) && (this.lexiconChildren == null ? lexicon.lexiconChildren == null : this.lexiconChildren.equals(lexicon.lexiconChildren));
    }

    public int hashCode() {
        return this.lexiconInv.hashCode();
    }

    public void write(ExceptionlessOutputStream exceptionlessOutputStream) {
        exceptionlessOutputStream.writeString(this.getClass().getName());
        if (this.lexiconChildren == null) {
            exceptionlessOutputStream.writeString(null);
        } else {
            this.lexiconChildren.write(exceptionlessOutputStream);
        }
        final FVector fVector = this.lexiconInv;
        int[] nArray = new int[fVector.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = i;
        }
        Sort.sort(nArray, new Sort.IntComparator(){

            public int compare(int n, int n2) {
                return fVector.get(n).compareTo(fVector.get(n2));
            }
        });
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        ByteString byteString = null;
        exceptionlessOutputStream.writeInt(nArray.length);
        exceptionlessOutputStream.writeInt(this.pruneCutoff);
        for (int i = 0; i < nArray.length; ++i) {
            Feature feature = fVector.get(nArray[i]);
            string = feature.lexWrite(exceptionlessOutputStream, this, string, string2, string3, string4, byteString);
            string2 = feature.getPackage();
            string3 = feature.getGeneratingClassifier();
            if (feature.hasStringIdentifier()) {
                string4 = feature.getStringIdentifier();
            } else if (feature.hasByteStringIdentifier()) {
                byteString = feature.getByteStringIdentifier();
            }
            exceptionlessOutputStream.writeInt(nArray[i]);
        }
        if (this.featureCounts == null) {
            exceptionlessOutputStream.writeInt(0);
        } else {
            this.featureCounts.write(exceptionlessOutputStream);
        }
        if (this.perClassFeatureCounts == null) {
            exceptionlessOutputStream.writeInt(0);
        } else {
            this.perClassFeatureCounts.write(exceptionlessOutputStream);
        }
    }

    public void read(ExceptionlessInputStream exceptionlessInputStream) {
        this.read(exceptionlessInputStream, true);
    }

    public void read(ExceptionlessInputStream exceptionlessInputStream, boolean bl) {
        this.lexiconChildren = (ChildLexicon)Lexicon.readLexicon(exceptionlessInputStream, bl);
        Class<?> clazz = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        ByteString byteString = null;
        int n = exceptionlessInputStream.readInt();
        this.pruneCutoff = exceptionlessInputStream.readInt();
        this.lexicon = null;
        this.lexiconInv = new FVector(n);
        for (int i = 0; i < n; ++i) {
            Feature feature = Feature.lexReadFeature(exceptionlessInputStream, this, clazz, string, string2, string3, byteString);
            int n2 = exceptionlessInputStream.readInt();
            this.lexiconInv.set(n2, feature);
            clazz = feature.getClass();
            string = feature.getPackage();
            string2 = feature.getGeneratingClassifier();
            if (feature.hasStringIdentifier()) {
                string3 = feature.getStringIdentifier();
                continue;
            }
            if (!feature.hasByteStringIdentifier()) continue;
            byteString = feature.getByteStringIdentifier();
        }
        if (bl) {
            this.featureCounts = new IVector();
            this.featureCounts.read(exceptionlessInputStream);
            if (this.featureCounts.size() == 0) {
                this.featureCounts = null;
            }
            this.perClassFeatureCounts = new IVector2D();
            this.perClassFeatureCounts.read(exceptionlessInputStream);
            if (this.perClassFeatureCounts.size() == 0) {
                this.perClassFeatureCounts = null;
            }
        } else {
            this.featureCounts = null;
            this.perClassFeatureCounts = null;
        }
        if (this.lexiconChildren != null) {
            this.lexiconChildren.setParent(this);
        }
    }

    protected void lazyMapCreation() {
        if (this.lexicon == null) {
            this.lexicon = new HashMap();
            int n = this.lexiconInv.size();
            for (int i = 0; i < n; ++i) {
                this.lexicon.put(this.lexiconInv.get(i), new Integer(i));
            }
        }
    }

    public static int readPrunedSize(ExceptionlessInputStream exceptionlessInputStream) {
        exceptionlessInputStream.readInt();
        return exceptionlessInputStream.readInt();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.lexiconInv.size(); ++i) {
            stringBuffer.append(", ");
            stringBuffer.append(i);
            stringBuffer.append(": ");
            stringBuffer.append(this.lexiconInv.get(i).toString());
        }
        if (this.lexiconInv.size() > 0) {
            return stringBuffer.substring(2);
        }
        return stringBuffer.toString();
    }

    public void printCountTable(boolean bl) {
        int n = this.lexiconInv.size();
        String[] stringArray = new String[n];
        String[] stringArray2 = null;
        double[][] dArray = null;
        int[] nArray = null;
        int[] nArray2 = new int[]{0, this.pruneCutoff};
        if (this.featureCounts != null) {
            dArray = new double[n][2];
            for (int i = 0; i < n; ++i) {
                dArray[i][0] = i;
                dArray[i][1] = this.featureCounts.get(i);
                stringArray[i] = bl ? this.lexiconInv.get(i).toString() : this.lexiconInv.get(i).toStringNoPackage();
            }
            stringArray2 = new String[]{"Index", "Count"};
            nArray = new int[2];
        } else if (this.perClassFeatureCounts != null) {
            int n2;
            int n3 = this.perClassFeatureCounts.size() + 1;
            dArray = new double[n][n3];
            for (n2 = 0; n2 < n; ++n2) {
                dArray[n2][0] = n2;
                for (int i = 0; i < n3 - 1; ++i) {
                    dArray[n2][i + 1] = this.perClassFeatureCounts.get(i, n2);
                }
                stringArray[n2] = bl ? this.lexiconInv.get(n2).toString() : this.lexiconInv.get(n2).toStringNoPackage();
            }
            stringArray2 = new String[n3];
            stringArray2[0] = "Index";
            for (n2 = 1; n2 < n3; ++n2) {
                stringArray2[n2] = "Label " + (n2 - 1);
            }
            nArray = new int[n3];
        } else {
            dArray = new double[n][1];
            for (int i = 0; i < n; ++i) {
                dArray[i][0] = i;
                stringArray[i] = bl ? this.lexiconInv.get(i).toString() : this.lexiconInv.get(i).toStringNoPackage();
            }
            stringArray2 = new String[]{"Index"};
            nArray = new int[1];
        }
        TableFormat.printTableFormat(System.out, stringArray2, stringArray, dArray, nArray, nArray2);
    }

    public static void main(String[] stringArray) {
        String string = null;
        boolean bl = true;
        try {
            string = stringArray[0];
            if (stringArray.length == 2) {
                bl = Boolean.parseBoolean(stringArray[1]);
            }
            if (stringArray.length > 2) {
                throw new Exception();
            }
        }
        catch (Exception exception) {
            System.out.println("usage: java LBJ2.learn.Lexicon <lex file> [<package names = true>]");
            System.exit(1);
        }
        Lexicon lexicon = Lexicon.readLexicon(string);
        lexicon.printCountTable(bl);
        if (lexicon.lexiconChildren != null) {
            System.out.println("\nChildren:");
            lexicon.lexiconChildren.printCountTable(bl);
        }
    }

    public static class PruningPolicy {
        public static final int NONE = 0;
        public static final int ABSOLUTE = 1;
        public static final int PERCENTAGE = 2;
        private static final String[] names = new String[]{"none", "absolute", "percentage"};
        private int index;
        private double percentage;
        private int[] thresholds;

        public PruningPolicy() {
            this.index = 0;
        }

        public PruningPolicy(double d) {
            this.index = 2;
            this.percentage = d;
        }

        public PruningPolicy(int n) {
            this.index = 1;
            this.thresholds = new int[]{n};
        }

        public boolean isNone() {
            return this.index == 0;
        }

        public boolean isAbsolute() {
            return this.index == 1;
        }

        public boolean isPercentage() {
            return this.index == 2;
        }

        public void setThresholds(int[] nArray) {
            if (this.index != 2) {
                throw new UnsupportedOperationException("LBJ ERROR: Lexicon.PruningPolicy.setThresholds should not be called unless the policy is 'Percentage'.");
            }
            this.thresholds = (int[])nArray.clone();
        }

        public int getThreshold(int n) {
            if (this.index == 0) {
                throw new UnsupportedOperationException("LBJ ERROR: Lexicon.PruningPolicy.getThreshold should never be called if the pruning policy is 'None'.");
            }
            if (this.index == 1) {
                return this.thresholds[0];
            }
            return this.thresholds[n];
        }

        public double getPercentage() {
            if (this.index != 2) {
                throw new UnsupportedOperationException("LBJ ERROR: PruningPolicy: Can't get percentage when pruning policy isn't 'Percentage'.");
            }
            return this.percentage;
        }

        public String toString() {
            String string = names[this.index];
            if (this.index == 2) {
                string = string + "(" + this.percentage + ")";
            }
            if (this.index != 0 && this.thresholds != null) {
                string = string + ": [";
                for (int i = 0; i < this.thresholds.length; ++i) {
                    string = string + this.thresholds[i] + (i + 1 < this.thresholds.length ? ", " : "");
                }
                string = string + "]";
            }
            return string;
        }
    }

    public static class CountPolicy {
        public static final CountPolicy none = new CountPolicy(0);
        public static final CountPolicy global = new CountPolicy(1);
        public static final CountPolicy perClass = new CountPolicy(2);
        private static final String[] names = new String[]{"none", "global", "per class"};
        private int index;

        private CountPolicy(int n) {
            this.index = n;
        }

        public String toString() {
            return names[this.index];
        }
    }
}

