/*
 * Decompiled with CFR 0.152.
 */
package LBJ2.learn;

import LBJ2.learn.Lexicon;
import LBJ2.learn.SparseWeightVector;
import LBJ2.util.ExceptionlessInputStream;
import LBJ2.util.ExceptionlessOutputStream;
import java.io.PrintStream;
import java.util.Random;

public class RandomWeightVector
extends SparseWeightVector {
    private static int instanceCount = 0;
    protected static final double defaultStddev = 100.0;
    protected double stddev;
    protected int instanceNumber;
    protected Random random;

    public RandomWeightVector() {
        this(100.0);
    }

    public RandomWeightVector(double d) {
        this.stddev = d;
        this.instanceNumber = instanceCount++;
        this.random = new Random(this.instanceNumber);
    }

    public double getWeight(int n, double d) {
        while (this.weights.size() <= n) {
            this.weights.add(this.random.nextGaussian() * this.stddev);
        }
        return this.weights.get(n);
    }

    public void clear() {
        super.clear();
        this.random = new Random(this.instanceNumber);
    }

    public void write(PrintStream printStream) {
        printStream.println("Begin RandomWeightVector (" + this.stddev + ")");
        this.toStringJustWeights(printStream);
        printStream.println("End RandomWeightVector");
    }

    public void write(PrintStream printStream, Lexicon lexicon) {
        printStream.println("Begin RandomWeightVector (" + this.stddev + ")");
        this.toStringJustWeights(printStream, 0, lexicon);
        printStream.println("End RandomWeightVector");
    }

    public void write(ExceptionlessOutputStream exceptionlessOutputStream) {
        super.write(exceptionlessOutputStream);
        exceptionlessOutputStream.writeDouble(this.stddev);
        exceptionlessOutputStream.writeInt(this.instanceNumber);
    }

    public void read(ExceptionlessInputStream exceptionlessInputStream) {
        super.read(exceptionlessInputStream);
        this.stddev = exceptionlessInputStream.readDouble();
        this.instanceNumber = exceptionlessInputStream.readInt();
        this.random = new Random(this.instanceNumber);
    }

    public SparseWeightVector emptyClone() {
        return new RandomWeightVector(this.stddev);
    }
}

