/*
 * Decompiled with CFR 0.152.
 */
package LBJ2.nlp;

import LBJ2.parse.Parser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;

public class WordsInDocumentByDirectory
implements Parser {
    protected List files;
    protected int filesIndex;

    public WordsInDocumentByDirectory(String string) {
        this(string, null);
    }

    public WordsInDocumentByDirectory(String string, String[] stringArray) {
        this(string, stringArray, true);
    }

    public WordsInDocumentByDirectory(String string, String[] stringArray, boolean bl) {
        this(string, stringArray, true, -1L);
    }

    public WordsInDocumentByDirectory(String string, String[] stringArray, boolean bl, long l) {
        File file = new File(string);
        if (!file.exists() || !file.isDirectory()) {
            System.err.println("Error: '" + string + "' does not exist or is not a directory.");
            new Exception().printStackTrace();
            System.exit(1);
        }
        Object[] objectArray = stringArray == null ? new String[]{} : stringArray;
        Arrays.sort(objectArray);
        File[] fileArray = file.listFiles(new FileFilter((String[])objectArray){
            private final /* synthetic */ String[] val$e;
            {
                this.val$e = stringArray;
            }

            public boolean accept(File file) {
                return file.isDirectory() && Arrays.binarySearch(this.val$e, file.getName()) < 0;
            }
        });
        this.files = new ArrayList();
        for (int i = 0; i < fileArray.length; ++i) {
            File[] fileArray2 = fileArray[i].listFiles(new FileFilter(){

                public boolean accept(File file) {
                    return file.isFile();
                }
            });
            for (int j = 0; j < fileArray2.length; ++j) {
                this.files.add(fileArray2[j]);
            }
        }
        if (bl) {
            Random random = l < 0L ? new Random() : new Random(l);
            Collections.shuffle(this.files, random);
        }
    }

    public void reset() {
        this.filesIndex = 0;
    }

    public Object next() {
        if (this.filesIndex == this.files.size()) {
            return null;
        }
        File file = (File)this.files.get(this.filesIndex++);
        String string = file.getAbsolutePath();
        int n = string.lastIndexOf(File.separatorChar);
        string = string.substring(string.lastIndexOf(File.separatorChar, n - 1) + 1, n);
        return WordsInDocumentByDirectory.fileToArray(file, string);
    }

    public void close() {
    }

    public static String[] fileToArray(File file, String string) {
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add(string);
        BufferedReader bufferedReader = WordsInDocumentByDirectory.openReader(file);
        String string2 = WordsInDocumentByDirectory.readLine(bufferedReader, file);
        while (string2 != null) {
            String[] stringArray = string2.split("\\s+");
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].matches("^\\s*$")) continue;
                linkedList.add(stringArray[i]);
            }
            string2 = WordsInDocumentByDirectory.readLine(bufferedReader, file);
        }
        WordsInDocumentByDirectory.closeReader(bufferedReader, file);
        return linkedList.toArray(new String[linkedList.size()]);
    }

    static BufferedReader openReader(File file) {
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
        }
        catch (Exception exception) {
            System.err.println("Can't open '" + file + "' for input: " + exception);
            System.exit(1);
        }
        return bufferedReader;
    }

    static String readLine(BufferedReader bufferedReader, File file) {
        String string = null;
        try {
            string = bufferedReader.readLine();
        }
        catch (Exception exception) {
            System.err.println("Can't read from '" + file + "': " + exception);
            System.exit(1);
        }
        return string;
    }

    static void closeReader(BufferedReader bufferedReader, File file) {
        try {
            bufferedReader.close();
        }
        catch (Exception exception) {
            System.err.println("Can't close input file '" + file + "': " + exception);
            System.exit(1);
        }
    }
}

