/*
 * Decompiled with CFR 0.152.
 */
package LBJ2.parse;

import LBJ2.classify.Feature;
import LBJ2.classify.FeatureVector;
import LBJ2.parse.FoldSeparator;
import LBJ2.parse.Parser;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.ObjectInputStream;

public class FeatureVectorParser
implements Parser {
    protected DataInputStream in;
    protected String exampleFileName;
    protected Feature[] lexicon;

    protected FeatureVectorParser(String string) {
        this.exampleFileName = string;
        try {
            this.in = new DataInputStream(new BufferedInputStream(new FileInputStream(this.exampleFileName)));
        }
        catch (Exception exception) {
            System.err.println("Can't open '" + this.exampleFileName + "' for input:");
            exception.printStackTrace();
            System.exit(1);
        }
    }

    public FeatureVectorParser(String string, Feature[] featureArray) {
        this(string);
        this.lexicon = featureArray;
    }

    public FeatureVectorParser(String string, String string2) {
        this(string);
        ObjectInputStream objectInputStream = null;
        try {
            objectInputStream = new ObjectInputStream(new FileInputStream(string2));
        }
        catch (Exception exception) {
            System.err.println("Can't open '" + string2 + "' for input:");
            exception.printStackTrace();
            System.exit(1);
        }
        try {
            this.lexicon = (Feature[])objectInputStream.readObject();
        }
        catch (Exception exception) {
            System.err.println("Can't read from '" + string2 + "':");
            exception.printStackTrace();
            System.exit(1);
        }
        try {
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.err.println("Can't close '" + string2 + "':");
            exception.printStackTrace();
            System.exit(1);
        }
    }

    public Object next() {
        FeatureVector featureVector = new FeatureVector();
        try {
            int n;
            int n2 = this.in.readInt();
            if (n2 == -1) {
                return FoldSeparator.separator;
            }
            for (n = 0; n < n2; ++n) {
                featureVector.addLabel(this.lexicon[this.in.readInt()]);
            }
            n2 = this.in.readInt();
            for (n = 0; n < n2; ++n) {
                featureVector.addFeature(this.lexicon[this.in.readInt()]);
            }
        }
        catch (EOFException eOFException) {
            featureVector = null;
            this.close();
        }
        catch (Exception exception) {
            System.err.println("Can't read from '" + this.exampleFileName + "':");
            exception.printStackTrace();
            System.exit(1);
        }
        return featureVector;
    }

    public void reset() {
        try {
            this.in = new DataInputStream(new BufferedInputStream(new FileInputStream(this.exampleFileName)));
        }
        catch (Exception exception) {
            System.err.println("Can't open '" + this.exampleFileName + "' for input:");
            exception.printStackTrace();
            System.exit(1);
        }
    }

    public static void main(String[] stringArray) {
        String string = null;
        String string2 = null;
        try {
            string = stringArray[0];
            string2 = stringArray[1];
            if (stringArray.length > 2) {
                throw new Exception();
            }
        }
        catch (Exception exception) {
            System.err.println("usage: java LBJ2.parse.FeatureVectorParser <example file> <lexicon file>");
            System.exit(1);
        }
        FeatureVectorParser featureVectorParser = new FeatureVectorParser(string, string2);
        FeatureVector featureVector = (FeatureVector)featureVectorParser.next();
        while (featureVector != null) {
            featureVector.sort();
            System.out.println(featureVector);
            featureVector = (FeatureVector)featureVectorParser.next();
        }
    }

    public void close() {
        if (this.in == null) {
            return;
        }
        try {
            this.in.close();
        }
        catch (Exception exception) {
            System.err.println("Can't close '" + this.exampleFileName + "':");
            exception.printStackTrace();
            System.exit(1);
        }
    }
}

