/*
 * Decompiled with CFR 0.152.
 */
package LBJ2.util;

import LBJ2.util.ExceptionlessInputStream;
import LBJ2.util.ExceptionlessOutputStream;
import java.io.Serializable;
import java.util.Arrays;

public class DVector
implements Cloneable,
Serializable {
    protected static final int defaultCapacity = 8;
    protected double[] vector;
    protected int size;

    public DVector() {
        this(8);
    }

    public DVector(int n) {
        this.vector = new double[Math.max(8, n)];
    }

    public DVector(double[] dArray) {
        if (dArray.length == 0) {
            this.vector = new double[8];
        } else {
            this.vector = dArray;
            this.size = this.vector.length;
        }
    }

    protected void boundsCheck(int n) {
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("Attempted to access negative index of DVector.");
        }
    }

    public double get(int n) {
        return this.get(n, 0.0);
    }

    public double get(int n, double d) {
        this.boundsCheck(n);
        return n < this.size ? this.vector[n] : d;
    }

    public double set(int n, double d) {
        return this.set(n, d, 0.0);
    }

    public double set(int n, double d, double d2) {
        this.boundsCheck(n);
        this.expandFor(n, d2);
        double d3 = this.vector[n];
        this.vector[n] = d;
        return d3;
    }

    public void add(double d) {
        this.expandFor(this.size, 0.0);
        this.vector[this.size - 1] = d;
    }

    public void addAll(DVector dVector) {
        this.expandFor(this.size + dVector.size - 1, 0.0);
        System.arraycopy(dVector.vector, 0, this.vector, this.size - dVector.size, dVector.size);
    }

    public double remove(int n) {
        this.boundsCheck(n);
        if (n >= this.size) {
            throw new ArrayIndexOutOfBoundsException("LBJ: DVector: Can't remove element at index " + n + " as it is larger than the size (" + this.size + ")");
        }
        double d = this.vector[n];
        for (int i = n + 1; i < this.size; ++i) {
            this.vector[i - 1] = this.vector[i];
        }
        --this.size;
        return d;
    }

    public int size() {
        return this.size;
    }

    public double max() {
        double d = -1.7976931348623157E308;
        for (int i = 0; i < this.size; ++i) {
            if (!(this.vector[i] > d)) continue;
            d = this.vector[i];
        }
        return d;
    }

    public void sort() {
        Arrays.sort(this.vector, 0, this.size);
    }

    public int binarySearch(double d) {
        int n = 0;
        int n2 = this.size;
        while (n2 != n) {
            int n3 = n + n2 >> 1;
            if (this.vector[n3] > d) {
                n2 = n3;
                continue;
            }
            if (this.vector[n3] < d) {
                n = n3 + 1;
                continue;
            }
            return n3;
        }
        return -n - 1;
    }

    protected void expandFor(int n, double d) {
        int n2;
        if (n < this.size) {
            return;
        }
        int n3 = this.size;
        this.size = n + 1;
        if (n2 >= this.size) {
            return;
        }
        for (n2 = this.vector.length; n2 < this.size; n2 *= 2) {
        }
        double[] dArray = new double[n2];
        System.arraycopy(this.vector, 0, dArray, 0, n3);
        if (d != 0.0) {
            Arrays.fill(dArray, n3, this.size, d);
        }
        this.vector = dArray;
    }

    public double[] toArray() {
        double[] dArray = new double[this.size];
        System.arraycopy(this.vector, 0, dArray, 0, this.size);
        return dArray;
    }

    public boolean equals(Object object) {
        if (!(object instanceof DVector)) {
            return false;
        }
        DVector dVector = (DVector)object;
        return this.size == dVector.size && Arrays.equals(this.vector, dVector.vector);
    }

    public int hashCode() {
        return this.vector.hashCode();
    }

    public Object clone() {
        DVector dVector = null;
        try {
            dVector = (DVector)super.clone();
        }
        catch (Exception exception) {
            System.err.println("Error cloning " + this.getClass().getName() + ":");
            exception.printStackTrace();
            System.exit(1);
        }
        dVector.vector = (double[])this.vector.clone();
        return dVector;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        for (int i = 0; i < this.size; ++i) {
            stringBuffer.append(this.vector[i]);
            if (i + 1 >= this.size) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public void write(ExceptionlessOutputStream exceptionlessOutputStream) {
        exceptionlessOutputStream.writeInt(this.size);
        for (int i = 0; i < this.size; ++i) {
            exceptionlessOutputStream.writeDouble(this.vector[i]);
        }
    }

    public void read(ExceptionlessInputStream exceptionlessInputStream) {
        this.size = exceptionlessInputStream.readInt();
        if (this.size == 0) {
            this.vector = new double[8];
        } else {
            this.vector = new double[this.size];
            for (int i = 0; i < this.size; ++i) {
                this.vector[i] = exceptionlessInputStream.readDouble();
            }
        }
    }
}

