/*
 * Decompiled with CFR 0.152.
 */
package LBJ2.util;

import LBJ2.util.ExceptionlessInputStream;
import LBJ2.util.ExceptionlessOutputStream;
import LBJ2.util.IVector;
import java.io.Serializable;
import java.util.Arrays;

public class DVector2D
implements Cloneable,
Serializable {
    protected static final int defaultCapacity1 = 8;
    protected static final int defaultDefaultCapacity2 = 8;
    protected double[][] vector;
    protected IVector sizes;
    protected int defaultCapacity2;

    public DVector2D() {
        this(8, 8);
    }

    public DVector2D(int n, int n2) {
        this.defaultCapacity2 = Math.max(8, n2);
        this.vector = new double[Math.max(8, n)][this.defaultCapacity2];
        this.sizes = new IVector(n);
    }

    public DVector2D(double[][] dArray) {
        this.defaultCapacity2 = 8;
        if (dArray.length == 0) {
            this.vector = new double[8][this.defaultCapacity2];
            this.sizes = new IVector(8);
        } else {
            int n;
            this.vector = dArray;
            this.sizes = new IVector(dArray.length);
            for (n = 0; n < dArray.length; ++n) {
                this.sizes.set(n, dArray[n].length);
                this.defaultCapacity2 = Math.max(this.defaultCapacity2, dArray[n].length);
            }
            for (n = 0; n < dArray.length; ++n) {
                if (dArray[n].length != 0) continue;
                dArray[n] = new double[this.defaultCapacity2];
            }
        }
    }

    protected void boundsCheck(int n, int n2) {
        if (n < 0 || n2 < 0) {
            throw new ArrayIndexOutOfBoundsException("Attempted to access negative index of DVector2D.");
        }
    }

    public double get(int n, int n2) {
        return this.get(n, n2, 0.0);
    }

    public double get(int n, int n2, double d) {
        this.boundsCheck(n, n2);
        return n2 < this.sizes.get(n) ? this.vector[n][n2] : d;
    }

    public double set(int n, int n2, double d) {
        return this.set(n, n2, d, 0.0);
    }

    public double set(int n, int n2, double d, double d2) {
        this.boundsCheck(n, n2);
        this.expandFor(n, n2, d2);
        double d3 = this.vector[n][n2];
        this.vector[n][n2] = d;
        return d3;
    }

    public double[] remove(int n) {
        this.boundsCheck(n, 0);
        int n2 = this.sizes.size();
        if (n >= n2) {
            throw new ArrayIndexOutOfBoundsException("LBJ: DVector2D: Can't remove row at index " + n + " as it is larger than the size (" + n2 + ")");
        }
        double[] dArray = this.vector[n];
        for (int i = n + 1; i < n2; ++i) {
            this.vector[i - 1] = this.vector[i];
        }
        this.vector[n2 - 1] = null;
        this.sizes.remove(n);
        return dArray;
    }

    public double remove(int n, int n2) {
        this.boundsCheck(n, n2);
        int n3 = this.sizes.size();
        int n4 = this.sizes.get(n);
        if (n >= n3 || n2 >= n4) {
            throw new ArrayIndexOutOfBoundsException("LBJ: DVector2D: Can't remove index [" + n + ", " + n2 + "] as it is out of bounds (" + n3 + ", " + n4 + ")");
        }
        double d = this.vector[n][n2];
        for (int i = n2 + 1; i < n4; ++i) {
            this.vector[n][i - 1] = this.vector[n][i];
        }
        this.sizes.set(n, n4 - 1);
        return d;
    }

    public int size() {
        return this.sizes.size();
    }

    public int size(int n) {
        return this.sizes.get(n);
    }

    public double max(int n) {
        if (n < 0 || n >= this.sizes.size()) {
            throw new ArrayIndexOutOfBoundsException("Attempted to access negative index of DVector2D.");
        }
        double d = -1.7976931348623157E308;
        int n2 = this.sizes.get(n);
        for (int i = 0; i < n2; ++i) {
            if (!(this.vector[n][i] > d)) continue;
            d = this.vector[n][i];
        }
        return d;
    }

    public void sort(int n) {
        Arrays.sort(this.vector[n], 0, this.sizes.get(n));
    }

    public int binarySearch(int n, int n2) {
        int n3 = 0;
        int n4 = this.sizes.get(n);
        while (n4 != n3) {
            int n5 = n3 + n4 >> 1;
            if (this.vector[n][n5] > (double)n2) {
                n4 = n5;
                continue;
            }
            if (this.vector[n][n5] < (double)n2) {
                n3 = n5 + 1;
                continue;
            }
            return n5;
        }
        return -n3 - 1;
    }

    protected void expandFor(int n, int n2, double d) {
        int n3;
        int n4;
        if (n >= this.sizes.size()) {
            n4 = this.sizes.size();
            this.sizes.set(n, 0);
            if (n3 < this.sizes.size()) {
                for (n3 = this.vector.length; n3 < this.sizes.size(); n3 *= 2) {
                }
                double[][] dArrayArray = new double[n3][];
                System.arraycopy(this.vector, 0, dArrayArray, 0, n4);
                this.vector = dArrayArray;
            }
            for (int i = n4; i < this.sizes.size(); ++i) {
                this.vector[i] = new double[this.defaultCapacity2];
            }
        }
        if (n2 < this.sizes.get(n)) {
            return;
        }
        n4 = this.sizes.get(n);
        this.sizes.set(n, n2 + 1);
        if (n3 >= this.sizes.get(n)) {
            return;
        }
        for (n3 = this.vector[n].length; n3 < this.sizes.get(n); n3 *= 2) {
        }
        double[] dArray = new double[n3];
        System.arraycopy(this.vector[n], 0, dArray, 0, n4);
        if (d != 0.0) {
            Arrays.fill(dArray, n4, this.sizes.get(n), d);
        }
        this.vector[n] = dArray;
    }

    public double[][] toArray() {
        double[][] dArrayArray = new double[this.sizes.size()][];
        for (int i = 0; i < dArrayArray.length; ++i) {
            dArrayArray[i] = new double[this.sizes.get(i)];
            System.arraycopy(this.vector[i], 0, dArrayArray[i], 0, dArrayArray[i].length);
        }
        return dArrayArray;
    }

    public boolean equals(Object object) {
        if (!(object instanceof DVector2D)) {
            return false;
        }
        DVector2D dVector2D = (DVector2D)object;
        if (this.vector.length != dVector2D.vector.length || !this.sizes.equals(dVector2D.sizes)) {
            return false;
        }
        for (int i = 0; i < this.vector.length; ++i) {
            if (Arrays.equals(this.vector[i], dVector2D.vector[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = this.vector.hashCode();
        for (int i = 0; i < this.vector.length; ++i) {
            n = 17 * n + this.vector[i].hashCode();
        }
        return n;
    }

    public Object clone() {
        DVector2D dVector2D = null;
        try {
            dVector2D = (DVector2D)super.clone();
        }
        catch (Exception exception) {
            System.err.println("Error cloning " + this.getClass().getName() + ":");
            exception.printStackTrace();
            System.exit(1);
        }
        dVector2D.vector = (double[][])this.vector.clone();
        for (int i = 0; i < this.vector.length; ++i) {
            if (dVector2D.vector[i] == null) continue;
            dVector2D.vector[i] = (double[])this.vector[i].clone();
        }
        return dVector2D;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        int n = this.sizes.size();
        for (int i = 0; i < n; ++i) {
            int n2 = this.sizes.get(i);
            stringBuffer.append("[");
            for (int j = 0; j < n2; ++j) {
                stringBuffer.append(this.vector[i][j]);
                if (j + 1 >= n2) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append("]");
            if (i + 1 >= n) continue;
            stringBuffer.append(",\n ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public void write(ExceptionlessOutputStream exceptionlessOutputStream) {
        this.sizes.write(exceptionlessOutputStream);
        for (int i = 0; i < this.sizes.size(); ++i) {
            for (int j = 0; j < this.sizes.get(i); ++j) {
                exceptionlessOutputStream.writeDouble(this.vector[i][j]);
            }
        }
        exceptionlessOutputStream.writeInt(this.defaultCapacity2);
    }

    public void read(ExceptionlessInputStream exceptionlessInputStream) {
        this.sizes = new IVector();
        this.sizes.read(exceptionlessInputStream);
        if (this.sizes.size() == 0) {
            this.defaultCapacity2 = 8;
            this.vector = new double[8][this.defaultCapacity2];
        } else {
            this.vector = new double[this.sizes.size()][];
            for (int i = 0; i < this.vector.length; ++i) {
                this.vector[i] = new double[this.sizes.get(i)];
                for (int j = 0; j < this.vector[i].length; ++j) {
                    this.vector[i][j] = exceptionlessInputStream.readDouble();
                }
            }
            this.defaultCapacity2 = exceptionlessInputStream.readInt();
        }
    }
}

