/*
 * Decompiled with CFR 0.152.
 */
package LBJ2.util;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public class ExceptionlessInputStream
extends FilterInputStream {
    public static final String zipEntryName = "LBJFile";
    private byte[] buffer = null;
    private char[] chars = null;
    private DataInputStream dis = (DataInputStream)this.in;

    public static ExceptionlessInputStream openBufferedStream(String string) {
        ExceptionlessInputStream exceptionlessInputStream = null;
        try {
            exceptionlessInputStream = new ExceptionlessInputStream(new BufferedInputStream(new FileInputStream(string)));
        }
        catch (Exception exception) {
            System.err.println("Can't open '" + string + "' for input:");
            exception.printStackTrace();
            System.exit(1);
        }
        return exceptionlessInputStream;
    }

    public static ExceptionlessInputStream openCompressedStream(String string) {
        ExceptionlessInputStream exceptionlessInputStream = null;
        try {
            ZipFile zipFile = new ZipFile(string);
            exceptionlessInputStream = new ExceptionlessInputStream(new BufferedInputStream(zipFile.getInputStream(zipFile.getEntry(zipEntryName))));
        }
        catch (Exception exception) {
            System.err.println("Can't open '" + string + "' for input:");
            exception.printStackTrace();
            System.exit(1);
        }
        return exceptionlessInputStream;
    }

    public static ExceptionlessInputStream openBufferedStream(URL uRL) {
        ExceptionlessInputStream exceptionlessInputStream = null;
        try {
            exceptionlessInputStream = new ExceptionlessInputStream(new BufferedInputStream(uRL.openStream()));
        }
        catch (Exception exception) {
            System.err.println("Can't open '" + uRL + "' for input:");
            exception.printStackTrace();
            System.exit(1);
        }
        return exceptionlessInputStream;
    }

    public static ExceptionlessInputStream openCompressedStream(URL uRL) {
        if (uRL.getProtocol().equals("file")) {
            return ExceptionlessInputStream.openCompressedStream(uRL.getFile());
        }
        ExceptionlessInputStream exceptionlessInputStream = null;
        try {
            ZipInputStream zipInputStream = new ZipInputStream(uRL.openStream());
            zipInputStream.getNextEntry();
            exceptionlessInputStream = new ExceptionlessInputStream(new BufferedInputStream(zipInputStream));
        }
        catch (Exception exception) {
            System.err.println("Can't open '" + uRL + "' for input:");
            exception.printStackTrace();
            System.exit(1);
        }
        return exceptionlessInputStream;
    }

    public ExceptionlessInputStream(InputStream inputStream) {
        super(new DataInputStream(inputStream));
    }

    private void handleException(Exception exception) {
        System.err.println("Can't read from input stream:");
        exception.printStackTrace();
        this.close();
        System.exit(1);
    }

    public void close() {
        try {
            this.dis.close();
        }
        catch (Exception exception) {
            System.err.println("Can't close input stream:");
            exception.printStackTrace();
            System.exit(1);
        }
    }

    public boolean readBoolean() {
        try {
            return this.dis.readBoolean();
        }
        catch (Exception exception) {
            this.handleException(exception);
            return false;
        }
    }

    public byte readByte() {
        try {
            return this.dis.readByte();
        }
        catch (Exception exception) {
            this.handleException(exception);
            return 0;
        }
    }

    public byte[] readBytes() {
        try {
            int n = this.dis.readInt();
            if (n < 0) {
                return null;
            }
            byte[] byArray = new byte[n];
            for (int i = 0; i < n; ++i) {
                byArray[i] = this.dis.readByte();
            }
            return byArray;
        }
        catch (Exception exception) {
            this.handleException(exception);
            return null;
        }
    }

    public int readUnsignedByte() {
        try {
            return this.dis.readByte();
        }
        catch (Exception exception) {
            this.handleException(exception);
            return 0;
        }
    }

    public short readShort() {
        try {
            return this.dis.readShort();
        }
        catch (Exception exception) {
            this.handleException(exception);
            return 0;
        }
    }

    public int readUnsignedShort() {
        try {
            return this.dis.readUnsignedShort();
        }
        catch (Exception exception) {
            this.handleException(exception);
            return 0;
        }
    }

    public char readChar() {
        try {
            return this.dis.readChar();
        }
        catch (Exception exception) {
            this.handleException(exception);
            return '\u0000';
        }
    }

    public int readInt() {
        try {
            return this.dis.readInt();
        }
        catch (Exception exception) {
            this.handleException(exception);
            return 0;
        }
    }

    public long readLong() {
        try {
            return this.dis.readLong();
        }
        catch (Exception exception) {
            this.handleException(exception);
            return 0L;
        }
    }

    public float readFloat() {
        try {
            return this.dis.readFloat();
        }
        catch (Exception exception) {
            this.handleException(exception);
            return 0.0f;
        }
    }

    public double readDouble() {
        try {
            return this.dis.readDouble();
        }
        catch (Exception exception) {
            this.handleException(exception);
            return 0.0;
        }
    }

    public String readString() {
        short s = this.readShort();
        if (s == -1) {
            return null;
        }
        String string = this.readUTF(s);
        return string;
    }

    public String readUTF(int n) {
        int n2;
        if (this.buffer == null || this.buffer.length < n) {
            this.buffer = new byte[n * 2];
            this.chars = new char[n * 2];
        }
        int n3 = 0;
        int n4 = 0;
        try {
            this.dis.readFully(this.buffer, 0, n);
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
        while (n3 < n && (n2 = this.buffer[n3] & 0xFF) <= 127) {
            ++n3;
            this.chars[n4++] = (char)n2;
        }
        block8: while (n3 < n) {
            n2 = this.buffer[n3] & 0xFF;
            switch (n2 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++n3;
                    this.chars[n4++] = (char)n2;
                    continue block8;
                }
                case 12: 
                case 13: {
                    byte by;
                    if ((n3 += 2) > n) {
                        System.err.println("Error in UTF formatting: partial character at end");
                        new Exception().printStackTrace();
                        this.close();
                        System.exit(1);
                    }
                    if (((by = this.buffer[n3 - 1]) & 0xC0) != 128) {
                        System.err.println("Error in UTF formatting: malformed input around byte " + n3);
                        new Exception().printStackTrace();
                        this.close();
                        System.exit(1);
                    }
                    this.chars[n4++] = (char)((n2 & 0x1F) << 6 | by & 0x3F);
                    continue block8;
                }
                case 14: {
                    if ((n3 += 3) > n) {
                        System.err.println("Error in UTF formatting: partial character at end");
                        new Exception().printStackTrace();
                        this.close();
                        System.exit(1);
                    }
                    byte by = this.buffer[n3 - 2];
                    byte by2 = this.buffer[n3 - 1];
                    if ((by & 0xC0) != 128 || (by2 & 0xC0) != 128) {
                        System.err.println("Error in UTF formatting: malformed input around byte " + (n3 - 1));
                        new Exception().printStackTrace();
                        this.close();
                        System.exit(1);
                    }
                    this.chars[n4++] = (char)((n2 & 0xF) << 12 | (by & 0x3F) << 6 | (by2 & 0x3F) << 0);
                    continue block8;
                }
            }
            System.err.println("Error in UTF formatting: malformed input around byte " + n3);
            new Exception().printStackTrace();
            this.close();
            System.exit(1);
        }
        return new String(this.chars, 0, n4);
    }
}

