/*
 * Decompiled with CFR 0.152.
 */
package LBJ2.util;

import LBJ2.util.ExceptionlessInputStream;
import LBJ2.util.ExceptionlessOutputStream;
import LBJ2.util.IVector;
import java.io.Serializable;
import java.util.Arrays;

public class IVector2D
implements Cloneable,
Serializable {
    protected static final int defaultCapacity1 = 8;
    protected static final int defaultDefaultCapacity2 = 8;
    protected int[][] vector;
    protected IVector sizes;
    protected int defaultCapacity2;

    public IVector2D() {
        this(8, 8);
    }

    public IVector2D(int n, int n2) {
        this.defaultCapacity2 = Math.max(8, n2);
        this.vector = new int[Math.max(8, n)][this.defaultCapacity2];
        this.sizes = new IVector(n);
    }

    public IVector2D(int[][] nArray) {
        this.defaultCapacity2 = 8;
        if (nArray.length == 0) {
            this.vector = new int[8][this.defaultCapacity2];
            this.sizes = new IVector(8);
        } else {
            int n;
            this.vector = nArray;
            this.sizes = new IVector(nArray.length);
            for (n = 0; n < nArray.length; ++n) {
                this.sizes.set(n, nArray[n].length);
                this.defaultCapacity2 = Math.max(this.defaultCapacity2, nArray[n].length);
            }
            for (n = 0; n < nArray.length; ++n) {
                if (nArray[n].length != 0) continue;
                nArray[n] = new int[this.defaultCapacity2];
            }
        }
    }

    protected void boundsCheck(int n, int n2) {
        if (n < 0 || n2 < 0) {
            throw new ArrayIndexOutOfBoundsException("Attempted to access negative index of IVector2D.");
        }
    }

    public int get(int n, int n2) {
        return this.get(n, n2, 0);
    }

    public int get(int n, int n2, int n3) {
        this.boundsCheck(n, n2);
        return n2 < this.sizes.get(n) ? this.vector[n][n2] : n3;
    }

    public int set(int n, int n2, int n3) {
        return this.set(n, n2, n3, 0);
    }

    public int set(int n, int n2, int n3, int n4) {
        this.boundsCheck(n, n2);
        this.expandFor(n, n2, n4);
        int n5 = this.vector[n][n2];
        this.vector[n][n2] = n3;
        return n5;
    }

    public int[] remove(int n) {
        this.boundsCheck(n, 0);
        int n2 = this.sizes.size();
        if (n >= n2) {
            throw new ArrayIndexOutOfBoundsException("LBJ: IVector2D: Can't remove row at index " + n + " as it is larger than the size (" + n2 + ")");
        }
        int[] nArray = this.vector[n];
        for (int i = n + 1; i < n2; ++i) {
            this.vector[i - 1] = this.vector[i];
        }
        this.vector[n2 - 1] = null;
        this.sizes.remove(n);
        return nArray;
    }

    public int remove(int n, int n2) {
        this.boundsCheck(n, n2);
        int n3 = this.sizes.size();
        int n4 = this.sizes.get(n);
        if (n >= n3 || n2 >= n4) {
            throw new ArrayIndexOutOfBoundsException("LBJ: IVector2D: Can't remove index [" + n + ", " + n2 + "] as it is out of bounds (" + n3 + ", " + n4 + ")");
        }
        int n5 = this.vector[n][n2];
        for (int i = n2 + 1; i < n4; ++i) {
            this.vector[n][i - 1] = this.vector[n][i];
        }
        this.sizes.set(n, n4 - 1);
        return n5;
    }

    public void increment(int n, int n2) {
        this.increment(n, n2, 0);
    }

    public void increment(int n, int n2, int n3) {
        this.boundsCheck(n, n2);
        this.expandFor(n, n2, n3);
        int[] nArray = this.vector[n];
        int n4 = n2;
        nArray[n4] = nArray[n4] + 1;
    }

    public int size() {
        return this.sizes.size();
    }

    public int size(int n) {
        return this.sizes.get(n);
    }

    public int max(int n) {
        if (n < 0 || n >= this.sizes.size()) {
            throw new ArrayIndexOutOfBoundsException("Attempted to access negative index of IVector2D.");
        }
        int n2 = Integer.MIN_VALUE;
        int n3 = this.sizes.get(n);
        for (int i = 0; i < n3; ++i) {
            if (this.vector[n][i] <= n2) continue;
            n2 = this.vector[n][i];
        }
        return n2;
    }

    public void sort(int n) {
        Arrays.sort(this.vector[n], 0, this.sizes.get(n));
    }

    public int binarySearch(int n, int n2) {
        int n3 = 0;
        int n4 = this.sizes.get(n);
        while (n4 != n3) {
            int n5 = n3 + n4 >> 1;
            if (this.vector[n][n5] > n2) {
                n4 = n5;
                continue;
            }
            if (this.vector[n][n5] < n2) {
                n3 = n5 + 1;
                continue;
            }
            return n5;
        }
        return -n3 - 1;
    }

    protected void expandFor(int n, int n2, int n3) {
        int n4;
        int n5;
        if (n >= this.sizes.size()) {
            n5 = this.sizes.size();
            this.sizes.set(n, 0);
            if (n4 < this.sizes.size()) {
                for (n4 = this.vector.length; n4 < this.sizes.size(); n4 *= 2) {
                }
                int[][] nArrayArray = new int[n4][];
                System.arraycopy(this.vector, 0, nArrayArray, 0, n5);
                this.vector = nArrayArray;
            }
            for (int i = n5; i < this.sizes.size(); ++i) {
                this.vector[i] = new int[this.defaultCapacity2];
            }
        }
        if (n2 < this.sizes.get(n)) {
            return;
        }
        n5 = this.sizes.get(n);
        this.sizes.set(n, n2 + 1);
        if (n4 >= this.sizes.get(n)) {
            return;
        }
        for (n4 = this.vector[n].length; n4 < this.sizes.get(n); n4 *= 2) {
        }
        int[] nArray = new int[n4];
        System.arraycopy(this.vector[n], 0, nArray, 0, n5);
        if (n3 != 0) {
            Arrays.fill(nArray, n5, this.sizes.get(n), n3);
        }
        this.vector[n] = nArray;
    }

    public int[][] toArray() {
        int[][] nArrayArray = new int[this.sizes.size()][];
        for (int i = 0; i < nArrayArray.length; ++i) {
            nArrayArray[i] = new int[this.sizes.get(i)];
            System.arraycopy(this.vector[i], 0, nArrayArray[i], 0, nArrayArray[i].length);
        }
        return nArrayArray;
    }

    public boolean equals(Object object) {
        if (!(object instanceof IVector2D)) {
            return false;
        }
        IVector2D iVector2D = (IVector2D)object;
        if (this.vector.length != iVector2D.vector.length || !this.sizes.equals(iVector2D.sizes)) {
            return false;
        }
        for (int i = 0; i < this.vector.length; ++i) {
            if (Arrays.equals(this.vector[i], iVector2D.vector[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = this.vector.hashCode();
        for (int i = 0; i < this.vector.length; ++i) {
            n = 17 * n + this.vector[i].hashCode();
        }
        return n;
    }

    public Object clone() {
        IVector2D iVector2D = null;
        try {
            iVector2D = (IVector2D)super.clone();
        }
        catch (Exception exception) {
            System.err.println("Error cloning " + this.getClass().getName() + ":");
            exception.printStackTrace();
            System.exit(1);
        }
        iVector2D.vector = (int[][])this.vector.clone();
        for (int i = 0; i < this.vector.length; ++i) {
            if (iVector2D.vector[i] == null) continue;
            iVector2D.vector[i] = (int[])this.vector[i].clone();
        }
        return iVector2D;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        int n = this.sizes.size();
        for (int i = 0; i < n; ++i) {
            int n2 = this.sizes.get(i);
            stringBuffer.append("[");
            for (int j = 0; j < n2; ++j) {
                stringBuffer.append(this.vector[i][j]);
                if (j + 1 >= n2) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append("]");
            if (i + 1 >= n) continue;
            stringBuffer.append(",\n ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public void write(ExceptionlessOutputStream exceptionlessOutputStream) {
        this.sizes.write(exceptionlessOutputStream);
        for (int i = 0; i < this.sizes.size(); ++i) {
            for (int j = 0; j < this.sizes.get(i); ++j) {
                exceptionlessOutputStream.writeInt(this.vector[i][j]);
            }
        }
        exceptionlessOutputStream.writeInt(this.defaultCapacity2);
    }

    public void read(ExceptionlessInputStream exceptionlessInputStream) {
        this.sizes = new IVector();
        this.sizes.read(exceptionlessInputStream);
        if (this.sizes.size() == 0) {
            this.defaultCapacity2 = 8;
            this.vector = new int[8][this.defaultCapacity2];
        } else {
            this.vector = new int[this.sizes.size()][];
            for (int i = 0; i < this.vector.length; ++i) {
                this.vector[i] = new int[this.sizes.get(i)];
                for (int j = 0; j < this.vector[i].length; ++j) {
                    this.vector[i][j] = exceptionlessInputStream.readInt();
                }
            }
            this.defaultCapacity2 = exceptionlessInputStream.readInt();
        }
    }
}

