/*
 * Decompiled with CFR 0.152.
 */
package com.nexagis.jawbone.filter;

import rita.wordnet.RiFilter;

public final class SimilarFilter
extends RiFilter {
    private String term = null;
    private int maxScore = 0;
    private static int DEFAULT_MAX_SCORE = 5;

    private SimilarFilter() {
    }

    public SimilarFilter(String word, boolean bIgnoreCase) {
        this(word, bIgnoreCase, DEFAULT_MAX_SCORE);
    }

    public SimilarFilter(String word, boolean bIgnoreCase, int maxDistance) {
        this.term = word;
        ignoreCase = bIgnoreCase;
        this.maxScore = maxDistance;
    }

    public boolean accept(String word) {
        if (word == null && this.term == null) {
            return true;
        }
        if (word == null || this.term == null) {
            return false;
        }
        int score = 0;
        score = ignoreCase ? this.getScore(this.term.toUpperCase(), word.toUpperCase()) : this.getScore(this.term, word);
        return score <= this.maxScore;
    }

    private static int minimum(int a, int b, int c) {
        return Math.min(a, Math.min(b, c));
    }

    private int getScore(String s, String t) {
        int n = s.length();
        int m = t.length();
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        int[][] d = new int[n + 1][m + 1];
        int i = 0;
        while (i <= n) {
            d[i][0] = i;
            ++i;
        }
        int j = 0;
        while (j <= m) {
            d[0][j] = j;
            ++j;
        }
        i = 1;
        while (i <= n) {
            char s_i = s.charAt(i - 1);
            j = 1;
            while (j <= m) {
                char t_j = t.charAt(j - 1);
                int cost = s_i == t_j ? 0 : 1;
                d[i][j] = SimilarFilter.minimum(d[i - 1][j] + 1, d[i][j - 1] + 1, d[i - 1][j - 1] + cost);
                ++j;
            }
            ++i;
        }
        return d[n][m];
    }

    public void setMaxDistance(int dist) {
        this.maxScore = dist;
    }

    public int getMaxScore() {
        return this.maxScore;
    }

    public void setMaxScore(int maxScore) {
        this.maxScore = maxScore;
    }
}

