/*
 * Decompiled with CFR 0.152.
 */
package com.nexagis.jawbone.filter;

import rita.wordnet.RiFilter;

public final class SoundFilter
extends RiFilter {
    private String termCode = null;

    private SoundFilter() {
    }

    public SoundFilter(String word, boolean bIgnoreCase) {
        this.termCode = SoundFilter.getSoundexCode(word);
        ignoreCase = bIgnoreCase;
    }

    public boolean accept(String word) {
        String wordCode = SoundFilter.getSoundexCode(word);
        if (ignoreCase) {
            return wordCode.equalsIgnoreCase(this.termCode);
        }
        return wordCode.equals(this.termCode);
    }

    private static int getIntValue(char ch) {
        int n = 0;
        switch (ch) {
            case 'b': 
            case 'f': 
            case 'p': 
            case 'v': {
                n = 1;
                break;
            }
            case 'c': 
            case 'g': 
            case 'j': 
            case 'k': 
            case 'q': 
            case 's': 
            case 'x': 
            case 'z': {
                n = 2;
                break;
            }
            case 'd': 
            case 't': {
                n = 3;
                break;
            }
            case 'l': {
                n = 4;
                break;
            }
            case 'm': 
            case 'n': {
                n = 5;
                break;
            }
            case 'r': {
                n = 6;
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }

    private static String getSoundexCode(String sInput) {
        if (sInput == null || sInput.length() < 1) {
            return "";
        }
        StringBuilder buf = new StringBuilder(10);
        buf.append(sInput.charAt(0));
        String sWord = sInput.toLowerCase();
        int nPrevValue = SoundFilter.getIntValue(sWord.charAt(0));
        int nCurrValue = -1;
        int nLen = sWord.length();
        int i = 1;
        while (i < nLen && buf.length() < 4) {
            nCurrValue = SoundFilter.getIntValue(sWord.charAt(i));
            if (nCurrValue != nPrevValue && nCurrValue != 0) {
                buf.append(Integer.toString(nCurrValue));
            }
            nPrevValue = nCurrValue;
            ++i;
        }
        int nSize = buf.length() - 4;
        if (nSize < 0) {
            while (nSize < 0) {
                buf.append("0");
                ++nSize;
            }
        }
        return buf.toString();
    }
}

