/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.cs.cogcomp.lbj.pos;

import LBJ2.learn.Learner;
import LBJ2.nlp.Word;
import LBJ2.util.ExceptionlessInputStream;
import LBJ2.util.ExceptionlessOutputStream;
import edu.illinois.cs.cogcomp.lbj.pos.POSBaselineLearner;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class MikheevLearner
extends POSBaselineLearner {
    protected HashMap<String, TreeMap<String, Integer>> firstCapitalized = new HashMap();
    protected HashMap<String, TreeMap<String, Integer>> notFirstCapitalized = new HashMap();

    public MikheevLearner() {
        this("");
    }

    public MikheevLearner(String string) {
        super(string);
    }

    public MikheevLearner(Parameters parameters) {
        this("");
    }

    @Override
    public Learner emptyClone() {
        return new MikheevLearner();
    }

    private void increment(HashMap<String, TreeMap<String, Integer>> hashMap, String string, String string2) {
        Integer n;
        TreeMap<String, Integer> treeMap = hashMap.get(string);
        if (treeMap == null) {
            treeMap = new TreeMap();
            hashMap.put(string, treeMap);
        }
        if ((n = treeMap.get(string2)) == null) {
            n = 0;
        }
        treeMap.put(string2, n + 1);
    }

    @Override
    public void learn(Object object) {
        String string = this.extractor.discreteValue(object);
        String string2 = this.labeler.discreteValue(object);
        if (string.length() >= 5) {
            boolean bl = true;
            for (int i = string.length() - 3; i < string.length() && bl; ++i) {
                bl = Character.isLetter(string.charAt(i));
            }
            if (bl) {
                Word word = (Word)object;
                HashMap<Object, Object> hashMap = null;
                if (word.capitalized) {
                    hashMap = word.previous == null ? this.firstCapitalized : this.notFirstCapitalized;
                } else {
                    if (string.indexOf("-") != -1) {
                        return;
                    }
                    hashMap = this.table;
                }
                string = string.toLowerCase();
                this.increment((HashMap<String, TreeMap<String, Integer>>)hashMap, string.substring(string.length() - 3), string2);
                if (string.length() >= 6 && Character.isLetter(string.charAt(string.length() - 4))) {
                    this.increment((HashMap<String, TreeMap<String, Integer>>)hashMap, string.substring(string.length() - 4), string2);
                }
            }
        }
    }

    @Override
    public void doneLearning() {
        this.prune(this.table);
        this.prune(this.firstCapitalized);
        this.prune(this.notFirstCapitalized);
    }

    @Override
    public void forget() {
        super.forget();
        this.firstCapitalized.clear();
        this.notFirstCapitalized.clear();
    }

    public void prune(HashMap<String, TreeMap<String, Integer>> hashMap) {
        Iterator<Map.Entry<String, TreeMap<String, Integer>>> iterator = hashMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, TreeMap<String, Integer>> entry = iterator.next();
            int n = 0;
            for (Integer n2 : entry.getValue().values()) {
                n += n2.intValue();
            }
            Iterator<Object> iterator2 = entry.getValue().entrySet().iterator();
            while (iterator2.hasNext()) {
                int n3 = (Integer)((Map.Entry)iterator2.next()).getValue();
                if (n3 * 100 >= n) continue;
                n -= n3;
                iterator2.remove();
            }
            if (n > 10) continue;
            iterator.remove();
        }
    }

    public Set<String> allowableTags(Word word) {
        Set<String> set = this.allowableTags(word.form);
        if (set.size() > 0) {
            return set;
        }
        if (word.capitalized) {
            String string;
            HashMap<String, TreeMap<String, Integer>> hashMap = null;
            hashMap = word.previous == null ? this.firstCapitalized : this.notFirstCapitalized;
            if (word.form.length() >= 6 && hashMap.containsKey(string = word.form.substring(word.form.length() - 4).toLowerCase())) {
                set = hashMap.get(string).keySet();
            }
            if (set.size() == 0 && word.form.length() >= 5 && hashMap.containsKey(string = word.form.substring(word.form.length() - 3).toLowerCase())) {
                set = hashMap.get(string).keySet();
            }
            if (set.size() == 0) {
                set.add("NNP");
            }
        } else if (word.form.indexOf("-") != -1) {
            set.add("NN");
            set.add("JJ");
        } else {
            String string;
            if (word.form.length() >= 6 && this.table.containsKey(string = word.form.substring(word.form.length() - 4).toLowerCase())) {
                set = ((TreeMap)this.table.get(string)).keySet();
            }
            if (set.size() == 0 && word.form.length() >= 5 && this.table.containsKey(string = word.form.substring(word.form.length() - 3).toLowerCase())) {
                set = ((TreeMap)this.table.get(string)).keySet();
            }
            if (set.size() == 0) {
                set.add("NN");
            }
        }
        return set;
    }

    @Override
    public void write(PrintStream printStream) {
        printStream.println("# if capitalized and first word in sentence:");
        MikheevLearner.write(printStream, this.firstCapitalized);
        printStream.println("\n# if capitalized and not first word in sentence:");
        MikheevLearner.write(printStream, this.notFirstCapitalized);
        printStream.println("\n# main table:");
        MikheevLearner.write(printStream, (HashMap<String, TreeMap<String, Integer>>)this.table);
    }

    @Override
    public void write(ExceptionlessOutputStream exceptionlessOutputStream) {
        super.write(exceptionlessOutputStream);
        POSBaselineLearner.write(exceptionlessOutputStream, this.firstCapitalized);
        POSBaselineLearner.write(exceptionlessOutputStream, this.notFirstCapitalized);
    }

    @Override
    public void read(ExceptionlessInputStream exceptionlessInputStream) {
        super.read(exceptionlessInputStream);
        POSBaselineLearner.read(exceptionlessInputStream, this.firstCapitalized);
        POSBaselineLearner.read(exceptionlessInputStream, this.notFirstCapitalized);
    }

    public static class Parameters
    extends Learner.Parameters {
        public Parameters() {
        }

        public Parameters(Parameters parameters) {
            super(parameters);
        }
    }
}

