/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.cs.cogcomp.lbj.pos;

import LBJ2.classify.DiscretePrimitiveStringFeature;
import LBJ2.classify.Feature;
import LBJ2.classify.FeatureVector;
import LBJ2.classify.ScoreSet;
import LBJ2.learn.Learner;
import LBJ2.util.ExceptionlessInputStream;
import LBJ2.util.ExceptionlessOutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class POSBaselineLearner
extends Learner {
    protected HashMap<String, TreeMap<String, Integer>> table = new HashMap();

    public POSBaselineLearner() {
        this("");
    }

    public POSBaselineLearner(String string) {
        super(string);
    }

    public POSBaselineLearner(Parameters parameters) {
        this("");
    }

    @Override
    public Learner emptyClone() {
        return new POSBaselineLearner();
    }

    @Override
    public String getInputType() {
        return "LBJ2.nlp.Word";
    }

    @Override
    public void learn(Object object) {
        String string;
        Integer n;
        String string2 = this.extractor.discreteValue(object);
        TreeMap<String, Integer> treeMap = this.table.get(string2);
        if (treeMap == null) {
            treeMap = new TreeMap();
            this.table.put(string2, treeMap);
        }
        if ((n = treeMap.get(string = this.labeler.discreteValue(object))) == null) {
            n = 0;
        }
        treeMap.put(string, n + 1);
    }

    @Override
    public void learn(int[] nArray, double[] dArray, int[] nArray2, double[] dArray2) {
    }

    @Override
    public void forget() {
        this.table.clear();
    }

    public static boolean looksLikeNumber(String string) {
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isDigit(string.charAt(i))) {
                bl = true;
                continue;
            }
            if (".,-".indexOf(string.charAt(i)) != -1) continue;
            return false;
        }
        return bl;
    }

    @Override
    public String discreteValue(Object object) {
        return this.computePrediction(object);
    }

    protected String computePrediction(Object object) {
        String string = this.extractor.discreteValue(object);
        TreeMap<String, Integer> treeMap = this.table.get(string);
        String string2 = null;
        if (treeMap == null) {
            string2 = string.equals(";") ? ":" : (POSBaselineLearner.looksLikeNumber(string) ? "CD" : "UNKNOWN");
        } else {
            int n = 0;
            for (Map.Entry<String, Integer> entry : treeMap.entrySet()) {
                int n2 = entry.getValue();
                if (n2 <= n) continue;
                n = n2;
                string2 = entry.getKey();
            }
        }
        return string2;
    }

    @Override
    public Feature featureValue(Object object) {
        return new DiscretePrimitiveStringFeature(this.containingPackage, this.name, "", this.computePrediction(object));
    }

    @Override
    public FeatureVector classify(Object object) {
        return new FeatureVector(this.featureValue(object));
    }

    @Override
    public FeatureVector classify(int[] nArray, double[] dArray) {
        return new FeatureVector();
    }

    @Override
    public ScoreSet scores(int[] nArray, double[] dArray) {
        return null;
    }

    public boolean observed(String string) {
        return this.table.containsKey(string);
    }

    public int observedCount(String string) {
        if (!this.table.containsKey(string)) {
            return 0;
        }
        int n = 0;
        for (Integer n2 : this.table.get(string).values()) {
            n += n2.intValue();
        }
        return n;
    }

    public Set<String> allowableTags(String string) {
        if (!this.table.containsKey(string)) {
            HashSet<String> hashSet = new HashSet<String>();
            if (string.equals(";")) {
                hashSet.add(":");
            } else if (POSBaselineLearner.looksLikeNumber(string)) {
                hashSet.add("CD");
            }
            return hashSet;
        }
        return this.table.get(string).keySet();
    }

    @Override
    public void write(PrintStream printStream) {
        POSBaselineLearner.write(printStream, this.table);
    }

    public static void write(PrintStream printStream, HashMap<String, TreeMap<String, Integer>> hashMap) {
        Object[] objectArray = hashMap.keySet().toArray(new String[0]);
        Arrays.sort(objectArray);
        for (int i = 0; i < objectArray.length; ++i) {
            int n;
            printStream.print((String)objectArray[i] + ":");
            TreeMap<String, Integer> treeMap = hashMap.get(objectArray[i]);
            String[] stringArray = treeMap.keySet().toArray(new String[0]);
            final Integer[] integerArray = treeMap.values().toArray(new Integer[0]);
            Integer[] integerArray2 = new Integer[stringArray.length];
            for (n = 0; n < stringArray.length; ++n) {
                integerArray2[n] = n;
            }
            Arrays.sort(integerArray2, new Comparator<Integer>(){

                @Override
                public int compare(Integer n, Integer n2) {
                    return integerArray[n2] - integerArray[n];
                }
            });
            for (n = 0; n < integerArray2.length; ++n) {
                printStream.print(" " + stringArray[integerArray2[n]] + "(" + integerArray[integerArray2[n]] + ")");
            }
            printStream.println();
        }
    }

    @Override
    public void write(ExceptionlessOutputStream exceptionlessOutputStream) {
        super.write(exceptionlessOutputStream);
        POSBaselineLearner.write(exceptionlessOutputStream, this.table);
    }

    protected static void write(ExceptionlessOutputStream exceptionlessOutputStream, HashMap<String, TreeMap<String, Integer>> hashMap) {
        exceptionlessOutputStream.writeInt(hashMap.size());
        for (Map.Entry<String, TreeMap<String, Integer>> entry : hashMap.entrySet()) {
            exceptionlessOutputStream.writeString(entry.getKey());
            exceptionlessOutputStream.writeInt(entry.getValue().size());
            for (Map.Entry<String, Integer> entry2 : entry.getValue().entrySet()) {
                exceptionlessOutputStream.writeString(entry2.getKey());
                exceptionlessOutputStream.writeInt(entry2.getValue());
            }
        }
    }

    @Override
    public void read(ExceptionlessInputStream exceptionlessInputStream) {
        super.read(exceptionlessInputStream);
        this.forget();
        POSBaselineLearner.read(exceptionlessInputStream, this.table);
    }

    protected static void read(ExceptionlessInputStream exceptionlessInputStream, HashMap<String, TreeMap<String, Integer>> hashMap) {
        int n = exceptionlessInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            String string = exceptionlessInputStream.readString();
            TreeMap<String, Integer> treeMap = new TreeMap<String, Integer>();
            hashMap.put(string, treeMap);
            int n2 = exceptionlessInputStream.readInt();
            for (int j = 0; j < n2; ++j) {
                treeMap.put(exceptionlessInputStream.readString(), exceptionlessInputStream.readInt());
            }
        }
    }

    public static class Parameters
    extends Learner.Parameters {
        public Parameters() {
        }

        public Parameters(Parameters parameters) {
            super(parameters);
        }
    }
}

