/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.cs.cogcomp.lbj.pos;

import LBJ2.nlp.POSBracketToVector;
import LBJ2.nlp.Word;
import LBJ2.parse.LinkedVector;
import edu.illinois.cs.cogcomp.lbj.pos.POSTagger;
import java.io.BufferedReader;
import java.io.FileReader;

public class POSTag {
    private static String testingFile;

    public static void main(String[] stringArray) {
        if ((stringArray.length != 1 || stringArray[0].startsWith("-")) && (stringArray.length != 2 || !stringArray[0].equals("-q") && !stringArray[0].equals("--quiet") || stringArray[1].startsWith("-"))) {
            System.err.println("usage: java edu.illinois.cs.cogcomp.lbj.pos.POSTag [-q] <testing set>\n       If -q is specified, the only output is timing and accuracy\n       information.  Otherwise, the testing set is output with\n       extra tags indicating whether each prediction was correct.");
            System.exit(1);
        }
        boolean bl = stringArray.length == 2;
        testingFile = stringArray[stringArray.length - 1];
        POSTagger pOSTagger = new POSTagger();
        BufferedReader bufferedReader = POSTag.open();
        int n = 0;
        int n2 = 0;
        String string = POSTag.readLine(bufferedReader);
        while (string != null) {
            LinkedVector linkedVector = POSBracketToVector.parsePOSBracketForm(string);
            Word word = (Word)linkedVector.get(0);
            while (word != null) {
                String string2 = word.partOfSpeech;
                word.partOfSpeech = null;
                String string3 = pOSTagger.discreteValue(word);
                if (string3.equals(string2)) {
                    ++n;
                    if (!bl) {
                        System.out.print("+");
                    }
                } else {
                    ++n2;
                    if (!bl) {
                        System.out.print("-[" + string2 + "]");
                    }
                }
                if (!bl) {
                    System.out.print(word + " ");
                }
                word = (Word)word.next;
            }
            if (!bl) {
                System.out.println();
            }
            string = POSTag.readLine(bufferedReader);
        }
        System.out.println("Accuracy: " + (double)(100 * n) / (double)(n + n2) + "%");
    }

    private static BufferedReader open() {
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(testingFile));
        }
        catch (Exception exception) {
            System.err.println("Can't open " + testingFile + " for input: " + exception);
            System.exit(1);
        }
        return bufferedReader;
    }

    private static String readLine(BufferedReader bufferedReader) {
        String string = null;
        try {
            string = bufferedReader.readLine();
        }
        catch (Exception exception) {
            System.err.println("Can't read from " + testingFile + ": " + exception);
            System.exit(1);
        }
        return string;
    }
}

