/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie.pascal;

import edu.stanford.nlp.ie.pascal.Alignment;
import edu.stanford.nlp.ie.pascal.AlignmentFactory;
import edu.stanford.nlp.ie.pascal.InfoTemplate;
import edu.stanford.nlp.ie.pascal.PascalTemplate;
import edu.stanford.nlp.ie.pascal.Prior;
import edu.stanford.nlp.ie.pascal.RelationalModel;
import edu.stanford.nlp.ie.pascal.TeXHyphenator;
import edu.stanford.nlp.util.Generics;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;

public class AcronymModel
implements RelationalModel {
    private static final double HIGH_PROB = 1.0;
    private static final double LOW_PROB = 0.0;
    private static boolean DEBUG = false;
    private static final String acronymStatistics = "workshopname workshopacronym workshophomepage conferencename conferenceacronym conferencehomepage\n0.00274725274725275\n0.00274725274725275\n0.00274725274725275\n0.00274725274725275\n0.00274725274725275\n0.00274725274725275\n0.00274725274725275\n0.00274725274725275\n0.00274725274725275\n0.00274725274725275\n0.00274725274725275\n0.00274725274725275\n0.00549450549450549\n0.00274725274725275\n0.00274725274725275\n0.00274725274725275\n0.00274725274725275\n0.00274725274725275\n0.00274725274725275\n0.00274725274725275\n0.00274725274725275\n0.00274725274725275\n0.00274725274725275\n0.00274725274725275\n0.00274725274725275\n0.00274725274725275\n0.00274725274725275\n0.00274725274725275\n0.00274725274725275\n0.00274725274725275\n0.00274725274725275\n0.00274725274725275\n0.0521978021978022\n0.00274725274725275\n0.0357142857142857\n0.00549450549450549\n0.021978021978022\n0.010989010989011\n0.0357142857142857\n0.0302197802197802\n0.0824175824175824\n0.00549450549450549\n0.043956043956044\n0.010989010989011\n0.021978021978022\n0.00549450549450549\n0.0521978021978022\n0.0412087912087912\n0.0467032967032967\n0.00274725274725275\n0.010989010989011\n0.00274725274725275\n0.00274725274725275\n0.00274725274725275\n0.0137362637362637\n0.00824175824175824\n0.167582417582418\n0.00549450549450549\n0.0494505494505494\n0.00824175824175824\n0.0164835164835165\n0.00549450549450549\n0.0604395604395604\n0.0467032967032967\n";
    private Prior priors = new Prior(new BufferedReader(new StringReader("workshopname workshopacronym workshophomepage conferencename conferenceacronym conferencehomepage\n0.00274725274725275\n0.00274725274725275\n0.00274725274725275\n0.00274725274725275\n0.00274725274725275\n0.00274725274725275\n0.00274725274725275\n0.00274725274725275\n0.00274725274725275\n0.00274725274725275\n0.00274725274725275\n0.00274725274725275\n0.00549450549450549\n0.00274725274725275\n0.00274725274725275\n0.00274725274725275\n0.00274725274725275\n0.00274725274725275\n0.00274725274725275\n0.00274725274725275\n0.00274725274725275\n0.00274725274725275\n0.00274725274725275\n0.00274725274725275\n0.00274725274725275\n0.00274725274725275\n0.00274725274725275\n0.00274725274725275\n0.00274725274725275\n0.00274725274725275\n0.00274725274725275\n0.00274725274725275\n0.0521978021978022\n0.00274725274725275\n0.0357142857142857\n0.00549450549450549\n0.021978021978022\n0.010989010989011\n0.0357142857142857\n0.0302197802197802\n0.0824175824175824\n0.00549450549450549\n0.043956043956044\n0.010989010989011\n0.021978021978022\n0.00549450549450549\n0.0521978021978022\n0.0412087912087912\n0.0467032967032967\n0.00274725274725275\n0.010989010989011\n0.00274725274725275\n0.00274725274725275\n0.00274725274725275\n0.0137362637362637\n0.00824175824175824\n0.167582417582418\n0.00549450549450549\n0.0494505494505494\n0.00824175824175824\n0.0164835164835165\n0.00549450549450549\n0.0604395604395604\n0.0467032967032967\n")));
    private static final double probMatchFromAcronymAndURLMatch = 0.23934426;
    private static final double probMatchFromAcronymAndURLNoMatch = 0.052516411378;
    private final Feature[] features = new Feature[]{new LettersAligned(), new BegWord(), new EndWord(), new AfterAligned(), new AlignedPerWord(), new WordsSkipped(), new SyllableBoundary()};
    private final double[] weights = new double[]{-11.888, 14.4534, -2.6316, 24.1838, -2.232, -0.2508, 4.3501};
    private final double intercept;
    private static final String[] stringArrayType = new String[0];

    public double computeProb(InfoTemplate temp) {
        return this.computeProb(temp.wname, temp.wacronym, temp.cname, temp.cacronym, temp.whomepage, temp.chomepage);
    }

    @Override
    public double computeProb(PascalTemplate temp) {
        double prob = 1.0;
        String wsname = temp.getValue("workshopname");
        String confname = temp.getValue("conferencename");
        String wsacronym = temp.getValue("workshopacronym");
        String confacronym = temp.getValue("conferenceacronym");
        String wsurl = temp.getValue("workshophomepage");
        String confurl = temp.getValue("conferencehomepage");
        return this.computeProb(wsname, wsacronym, confname, confacronym, wsurl, confurl);
    }

    public AcronymModel() throws IOException {
        this.intercept = -2.2062;
    }

    private double computeProb(String wsname, String wsacronym, String confname, String confacronym, String wsurl, String confurl) {
        Set<String> presentFields = Generics.newHashSet();
        if (wsname != null && !wsname.equals("null") && !wsname.equals("")) {
            presentFields.add("workshopname");
        }
        if (wsacronym != null && !wsacronym.equals("null") && !wsacronym.equals("")) {
            presentFields.add("workshopacronym");
        }
        if (confname != null && !confname.equals("null") && !confname.equals("")) {
            presentFields.add("conferencename");
        }
        if (confacronym != null && !confacronym.equals("null") && !confacronym.equals("")) {
            presentFields.add("conferenceacronym");
        }
        if (wsurl != null && !wsurl.equals("null") && !wsurl.equals("")) {
            presentFields.add("workshophomepage");
        }
        if (confurl != null && !confurl.equals("null") && !confurl.equals("")) {
            presentFields.add("conferencehomepage");
        }
        if (presentFields.contains("conferenceacronym") && presentFields.contains("workshopacronym") && confacronym.equals(wsacronym)) {
            return 0.0;
        }
        double prob = this.priors.get(presentFields);
        if (wsname != null && wsacronym != null) {
            if (DEBUG) {
                System.err.println("computing similarity for workshop");
            }
            prob *= this.similarity(wsname, wsacronym);
        } else if (DEBUG) {
            System.err.println("NOT computing similarity for workshop");
        }
        if (confname != null && confacronym != null) {
            if (DEBUG) {
                System.err.println("computing similarity for conference");
            }
            prob *= this.similarity(confname, confacronym);
        } else if (DEBUG) {
            System.err.println("NOT computing similarity for conference");
        }
        if (confacronym != null && confurl != null) {
            prob = AcronymModel.acronymMatchesURL(confacronym, confurl) ? (prob *= 0.23934426) : (prob *= 0.052516411378);
        }
        if (wsacronym != null && wsurl != null) {
            prob = AcronymModel.acronymMatchesURL(wsacronym, wsurl) ? (prob *= 0.23934426) : (prob *= 0.052516411378);
        }
        return prob;
    }

    private static boolean acronymMatchesURL(String ac, String url) {
        String strippedAc;
        String lowerURL = url.toLowerCase();
        return lowerURL.indexOf(strippedAc = new String(AcronymModel.stripAcronym(ac)).toLowerCase()) != -1;
    }

    private static String acronymNumber(String acronym) {
        return "";
    }

    public static double URLSimilarity(String URL2, String acronym) {
        String strippedAc = new String(AcronymModel.stripAcronym(acronym));
        String acNumber = AcronymModel.acronymNumber(acronym);
        return 0.0;
    }

    public double similarity(String name, String acronym) {
        return this.RichSimilarity(name, acronym);
    }

    public double naiveSimilarity(String name, String acronym) {
        double similarity = 0.0;
        String[] nameWords = AcronymModel.splitOnWhitespace(name);
        String[] acronymWords = AcronymModel.splitOnWhitespace(acronym);
        char[] acLetters = AcronymModel.allLetters(acronymWords);
        char[] nameFirstLetters = AcronymModel.firstLetters(nameWords);
        if (AcronymModel.firstLetterInOrderMatch(nameFirstLetters, acLetters)) {
            similarity = 1.0;
        }
        if (DEBUG) {
            System.err.println("Similarity between (" + name + ") and (" + acronym + ") is " + similarity);
        }
        return similarity;
    }

    public double HearstSimilarity(String name, String acronym) {
        char[] namechars = name.toLowerCase().toCharArray();
        char[] acrochars = acronym.toLowerCase().toCharArray();
        int nindex = namechars.length - 1;
        for (int aindex = acrochars.length - 1; aindex >= 0; --aindex) {
            if (!Character.isLetter(acrochars[aindex])) continue;
            while (nindex >= 0 && namechars[nindex] != acrochars[aindex] || aindex == 0 && nindex > 0 && Character.isLetterOrDigit(namechars[nindex - 1])) {
                --nindex;
            }
            if (nindex < 0) {
                return 0.0;
            }
            --nindex;
        }
        return 1.0;
    }

    public static char[] stripAcronym(String acronym) {
        char[] raw = acronym.toCharArray();
        char[] firstTry = new char[raw.length];
        int outIdx = 0;
        for (int inIdx = 0; inIdx < raw.length; ++inIdx) {
            if (!Character.isLetter(raw[inIdx])) continue;
            firstTry[outIdx++] = raw[inIdx];
        }
        if (outIdx == firstTry.length) {
            if (DEBUG) {
                System.out.println("Converted \"" + acronym + "\" to \"" + new String(firstTry) + "\"\n");
            }
            return firstTry;
        }
        char[] polished = new char[outIdx];
        System.arraycopy(firstTry, 0, polished, 0, outIdx);
        if (DEBUG) {
            System.out.println("Converted \"" + acronym + "\" to \"" + new String(polished) + "\"\n");
        }
        return polished;
    }

    public double RichSimilarity(String name, String acronym) {
        AlignmentFactory fact = new AlignmentFactory(name.toCharArray(), AcronymModel.stripAcronym(acronym));
        double maxprob = 0.0;
        Iterator<Alignment> iter = fact.getAlignments();
        while (iter.hasNext()) {
            Alignment align = iter.next();
            double[] featureVals = new double[this.features.length];
            for (int f = 0; f < this.features.length; ++f) {
                featureVals[f] = this.features[f].value(align);
            }
            double dotprod = AcronymModel.dotproduct(this.weights, featureVals) + this.intercept;
            double exp = Math.exp(dotprod);
            double prob = exp / (1.0 + exp);
            if (!(prob > maxprob)) continue;
            maxprob = prob;
        }
        return maxprob;
    }

    private static double dotproduct(double[] one, double[] two) {
        double sum = 0.0;
        for (int i = 0; i < one.length; ++i) {
            double product = one[i] * two[i];
            if (DEBUG) {
                System.out.println("product: " + product);
            }
            sum += product;
        }
        if (DEBUG) {
            System.out.println("sum: " + sum);
        }
        return sum;
    }

    private static String[] splitOnWhitespace(String words) {
        String[] firstCut = words.split("\\s+");
        ArrayList<String> wordList = new ArrayList<String>(firstCut.length);
        for (int i = 0; i < firstCut.length; ++i) {
            if (firstCut[i].length() <= 0) continue;
            wordList.add(firstCut[i]);
        }
        return wordList.toArray(stringArrayType);
    }

    private static boolean firstLetterInOrderMatch(char[] nameFirstLetters, char[] acLetters) {
        int nameIdx = 0;
        for (int acIdx = 0; acIdx < acLetters.length; ++acIdx) {
            while (nameIdx < nameFirstLetters.length && nameFirstLetters[nameIdx] != acLetters[acIdx]) {
                ++nameIdx;
            }
            if (nameIdx != nameFirstLetters.length) continue;
            return false;
        }
        return true;
    }

    private static char[] allLetters(String[] acronym) {
        StringBuffer sb = new StringBuffer();
        for (int s = 0; s < acronym.length; ++s) {
            String acr = acronym[s];
            for (int c = 0; c < acr.length(); ++c) {
                char ch = acr.charAt(c);
                if (!Character.isLetter(ch)) continue;
                sb.append(ch);
            }
        }
        return AcronymModel.sbToChars(sb);
    }

    private static char[] firstLetters(String[] name) {
        StringBuffer sb = new StringBuffer(name.length);
        for (int s = 0; s < name.length; ++s) {
            char c = name[s].charAt(0);
            if (!Character.isLetter(c)) continue;
            sb.append(c);
        }
        return AcronymModel.sbToChars(sb);
    }

    private static char[] sbToChars(StringBuffer sb) {
        char[] letters = new char[sb.length()];
        sb.getChars(0, sb.length(), letters, 0);
        return letters;
    }

    public static void main(String[] args) throws Exception {
        AcronymModel am = new AcronymModel();
        String s1 = args[0];
        String s2 = args[1];
        System.out.println("Hearst:  " + am.HearstSimilarity(s1, s2));
        System.out.println("naive:   " + am.naiveSimilarity(s1, s2));
        System.out.println("Rich:    " + am.RichSimilarity(s1, s2));
        System.out.println("default: " + am.similarity(s1, s2));
    }

    public static class SyllableBoundary
    implements Feature {
        TeXHyphenator teXHyphenator = new TeXHyphenator();

        @Override
        public String toString() {
            return "SyllableBoundary";
        }

        public SyllableBoundary() throws IOException {
            this.teXHyphenator.loadDefault();
        }

        @Override
        public double value(Alignment alignment) {
            char[] lcLongForm = new String(alignment.longForm).toLowerCase().toCharArray();
            boolean[] breakPoints = this.teXHyphenator.findBreakPoints(lcLongForm);
            int numSylAligned = 0;
            for (int i = 0; i < alignment.pointers.length; ++i) {
                if (alignment.pointers[i] == -1 || !breakPoints[alignment.pointers[i]]) continue;
                ++numSylAligned;
            }
            return (double)numSylAligned / (double)alignment.pointers.length;
        }
    }

    public static class WordsSkipped
    implements Feature {
        @Override
        public String toString() {
            return "WordsSkipped";
        }

        @Override
        public double value(Alignment alignment) {
            int wordsSkipped = 0;
            int wordsAligned = 0;
            boolean inWord = false;
            boolean gotAlignedChar = false;
            boolean[] isAligned = new boolean[alignment.longForm.length];
            for (int s = 0; s < alignment.pointers.length; ++s) {
                if (alignment.pointers[s] == -1) continue;
                isAligned[alignment.pointers[s]] = true;
            }
            for (int l = 0; l < alignment.longForm.length; ++l) {
                char cur = alignment.longForm[l];
                if (inWord) {
                    if (!Character.isLetterOrDigit(cur)) {
                        if (gotAlignedChar) {
                            ++wordsAligned;
                        } else {
                            ++wordsSkipped;
                        }
                        inWord = false;
                    }
                } else if (Character.isLetterOrDigit(cur)) {
                    inWord = true;
                    gotAlignedChar = false;
                }
                if (!isAligned[l]) continue;
                gotAlignedChar = true;
            }
            if (inWord) {
                if (gotAlignedChar) {
                    ++wordsAligned;
                } else {
                    ++wordsSkipped;
                }
            }
            if (DEBUG) {
                System.out.println("Words skipped: " + wordsSkipped + "/" + (wordsSkipped + wordsAligned));
            }
            return wordsSkipped;
        }
    }

    public static class AlignedPerWord
    implements Feature {
        @Override
        public String toString() {
            return "AlignedPerWord";
        }

        @Override
        public double value(Alignment alignment) {
            boolean inWord = false;
            int wordCount = 0;
            for (int lidx = 0; lidx < alignment.longForm.length; ++lidx) {
                char cur = alignment.longForm[lidx];
                if (Character.isLetterOrDigit(cur) && !inWord) {
                    ++wordCount;
                    inWord = true;
                    continue;
                }
                if (!inWord || Character.isLetterOrDigit(cur)) continue;
                inWord = false;
            }
            int alignCount = 0;
            for (int sidx = 0; sidx < alignment.pointers.length; ++sidx) {
                if (alignment.pointers[sidx] == -1) continue;
                ++alignCount;
            }
            if (wordCount == 0) {
                return 0.0;
            }
            return (double)alignCount / (double)wordCount;
        }
    }

    private static class RunningAverage {
        double average = 0.0;
        int numSamples = 0;

        public void addSample(double sample) {
            this.average = (double)this.numSamples * this.average + sample;
            ++this.numSamples;
            this.average /= (double)this.numSamples;
        }

        public double getAverage() {
            return this.average;
        }

        public double getNumSammples() {
            return this.numSamples;
        }
    }

    public static class AfterAligned
    implements Feature {
        @Override
        public String toString() {
            return "AfterAligned";
        }

        @Override
        public double value(Alignment alignment) {
            int numAfter = 0;
            for (int i = 1; i < alignment.pointers.length; ++i) {
                if (alignment.pointers[i] != alignment.pointers[i - 1] + 1) continue;
                ++numAfter;
            }
            return (double)numAfter / (double)alignment.shortForm.length;
        }
    }

    public static class EndWord
    implements Feature {
        @Override
        public String toString() {
            return "EndWord";
        }

        @Override
        public double value(Alignment alignment) {
            int endAligned = 0;
            for (int s = 0; s < alignment.pointers.length; ++s) {
                int idx = alignment.pointers[s];
                if (idx == alignment.longForm.length - 1) {
                    ++endAligned;
                    continue;
                }
                if (idx < 0) continue;
                char cur = alignment.longForm[idx];
                char next = alignment.longForm[idx + 1];
                if (Character.isLetterOrDigit(next) || !Character.isLetterOrDigit(cur)) continue;
                ++endAligned;
            }
            return (double)endAligned / (double)alignment.shortForm.length;
        }
    }

    public static class BegWord
    implements Feature {
        @Override
        public String toString() {
            return "BegWord";
        }

        @Override
        public double value(Alignment alignment) {
            int begAligned = 0;
            for (int s = 0; s < alignment.pointers.length; ++s) {
                int idx = alignment.pointers[s];
                if (idx == 0) {
                    ++begAligned;
                    continue;
                }
                if (idx <= 0) continue;
                char cur = alignment.longForm[idx];
                char prev = alignment.longForm[idx - 1];
                if (Character.isLetterOrDigit(prev) || !Character.isLetterOrDigit(cur)) continue;
                ++begAligned;
            }
            return (double)begAligned / (double)alignment.shortForm.length;
        }
    }

    public static class LettersAligned
    implements Feature {
        @Override
        public String toString() {
            return "LettersAligned";
        }

        @Override
        public double value(Alignment alignment) {
            int numAligned = 0;
            for (int i = 0; i < alignment.pointers.length; ++i) {
                if (alignment.pointers[i] == -1) continue;
                ++numAligned;
            }
            double pct = (double)numAligned / (double)alignment.pointers.length;
            if (DEBUG) {
                System.out.println("LettersAligned=" + pct);
            }
            return pct;
        }
    }

    public static interface Feature {
        public double value(Alignment var1);

        public String toString();
    }
}

