/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.parser.charniak.CharniakParser;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.pipeline.ParserAnnotatorUtils;
import edu.stanford.nlp.trees.EnglishGrammaticalStructureFactory;
import edu.stanford.nlp.trees.GrammaticalStructureFactory;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.util.CoreMap;
import java.util.List;
import java.util.Set;

public class CharniakParserAnnotator
implements Annotator {
    private static final boolean BUILD_GRAPHS = true;
    private final GrammaticalStructureFactory gsf = new EnglishGrammaticalStructureFactory();
    private final boolean VERBOSE;
    private final CharniakParser parser;

    public CharniakParserAnnotator(String parserModel, String parserExecutable, boolean verbose, int maxSentenceLength) {
        this.VERBOSE = verbose;
        this.parser = new CharniakParser(parserExecutable, parserModel);
        this.parser.setMaxSentenceLength(maxSentenceLength);
    }

    public CharniakParserAnnotator() {
        this.VERBOSE = false;
        this.parser = new CharniakParser();
    }

    @Override
    public void annotate(Annotation annotation) {
        if (annotation.containsKey(CoreAnnotations.SentencesAnnotation.class)) {
            for (CoreMap sentence : (List)annotation.get(CoreAnnotations.SentencesAnnotation.class)) {
                int maxSentenceLength;
                List words = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
                if (this.VERBOSE) {
                    System.err.println("Parsing: " + words);
                }
                Tree tree = (maxSentenceLength = this.parser.getMaxSentenceLength()) <= 0 || words.size() < maxSentenceLength ? this.parser.getBestParse(words) : ParserAnnotatorUtils.xTree(words);
                ParserAnnotatorUtils.fillInParseAnnotations(this.VERBOSE, true, this.gsf, sentence, tree);
            }
        } else {
            throw new RuntimeException("unable to find sentences in: " + annotation);
        }
    }

    @Override
    public Set<Annotator.Requirement> requires() {
        return TOKENIZE_AND_SSPLIT;
    }

    @Override
    public Set<Annotator.Requirement> requirementsSatisfied() {
        return PARSE_AND_TAG;
    }
}

