/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.util.Filter;
import edu.stanford.nlp.util.StringUtils;

public class ArrayStringFilter
implements Filter<String> {
    private final String[] words;
    private final int length;
    private final Mode mode;
    private static final long serialVersionUID = 1L;

    public ArrayStringFilter(Mode mode, String ... words) {
        this.mode = mode;
        this.words = new String[words.length];
        for (int i = 0; i < words.length; ++i) {
            this.words[i] = words[i];
        }
        this.length = words.length;
    }

    @Override
    public boolean accept(String input) {
        switch (this.mode) {
            case EXACT: {
                for (int i = 0; i < this.length; ++i) {
                    if (!this.words[i].equals(input)) continue;
                    return true;
                }
                return false;
            }
            case PREFIX: {
                if (input == null) {
                    return false;
                }
                for (int i = 0; i < this.length; ++i) {
                    if (!input.startsWith(this.words[i])) continue;
                    return true;
                }
                return false;
            }
            case CASE_INSENSITIVE: {
                for (int i = 0; i < this.length; ++i) {
                    if (!this.words[i].equalsIgnoreCase(input)) continue;
                    return true;
                }
                return false;
            }
        }
        throw new IllegalArgumentException("Unknown mode " + (Object)((Object)this.mode));
    }

    public String toString() {
        return this.mode.toString() + ":" + StringUtils.join(this.words, ",");
    }

    public static enum Mode {
        EXACT,
        PREFIX,
        CASE_INSENSITIVE;

    }
}

